/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.connection;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.connection.ConnectionFactory;
import org.castor.cpa.persistence.sql.connection.ConnectionProxyFactory;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.jdo.conf.DataSource;
import org.castor.jdo.conf.Param;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class DataSourceConnectionFactory
implements ConnectionFactory {
    private static final Log LOG = LogFactory.getLog(DataSourceConnectionFactory.class);
    private PersistenceFactory _factory;
    private final DataSource _confDataSource;
    private final boolean _useProxies;
    private final ClassLoader _loader;
    private javax.sql.DataSource _sqlDataSource = null;

    public static javax.sql.DataSource loadDataSource(DataSource confDataSource, ClassLoader loader) throws MappingException {
        javax.sql.DataSource sqlDataSource;
        String className = confDataSource.getClassName();
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            Class<?> dsClass = Class.forName(className, true, classLoader);
            sqlDataSource = (javax.sql.DataSource)dsClass.newInstance();
        }
        catch (Exception e) {
            String msg = Messages.format((String)"jdo.engine.classNotInstantiable", (Object)className);
            LOG.error((Object)msg, (Throwable)e);
            throw new MappingException(msg, e);
        }
        Param[] parameters = confDataSource.getParam();
        DataSourceConnectionFactory.setParameters(sqlDataSource, parameters);
        return sqlDataSource;
    }

    public static void setParameters(javax.sql.DataSource dataSource, Param[] params) throws MappingException {
        Method[] methods = dataSource.getClass().getMethods();
        for (int j = 0; j < params.length; ++j) {
            String name = DataSourceConnectionFactory.buildMethodName(params[j].getName());
            String value = params[j].getValue();
            boolean success = false;
            Exception cause = null;
            try {
                for (int i = 0; !success && i < methods.length; ++i) {
                    Method method = methods[i];
                    Class<?>[] types = method.getParameterTypes();
                    if (!method.getName().equals(name) || types.length != 1) continue;
                    if (types[0] == String.class) {
                        method.invoke((Object)dataSource, value);
                        success = true;
                        continue;
                    }
                    if (types[0] == Integer.TYPE) {
                        method.invoke((Object)dataSource, new Integer(value));
                        success = true;
                        continue;
                    }
                    if (types[0] == Long.TYPE) {
                        method.invoke((Object)dataSource, new Long(value));
                        success = true;
                        continue;
                    }
                    if (types[0] != Boolean.TYPE) continue;
                    method.invoke((Object)dataSource, new Boolean(value));
                    success = true;
                }
            }
            catch (Exception e) {
                cause = e;
            }
            if (success && cause == null) continue;
            String msg = Messages.format((String)"jdo.engine.datasourceParaFail", (Object)params[j].getName(), (Object)value);
            LOG.error((Object)msg, (Throwable)cause);
            throw new MappingException(msg, cause);
        }
    }

    public static String buildMethodName(String name) {
        StringBuffer sb = new StringBuffer("set");
        boolean first = true;
        for (int i = 0; i < name.length(); ++i) {
            char chr = name.charAt(i);
            if (first && Character.isLowerCase(chr)) {
                sb.append(Character.toUpperCase(chr));
                first = false;
                continue;
            }
            if (Character.isLetter(chr)) {
                sb.append(chr);
                first = false;
                continue;
            }
            if (chr != '-') continue;
            first = true;
        }
        return sb.toString();
    }

    public DataSourceConnectionFactory(javax.sql.DataSource datasource, boolean useProxies) {
        this._confDataSource = null;
        this._useProxies = useProxies;
        this._loader = null;
        this._sqlDataSource = datasource;
    }

    public DataSourceConnectionFactory(DataSource dataSource, boolean useProxies, ClassLoader loader) {
        this._confDataSource = dataSource;
        this._useProxies = useProxies;
        this._loader = loader;
    }

    public void initializeFactory(PersistenceFactory factory) throws MappingException {
        if (this._sqlDataSource == null) {
            this._sqlDataSource = DataSourceConnectionFactory.loadDataSource(this._confDataSource, this._loader);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using DataSource: " + this._confDataSource.getClassName()));
            }
        }
        this._factory = factory;
    }

    public Connection createConnection() throws SQLException {
        Connection connection = this._sqlDataSource.getConnection();
        if (!this._useProxies) {
            return connection;
        }
        return ConnectionProxyFactory.newConnectionProxy(connection, this.getClass().getName());
    }

    public CastorConnection createCastorConnection() throws SQLException {
        return new CastorConnection(this._factory, this.createConnection());
    }
}

