/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.connection.ConnectionFactory;
import org.castor.cpa.persistence.sql.connection.ConnectionProxyFactory;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.jdo.conf.Driver;
import org.castor.jdo.conf.Param;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class DriverConnectionFactory
implements ConnectionFactory {
    private static final Log LOG = LogFactory.getLog(DriverConnectionFactory.class);
    private PersistenceFactory _factory;
    private final Driver _driver;
    private final boolean _useProxies;
    private String _url = null;
    private Properties _props = null;

    public DriverConnectionFactory(Driver driver, boolean useProxies) {
        this._driver = driver;
        this._useProxies = useProxies;
    }

    public void initializeFactory(PersistenceFactory factory) throws MappingException {
        this._factory = factory;
        String driverName = this._driver.getClassName();
        if (driverName != null) {
            try {
                Class.forName(driverName).newInstance();
            }
            catch (InstantiationException e) {
                String msg = Messages.format((String)"jdo.engine.classNotInstantiable", (Object)driverName);
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, (Exception)e);
            }
            catch (IllegalAccessException e) {
                String msg = Messages.format((String)"jdo.engine.classNotAccessable", (Object)driverName, (Object)"constructor");
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, (Exception)e);
            }
            catch (ClassNotFoundException e) {
                String msg = "Can not load class " + driverName;
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, (Exception)e);
            }
        }
        this._url = this._driver.getUrl();
        try {
            if (DriverManager.getDriver(this._url) == null) {
                String msg = Messages.format((String)"jdo.missingDriver", (Object)this._url);
                LOG.error((Object)msg);
                throw new MappingException(msg);
            }
        }
        catch (SQLException ex) {
            throw new MappingException((Exception)ex);
        }
        this._props = new Properties();
        Enumeration<? extends Param> params = this._driver.enumerateParam();
        while (params.hasMoreElements()) {
            Param param = params.nextElement();
            this._props.put(param.getName(), param.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using driver: " + driverName));
        }
    }

    public Connection createConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this._url, this._props);
        if (!this._useProxies) {
            return connection;
        }
        return ConnectionProxyFactory.newConnectionProxy(connection, this.getClass().getName());
    }

    public CastorConnection createCastorConnection() throws SQLException {
        return new CastorConnection(this._factory, this.createConnection());
    }
}

