/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.util.Enumeration;
import java.util.Vector;
import org.castor.cpa.persistence.sql.driver.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InformixQueryExpression
extends JDBCQueryExpression {
    public InformixQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    @Override
    public String getStatement(boolean lock) {
        StringBuffer sql = new StringBuffer();
        this.addSelectClause(sql);
        this.addFromClause(sql);
        boolean first = this.addJoinClause(sql);
        this.addWhereClause(sql, first);
        this.addOrderByClause(sql);
        this.addForUpdateClause(sql, lock);
        return sql.toString();
    }

    private void addSelectClause(StringBuffer buffer) {
        buffer.append("SELECT ");
        if (this._distinct) {
            buffer.append(" DISTINCT ");
        }
        buffer.append(this.getColumnList());
    }

    private void addFromClause(StringBuffer buffer) {
        buffer.append(" FROM ");
        Enumeration<String> tables = this.getFromTables();
        while (tables.hasMoreElements()) {
            buffer.append(tables.nextElement());
            if (!tables.hasMoreElements()) continue;
            buffer.append(",");
        }
    }

    private Enumeration<String> getFromTables() {
        Vector<String> vector = new Vector<String>();
        Vector<String> outerTables = this.getOuterTables();
        Enumeration enumeration = this._tables.keys();
        while (enumeration.hasMoreElements()) {
            String tableAlias = (String)enumeration.nextElement();
            String tableName = (String)this._tables.get(tableAlias);
            StringBuffer tmp = outerTables.contains(tableAlias) ? new StringBuffer("OUTER ") : new StringBuffer();
            if (tableAlias.equals(tableName)) {
                tmp.append(this._factory.quoteName(tableName));
            } else {
                tmp.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
            }
            vector.addElement(this._factory.quoteName(tmp.toString()));
        }
        return vector.elements();
    }

    private Vector<String> getOuterTables() {
        Vector<String> tables = new Vector<String>();
        JDBCQueryExpression.Join join = null;
        for (int i = 0; i < this._joins.size(); ++i) {
            join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (!join._outer) continue;
            tables.addElement(join._rightTable);
        }
        return tables;
    }

    private boolean addJoinClause(StringBuffer buffer) {
        boolean first = true;
        for (int i = 0; i < this._joins.size(); ++i) {
            if (first) {
                buffer.append(" WHERE ");
                first = false;
            } else {
                buffer.append(" AND ");
            }
            this.addJoin(buffer, (JDBCQueryExpression.Join)this._joins.elementAt(i));
        }
        return first;
    }

    private void addJoin(StringBuffer buffer, JDBCQueryExpression.Join join) {
        for (int j = 0; j < join._leftColumns.length; ++j) {
            if (j > 0) {
                buffer.append(" AND ");
            }
            buffer.append(this.quoteTableAndColumn(join._leftTable, join._leftColumns[j]));
            buffer.append("=");
            buffer.append(this.quoteTableAndColumn(join._rightTable, join._rightColumns[j]));
        }
    }

    private String quoteTableAndColumn(String table, String column) {
        return this._factory.quoteName(table + "." + column);
    }

    private void addOrderByClause(StringBuffer buffer) {
        if (this._order != null) {
            buffer.append(" ORDER BY ").append(this._order);
        }
    }

    private void addForUpdateClause(StringBuffer buffer, boolean lock) {
        if (lock) {
            buffer.append(" FOR UPDATE");
        }
    }
}

