/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cpa.persistence.sql.driver.JDBCQueryExpression;
import org.exolab.castor.jdo.oql.SyntaxNotSupportedException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class OracleQueryExpression
extends JDBCQueryExpression {
    private static Log _log = LogFactory.getFactory().getInstance(OracleQueryExpression.class);

    public OracleQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) throws SyntaxNotSupportedException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this._distinct) {
            sql.append(" DISTINCT ");
        }
        sql.append(this.getColumnList());
        if (this._limit != null) {
            sql.append(" , rank() over ( ");
            if (this._order == null) {
                throw new SyntaxNotSupportedException("To use a LIMIT clause with Oracle, an ORDER BY clause is required.");
            }
            sql.append(" ORDER BY ").append(this._order);
            sql.append(" ) rnk ");
        }
        sql.append(" FROM ");
        Enumeration enumeration = this._tables.keys();
        while (enumeration.hasMoreElements()) {
            String tableName;
            String tableAlias = (String)enumeration.nextElement();
            if (tableAlias.equals(tableName = (String)this._tables.get(tableAlias))) {
                sql.append(this._factory.quoteName(tableName));
            } else {
                sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
            }
            if (!enumeration.hasMoreElements()) continue;
            sql.append(",");
        }
        boolean first = true;
        for (int i = 0; i < this._joins.size(); ++i) {
            if (first) {
                sql.append(" WHERE ");
                first = false;
            } else {
                sql.append(" AND ");
            }
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            for (int j = 0; j < join._leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join._leftTable + "." + join._leftColumns[j]));
                sql.append("=");
                sql.append(this._factory.quoteName(join._rightTable + "." + join._rightColumns[j]));
                if (!join._outer) continue;
                sql.append("(+)");
            }
        }
        first = this.addWhereClause(sql, first);
        if (this._order != null && this._limit == null) {
            sql.append(" ORDER BY ").append(this._order);
        }
        if (lock) {
            sql.append(" FOR UPDATE");
        }
        if (this._limit != null) {
            sql.insert(0, "select * from ( ");
            if (this._offset != null) {
                sql.append(" ) where rnk - " + this._offset + " between 1 and " + this._limit + " ");
            } else {
                sql.append(" ) where rnk <= " + this._limit + " ");
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL statement = " + sql.toString()));
        }
        return sql.toString();
    }

    public boolean isLimitClauseSupported() {
        return this._dbInfo != null ? this._dbInfo.compareDbVersion("8.1.6") >= 0 : false;
    }

    public boolean isOffsetClauseSupported() {
        return this._dbInfo != null ? this._dbInfo.compareDbVersion("8.1.6") >= 0 : false;
    }
}

