/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PostgreSQLCallQuery
implements PersistenceQuery {
    private static Log _log = LogFactory.getFactory().getInstance(PostgreSQLCallQuery.class);
    private PreparedStatement _stmt;
    private ResultSet _rs;
    private final Class<?> _javaClass;
    private final Class<?>[] _types;
    private final Object[] _values;
    private final String _call;
    private Identity _lastIdentity;
    private int[] _sqlTypes;

    PostgreSQLCallQuery(String call, Class<?>[] types, Class<?> javaClass, String[] fields, int[] sqlTypes) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                query.append(",");
            }
            query.append(fields[i]);
            query.append("(");
            query.append(call);
            query.append(")");
        }
        this._call = query.toString();
        this._types = types;
        this._javaClass = javaClass;
        this._sqlTypes = sqlTypes;
        this._values = new Object[this._types.length];
    }

    @Override
    public boolean absolute(int row) throws PersistenceException {
        return false;
    }

    @Override
    public int size() throws PersistenceException {
        return 0;
    }

    public int getParameterCount() {
        return this._types.length;
    }

    public Class<?> getParameterType(int index) throws ArrayIndexOutOfBoundsException {
        return this._types[index];
    }

    @Override
    public void setParameter(int index, Object value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        this._values[index] = value;
    }

    @Override
    public Class<?> getResultType() {
        return this._javaClass;
    }

    @Override
    public void execute(CastorConnection conn, AccessMode accessMode, boolean scrollable) throws PersistenceException {
        this.execute(conn, accessMode);
    }

    private void execute(CastorConnection conn, AccessMode accessMode) throws PersistenceException {
        this._lastIdentity = null;
        try {
            this._stmt = conn.getConnection().prepareStatement(this._call);
            int count = 1;
            for (int f = 0; f < this._sqlTypes.length; ++f) {
                for (int i = 0; i < this._values.length; ++i) {
                    this._stmt.setObject(count, this._values[i]);
                    ++count;
                }
            }
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = null;
            }
            this._stmt.execute();
            this._rs = this._stmt.executeQuery();
        }
        catch (SQLException except) {
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (SQLException e2) {
                    _log.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)e2);
                }
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
    }

    @Override
    public Identity nextIdentity(Identity identity) throws PersistenceException {
        try {
            if (this._lastIdentity == null) {
                if (!this._rs.next()) {
                    return null;
                }
                this._lastIdentity = new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0]));
                return this._lastIdentity;
            }
            while (this._lastIdentity.equals(identity)) {
                if (!this._rs.next()) {
                    this._lastIdentity = null;
                    return null;
                }
                this._lastIdentity = new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0]));
            }
            return this._lastIdentity;
        }
        catch (SQLException except) {
            this._lastIdentity = null;
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
    }

    @Override
    public void close() {
        if (this._rs != null) {
            try {
                this._rs.close();
            }
            catch (SQLException except) {
                _log.warn((Object)Messages.message((String)"persist.rsClosingFailed"), (Throwable)except);
            }
            this._rs = null;
        }
        if (this._stmt != null) {
            try {
                this._stmt.close();
            }
            catch (SQLException except) {
                _log.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)except);
            }
            this._stmt = null;
        }
    }

    @Override
    public void fetch(ProposedEntity proposedObject) throws PersistenceException {
        try {
            for (int i = 1; i < this._sqlTypes.length; ++i) {
                proposedObject.setField(SQLTypeInfos.getValue(this._rs, i + 1, this._sqlTypes[i]), i - 1);
            }
            this._lastIdentity = this._rs.next() ? new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0])) : null;
        }
        catch (SQLException except) {
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
    }
}

