/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.io.InputStream;
import java.sql.Clob;
import org.castor.cpa.persistence.sql.driver.GenericFactory;
import org.castor.cpa.persistence.sql.driver.PostgreSQLCallQuery;
import org.castor.cpa.persistence.sql.driver.PostgreSQLQueryExpression;
import org.castor.cpa.persistence.sql.query.Visitor;
import org.castor.cpa.persistence.sql.query.visitor.PostgreSQLQueryVisitor;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PostgreSQLFactory
extends GenericFactory {
    public static final String FACTORY_NAME = "postgresql";

    @Override
    public String getFactoryName() {
        return FACTORY_NAME;
    }

    @Override
    public Visitor createQueryVisitor() {
        return new PostgreSQLQueryVisitor();
    }

    @Override
    public QueryExpression getQueryExpression() {
        return new PostgreSQLQueryExpression(this);
    }

    @Override
    public String quoteName(String name) {
        return this.doubleQuoteName(name);
    }

    @Override
    public PersistenceQuery getCallQuery(String call, Class<?>[] paramTypes, Class<?> javaClass, String[] fields, int[] sqlTypes) {
        return new PostgreSQLCallQuery(call, paramTypes, javaClass, fields, sqlTypes);
    }

    @Override
    public Class<?> adjustSqlType(Class<?> sqlType) {
        if (sqlType == Clob.class) {
            return String.class;
        }
        if (sqlType == InputStream.class) {
            return byte[].class;
        }
        return sqlType;
    }

    @Override
    public boolean isKeyGeneratorIdentitySupported() {
        return true;
    }

    @Override
    public boolean isKeyGeneratorIdentityTypeSupported(int type) {
        if (type == 4) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == 3) {
            return true;
        }
        return type == -5;
    }

    @Override
    public String getIdentitySelectString(String tableName, String columnName) {
        return "SELECT currval('\"" + tableName + "_" + columnName + "_seq\"')";
    }

    @Override
    public boolean isKeyGeneratorSequenceSupported(boolean returning, boolean trigger) {
        return !returning || !trigger;
    }

    @Override
    public boolean isKeyGeneratorSequenceTypeSupported(int type) {
        if (type == 4) {
            return true;
        }
        if (type == 3) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == -5) {
            return true;
        }
        if (type == 1) {
            return true;
        }
        return type == 12;
    }

    @Override
    public String getSequenceBeforeSelectString(String seqName, String tableName, int increment) {
        return "SELECT nextval('\"" + seqName + "\"')";
    }

    @Override
    public String getSequenceAfterSelectString(String seqName, String tableName) {
        return "SELECT currval('\"" + seqName + "\"')";
    }
}

