/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.SQLRelationLoader;
import org.castor.cpa.persistence.sql.engine.SQLStatementDelete;
import org.castor.cpa.persistence.sql.engine.SQLStatementInsert;
import org.castor.cpa.persistence.sql.engine.SQLStatementLoad;
import org.castor.cpa.persistence.sql.engine.SQLStatementUpdate;
import org.castor.cpa.persistence.sql.engine.info.EntityTableInfo;
import org.castor.cpa.persistence.sql.engine.info.ForeignReferenceInfo;
import org.castor.cpa.persistence.sql.engine.info.InfoFactory;
import org.castor.cpa.persistence.sql.engine.info.RelationTableInfo;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLQuery;
import org.exolab.castor.jdo.engine.SQLStatementQuery;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;

public final class SQLEngine
implements Persistence {
    private static final Log LOG = LogFactory.getLog(SQLEngine.class);
    private static final String JDO_FIELD_NATURE = FieldDescriptorJDONature.class.getName();
    private final SQLFieldInfo[] _fields;
    private final SQLColumnInfo[] _ids;
    private SQLEngine _extends;
    private final PersistenceFactory _factory;
    private final ClassDescriptor _clsDesc;
    private final SQLStatementQuery _queryStatement;
    private final SQLStatementLoad _loadStatement;
    private final SQLStatementInsert _createStatement;
    private final SQLStatementDelete _removeStatement;
    private final SQLStatementUpdate _storeStatement;
    private final EntityTableInfo _tableInfo;

    public SQLEngine(ClassDescriptor clsDesc, PersistenceFactory factory) throws MappingException {
        this._clsDesc = clsDesc;
        this._factory = factory;
        Vector<SQLColumnInfo> idsInfo = new Vector<SQLColumnInfo>();
        Vector<SQLFieldInfo> fieldsInfo = new Vector<SQLFieldInfo>();
        ClassDescriptor base = clsDesc;
        base = clsDesc;
        Stack<ClassDescriptor> stack = new Stack<ClassDescriptor>();
        stack.push(base);
        while (base.getExtends() != null) {
            base = base.getExtends();
            stack.push(base);
        }
        FieldDescriptor[] baseIdDescriptors = ((ClassDescriptorImpl)base).getIdentities();
        FieldDescriptor[] idDescriptors = ((ClassDescriptorImpl)clsDesc).getIdentities();
        for (int i = 0; i < baseIdDescriptors.length; ++i) {
            FieldHandlerImpl fh;
            int[] sqlType;
            String[] sqlName;
            if (baseIdDescriptors[i].hasNature(FieldDescriptorJDONature.class.getName())) {
                String name = baseIdDescriptors[i].getFieldName();
                sqlName = new FieldDescriptorJDONature((PropertyHolder)baseIdDescriptors[i]).getSQLName();
                sqlType = new FieldDescriptorJDONature((PropertyHolder)baseIdDescriptors[i]).getSQLType();
                fh = (FieldHandlerImpl)baseIdDescriptors[i].getHandler();
                for (int j = 0; j < idDescriptors.length; ++j) {
                    if (!name.equals(idDescriptors[j].getFieldName()) || !idDescriptors[j].hasNature(JDO_FIELD_NATURE)) continue;
                    sqlName = new FieldDescriptorJDONature((PropertyHolder)idDescriptors[j]).getSQLName();
                    break;
                }
            } else {
                throw new MappingException("Except JDOFieldDescriptor");
            }
            idsInfo.add(new SQLColumnInfo(sqlName[0], sqlType[0], fh.getConvertTo(), fh.getConvertFrom()));
        }
        while (!stack.empty()) {
            base = (ClassDescriptor)stack.pop();
            FieldDescriptor[] fieldDescriptors = base.getFields();
            for (int i = 0; i < fieldDescriptors.length; ++i) {
                if (fieldDescriptors[i].isTransient() || !fieldDescriptors[i].hasNature(FieldDescriptorJDONature.class.getName()) && fieldDescriptors[i].getClassDescriptor() == null) continue;
                SQLFieldInfo inf = new SQLFieldInfo(clsDesc, fieldDescriptors[i], new ClassDescriptorJDONature((PropertyHolder)base).getTableName(), !stack.empty());
                fieldsInfo.add(inf);
                if (inf.isJoined()) {
                    String alias = inf.getTableName() + "_f" + i;
                    inf.setTableAlias(alias);
                    continue;
                }
                inf.setTableAlias(inf.getTableName());
            }
        }
        InfoFactory infoFactory = new InfoFactory();
        this._tableInfo = infoFactory.createTableInfo(clsDesc);
        this._ids = new SQLColumnInfo[idsInfo.size()];
        idsInfo.copyInto(this._ids);
        this._fields = new SQLFieldInfo[fieldsInfo.size()];
        fieldsInfo.copyInto(this._fields);
        this._queryStatement = new SQLStatementQuery(this, factory);
        this._loadStatement = new SQLStatementLoad(this, factory);
        this._createStatement = new SQLStatementInsert(this, factory);
        this._removeStatement = new SQLStatementDelete(this);
        this._storeStatement = new SQLStatementUpdate(this);
    }

    public SQLRelationLoader createSQLRelationLoader(FieldDescriptor fieldDescriptor) throws MappingException {
        if (!fieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName()) || new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor).getManyTable() == null) {
            return null;
        }
        String fieldName = fieldDescriptor.getFieldName();
        EntityTableInfo entity = this._tableInfo;
        RelationTableInfo relation = null;
        while (relation == null) {
            for (ForeignReferenceInfo reference : entity.getForeignReferences()) {
                if (!fieldName.equals(reference.getFieldName())) continue;
                relation = (RelationTableInfo)reference.getFromTable();
            }
            entity = entity.getExtendedTable();
        }
        return new SQLRelationLoader(relation);
    }

    public SQLColumnInfo[] getColumnInfoForIdentities() {
        return this._ids;
    }

    public SQLFieldInfo[] getInfo() {
        return this._fields;
    }

    public void setExtends(SQLEngine engine) {
        this._extends = engine;
    }

    public ClassDescriptor getDescriptor() {
        return this._clsDesc;
    }

    public PersistenceQuery createQuery(QueryExpression query, Class[] types, AccessMode accessMode) throws QueryException {
        AccessMode mode = accessMode != null ? accessMode : new ClassDescriptorJDONature((PropertyHolder)this._clsDesc).getAccessMode();
        String sql = query.getStatement(mode == AccessMode.DbLocked);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.createSql", (Object)sql));
        }
        return new SQLQuery(this, this._factory, sql, types, false);
    }

    public PersistenceQuery createCall(String spCall, Class[] types) {
        if (spCall.startsWith("SQL")) {
            String sql = spCall.substring(4);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.directSQL", (Object)sql));
            }
            return new SQLQuery(this, this._factory, sql, types, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.spCall", (Object)spCall));
        }
        FieldDescriptor[] fields = this._clsDesc.getFields();
        String[] jdoFields0 = new String[fields.length + 1];
        int[] sqlTypes0 = new int[fields.length + 1];
        int count = 1;
        jdoFields0[0] = this._clsDesc.getIdentity().getFieldName();
        sqlTypes0[0] = new FieldDescriptorJDONature((PropertyHolder)this._clsDesc.getIdentity()).getSQLType()[0];
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].hasNature(FieldDescriptorJDONature.class.getName())) continue;
            jdoFields0[count] = new FieldDescriptorJDONature((PropertyHolder)fields[i]).getSQLName()[0];
            sqlTypes0[count] = new FieldDescriptorJDONature((PropertyHolder)fields[i]).getSQLType()[0];
            ++count;
        }
        String[] jdoFields = new String[count];
        int[] sqlTypes = new int[count];
        System.arraycopy(jdoFields0, 0, jdoFields, 0, count);
        System.arraycopy(sqlTypes0, 0, sqlTypes, 0, count);
        return this._factory.getCallQuery(spCall, types, this._clsDesc.getJavaClass(), jdoFields, sqlTypes);
    }

    public QueryExpression getQueryExpression() {
        return this._factory.getQueryExpression();
    }

    public QueryExpression getFinder() {
        return this._queryStatement.getQueryExpression();
    }

    public EntityTableInfo getTableInfo() {
        return this._tableInfo;
    }

    public Identity create(Database database, CastorConnection conn, ProposedEntity entity, Identity identity) throws PersistenceException {
        Identity internalIdentity = identity;
        if (this._extends != null) {
            String thisTable = new ClassDescriptorJDONature((PropertyHolder)this._clsDesc).getTableName();
            String extTable = new ClassDescriptorJDONature((PropertyHolder)this._extends._clsDesc).getTableName();
            if (!extTable.equals(thisTable)) {
                internalIdentity = this._extends.create(database, conn, entity, internalIdentity);
            }
        }
        return (Identity)this._createStatement.executeStatement(database, conn, internalIdentity, entity);
    }

    public void store(CastorConnection conn, Identity identity, ProposedEntity newentity, ProposedEntity oldentity) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        this._storeStatement.executeStatement(conn, identity, newentity, oldentity);
        if (this._extends != null) {
            this._extends.store(conn, identity, newentity, oldentity);
        }
    }

    public void delete(CastorConnection conn, Identity identity) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        this._removeStatement.executeStatement(conn, identity);
        if (this._extends != null) {
            this._extends.delete(conn, identity);
        }
    }

    public void load(CastorConnection conn, ProposedEntity entity, Identity identity, AccessMode accessMode) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        this._loadStatement.executeStatement(conn, identity, entity, accessMode);
    }

    public PersistenceFactory getPersistenceFactory() {
        return this._factory;
    }

    public String toString() {
        return this._clsDesc.toString();
    }
}

