/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.ColumnValue;
import org.castor.cpa.persistence.sql.engine.info.RelationTableInfo;
import org.castor.cpa.persistence.sql.query.Delete;
import org.castor.cpa.persistence.sql.query.Insert;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.jdo.util.JDOUtils;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.persist.spi.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLRelationLoader {
    private static final Log LOG = LogFactory.getLog(SQLRelationLoader.class);
    private RelationTableInfo _relation;
    private Select _select;
    private Insert _insert;
    private Delete _delete;
    private Delete _deleteAll;

    public SQLRelationLoader(RelationTableInfo relation) {
        this._relation = relation;
        List<ColumnInfo> left = relation.getLeftForeignKey().getFromColumns();
        List<ColumnInfo> right = relation.getRightForeignKey().getFromColumns();
        this.constructSelectStatement(left, right);
        this.constructInsertStatement(left, right);
        this.constructDeleteStatement(left, right);
        this.constructDeleteAllStatement(left);
    }

    private void constructSelectStatement(List<ColumnInfo> left, List<ColumnInfo> right) {
        Column column;
        String name;
        this._select = new Select(this._relation.getTableName());
        AndCondition condition = new AndCondition();
        this._select.setCondition(condition);
        for (ColumnInfo colInfo : left) {
            name = colInfo.getName();
            column = new Column(name);
            this._select.addSelect(column);
            condition.and(column.equal(new Parameter(name)));
        }
        for (ColumnInfo colInfo : right) {
            name = colInfo.getName();
            column = new Column(name);
            this._select.addSelect(column);
            condition.and(column.equal(new Parameter(name)));
        }
    }

    private void constructInsertStatement(List<ColumnInfo> left, List<ColumnInfo> right) {
        String name;
        this._insert = new Insert(this._relation.getTableName());
        for (ColumnInfo colInfo : left) {
            name = colInfo.getName();
            this._insert.addAssignment(new Column(name), new Parameter(name));
        }
        for (ColumnInfo colInfo : right) {
            name = colInfo.getName();
            this._insert.addAssignment(new Column(name), new Parameter(name));
        }
    }

    private void constructDeleteStatement(List<ColumnInfo> left, List<ColumnInfo> right) {
        String name;
        this._delete = new Delete(this._relation.getTableName());
        AndCondition condition = new AndCondition();
        this._delete.setCondition(condition);
        for (ColumnInfo colInfo : left) {
            name = colInfo.getName();
            condition.and(new Column(name).equal(new Parameter(name)));
        }
        for (ColumnInfo colInfo : right) {
            name = colInfo.getName();
            condition.and(new Column(name).equal(new Parameter(name)));
        }
    }

    private void constructDeleteAllStatement(List<ColumnInfo> left) {
        this._deleteAll = new Delete(this._relation.getTableName());
        AndCondition condition = new AndCondition();
        this._deleteAll.setCondition(condition);
        for (ColumnInfo colInfo : left) {
            String name = colInfo.getName();
            condition.and(new Column(name).equal(new Parameter(name)));
        }
    }

    /*
     * Loose catch block
     */
    public void createRelation(CastorConnection conn, Identity left, Identity right) throws PersistenceException {
        block11: {
            ResultSet rset;
            CastorStatement insertStatement;
            CastorStatement selectStatement;
            block10: {
                selectStatement = conn.createStatement();
                insertStatement = conn.createStatement();
                rset = null;
                selectStatement.prepareStatement(this._select);
                List<ColumnValue> colVals = this._relation.toSQL(left, right);
                for (ColumnValue cv : colVals) {
                    selectStatement.bindParameter(cv.getName(), cv.getValue(), cv.getType());
                }
                rset = selectStatement.executeQuery();
                if (rset.next()) break block10;
                insertStatement.prepareStatement(this._insert);
                for (ColumnValue cv : colVals) {
                    insertStatement.bindParameter(cv.getName(), cv.getValue(), cv.getType());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.format((String)"jdo.inserting", (Object)insertStatement.toString()));
                }
                insertStatement.executeUpdate();
            }
            Object var11_11 = null;
            try {
                JDOUtils.closeResultSet(rset);
                selectStatement.close();
                insertStatement.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            break block11;
            {
                catch (SQLException ex) {
                    throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    JDOUtils.closeResultSet(rset);
                    selectStatement.close();
                    insertStatement.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void deleteRelation(CastorConnection conn, Identity left) throws PersistenceException {
        block9: {
            CastorStatement stmt = conn.createStatement();
            stmt.prepareStatement(this._deleteAll);
            for (ColumnValue cv : this._relation.toSQL(left)) {
                stmt.bindParameter(cv.getName(), cv.getValue(), cv.getType());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.removing", (Object)stmt.toString()));
            }
            stmt.executeUpdate();
            Object var7_7 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            break block9;
            {
                catch (SQLException ex) {
                    throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void deleteRelation(CastorConnection conn, Identity left, Identity right) throws PersistenceException {
        block9: {
            CastorStatement stmt = conn.createStatement();
            stmt.prepareStatement(this._delete);
            for (ColumnValue cv : this._relation.toSQL(left, right)) {
                stmt.bindParameter(cv.getName(), cv.getValue(), cv.getType());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.removing", (Object)stmt.toString()));
            }
            stmt.executeUpdate();
            Object var8_8 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            break block9;
            {
                catch (SQLException ex) {
                    throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                throw throwable;
            }
        }
    }
}

