/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.SQLEngine;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.ColumnValue;
import org.castor.cpa.persistence.sql.engine.info.EntityTableInfo;
import org.castor.cpa.persistence.sql.query.Delete;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;

public final class SQLStatementDelete {
    private static final Log LOG = LogFactory.getLog(SQLStatementDelete.class);
    private final String _type;
    private Delete _delete;
    private EntityTableInfo _tableInfo;

    public SQLStatementDelete(SQLEngine engine) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._tableInfo = engine.getTableInfo();
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
    }

    private void buildStatement(String mapTo) {
        AndCondition condition = new AndCondition();
        for (ColumnInfo col : this._tableInfo.getPrimaryKeyColumns()) {
            String name = col.getName();
            ((Condition)condition).and(new Column(name).equal(new Parameter(name)));
        }
        this._delete = new Delete(mapTo);
        this._delete.setCondition(condition);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)this._delete.toString()));
        }
    }

    /*
     * Loose catch block
     */
    public void executeStatement(CastorConnection conn, Identity identity) throws PersistenceException {
        block10: {
            int result;
            CastorStatement stmt = conn.createStatement();
            stmt.prepareStatement(this._delete);
            for (ColumnValue value : this._tableInfo.toSQL(identity)) {
                stmt.bindParameter(value.getName(), value.getValue(), value.getType());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)stmt.toString()));
            }
            if ((result = stmt.executeUpdate()) < 1) {
                throw new SQLException("Object to be deleted does not exist!");
            }
            Object var7_8 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            break block10;
            {
                catch (SQLException ex) {
                    LOG.fatal((Object)Messages.format((String)"jdo.deleteFatal", (Object)this._type, (Object)stmt.toString()), (Throwable)ex);
                    throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                throw throwable;
            }
        }
    }
}

