/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.SQLEngine;
import org.castor.cpa.persistence.sql.engine.SQLStatementUpdateCheck;
import org.castor.cpa.persistence.sql.query.Update;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;

public final class SQLStatementUpdate {
    private static final Log LOG = LogFactory.getLog(SQLStatementUpdate.class);
    private static final String SET_PARAM_NAMESPACE = "SET:";
    private final String _type;
    private final SQLColumnInfo[] _ids;
    private final SQLFieldInfo[] _fields;
    private Update _update;
    private boolean _hasFieldsToPersist;
    private final SQLStatementUpdateCheck _statementUpdateCheck;

    public SQLStatementUpdate(SQLEngine engine) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._ids = engine.getColumnInfoForIdentities();
        this._fields = engine.getInfo();
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
        this._statementUpdateCheck = new SQLStatementUpdateCheck(engine);
    }

    private void buildStatement(String mapTo) {
        this._update = new Update(mapTo);
        int count = 0;
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].isStore()) continue;
            SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                this._update.addAssignment(new Column(columns[j].getName()), new Parameter(SET_PARAM_NAMESPACE + columns[j].getName()));
                ++count;
            }
        }
        boolean bl = this._hasFieldsToPersist = count > 0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("hasFieldsToPersist = " + this._hasFieldsToPersist));
        }
    }

    /*
     * Loose catch block
     */
    public Object executeStatement(CastorConnection conn, Identity identity, ProposedEntity newentity, ProposedEntity oldentity) throws PersistenceException {
        block10: {
            if (this._hasFieldsToPersist) {
                CastorStatement stmt;
                block9: {
                    stmt = conn.createStatement();
                    AndCondition condition = new AndCondition();
                    for (int i = 0; i < this._ids.length; ++i) {
                        String name = this._ids[i].getName();
                        ((Condition)condition).and(new Column(name).equal(new Parameter(name)));
                    }
                    this.appendOldEntityCondition(oldentity, condition);
                    stmt.prepareStatement(this._update, condition);
                    this.bindNewEntity(newentity, stmt);
                    this.bindIdentity(identity, stmt);
                    this.bindOldEntity(oldentity, stmt);
                    if (stmt.executeUpdate() > 0) break block9;
                    this._statementUpdateCheck.updateFailureCheck(conn, identity);
                }
                Object var10_10 = null;
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                break block10;
                {
                    catch (SQLException ex) {
                        LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)stmt.toString()), (Throwable)ex);
                        throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    private void appendOldEntityCondition(ProposedEntity oldentity, Condition condition) throws PersistenceException {
        if (oldentity.getFields() != null) {
            for (int i = 0; i < this._fields.length; ++i) {
                int j;
                if (!this._fields[i].isStore() || !this._fields[i].isDirtyCheck()) continue;
                SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
                Object value = oldentity.getField(i);
                if (value == null) {
                    for (j = 0; j < columns.length; ++j) {
                        String name = columns[j].getName();
                        condition.and(new Column(name).isNull());
                    }
                    continue;
                }
                if (value instanceof Identity) {
                    Identity identity = (Identity)value;
                    if (identity.size() != columns.length) {
                        throw new PersistenceException("Size of identity field mismatch!");
                    }
                    for (int j2 = 0; j2 < columns.length; ++j2) {
                        String name = columns[j2].getName();
                        if (identity.get(j2) == null) {
                            condition.and(new Column(name).isNull());
                            continue;
                        }
                        condition.and(new Column(name).equal(new Parameter(name)));
                    }
                    continue;
                }
                for (j = 0; j < columns.length; ++j) {
                    String name = columns[j].getName();
                    condition.and(new Column(name).equal(new Parameter(name)));
                }
            }
        }
    }

    private void bindNewEntity(ProposedEntity newentity, CastorStatement stmt) throws PersistenceException, SQLException {
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].isStore()) continue;
            SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
            Object value = newentity.getField(i);
            if (value == null) {
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(SET_PARAM_NAMESPACE + columns[j].getName(), null, columns[j].getSqlType());
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity id = (Identity)value;
                if (id.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(SET_PARAM_NAMESPACE + columns[j].getName(), columns[j].toSQL(id.get(j)), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            stmt.bindParameter(SET_PARAM_NAMESPACE + columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
        }
    }

    private void bindIdentity(Identity identity, CastorStatement stmt) throws SQLException {
        for (int i = 0; i < this._ids.length; ++i) {
            stmt.bindParameter(this._ids[i].getName(), this._ids[i].toSQL(identity.get(i)), this._ids[i].getSqlType());
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)Messages.format((String)"jdo.bindingIdentity", (Object)this._ids[i].getName(), (Object)this._ids[i].toSQL(identity.get(i))));
        }
    }

    private void bindOldEntity(ProposedEntity oldentity, CastorStatement stmt) throws PersistenceException, SQLException {
        if (oldentity.getFields() != null) {
            for (int i = 0; i < this._fields.length; ++i) {
                if (!this._fields[i].isStore() || !this._fields[i].isDirtyCheck()) continue;
                SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
                Object value = oldentity.getField(i);
                if (value == null) continue;
                if (value instanceof Identity) {
                    Identity id = (Identity)value;
                    if (id.size() != columns.length) {
                        throw new PersistenceException("Size of identity field mismatch!");
                    }
                    for (int j = 0; j < columns.length; ++j) {
                        stmt.bindParameter(columns[j].getName(), columns[j].toSQL(id.get(j)), columns[j].getSqlType());
                    }
                    continue;
                }
                if (columns.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                stmt.bindParameter(columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.storing", (Object)this._type, (Object)stmt.toString()));
        }
    }
}

