/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.SQLEngine;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;

public final class SQLStatementUpdateCheck {
    private static final Log LOG = LogFactory.getLog(SQLStatementUpdateCheck.class);
    private final String _type;
    private final SQLColumnInfo[] _ids;
    private Select _select;

    public SQLStatementUpdateCheck(SQLEngine engine) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._ids = engine.getColumnInfoForIdentities();
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
    }

    private void buildStatement(String mapTo) {
        Table table = new Table(mapTo);
        AndCondition condition = new AndCondition();
        for (int i = 0; i < this._ids.length; ++i) {
            ((Condition)condition).and(table.column(this._ids[i].getName()).equal(new Parameter(this._ids[i].getName())));
        }
        this._select = new Select(table);
        this._select.addSelect(table.column(this._ids[0].getName()));
        this._select.setCondition(condition);
    }

    public void updateFailureCheck(CastorConnection conn, Identity identity) throws PersistenceException {
        CastorStatement stmt = conn.createStatement();
        try {
            try {
                stmt.prepareStatement(this._select);
                for (int i = 0; i < this._ids.length; ++i) {
                    stmt.bindParameter(this._ids[i].getName(), this._ids[i].toSQL(identity.get(i)), this._ids[i].getSqlType());
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)Messages.format((String)"jdo.bindingIdentity", (Object)this._ids[i].getName(), (Object)this._ids[i].toSQL(identity.get(i))));
                }
                ResultSet resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    String msg = Messages.format((String)"persist.objectModified", (Object)this._type, (Object)identity);
                    throw new ObjectModifiedException(msg);
                }
                String msg = Messages.format((String)"persist.objectDeleted", (Object)this._type, (Object)identity);
                throw new ObjectDeletedException(msg);
            }
            catch (SQLException except) {
                LOG.fatal((Object)Messages.format((String)"jdo.updateCheckFatal", (Object)this._type, (Object)stmt.toString()), (Throwable)except);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            throw throwable;
        }
    }
}

