/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine.info;

import java.util.ArrayList;
import java.util.List;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.ColumnValue;
import org.castor.cpa.persistence.sql.engine.info.ForeignKeyInfo;
import org.castor.cpa.persistence.sql.engine.info.ForeignReferenceInfo;
import org.castor.cpa.persistence.sql.engine.info.TableInfo;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.persist.spi.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityTableInfo
extends TableInfo {
    private EntityTableInfo _extendedTable;
    private final List<EntityTableInfo> _extendingTables = new ArrayList<EntityTableInfo>();
    private final List<ColumnInfo> _primaryKeyColumns = new ArrayList<ColumnInfo>();
    private final List<ColumnInfo> _simpleColumns = new ArrayList<ColumnInfo>();
    private final List<ForeignKeyInfo> _foreignKeys = new ArrayList<ForeignKeyInfo>();
    private final List<ForeignReferenceInfo> _foreignReferences = new ArrayList<ForeignReferenceInfo>();

    protected EntityTableInfo(String tableName) {
        super(tableName);
    }

    protected void setExtendedTable(EntityTableInfo table) {
        this._extendedTable = table;
    }

    protected void addExtendingTable(EntityTableInfo table) {
        this._extendingTables.add(table);
    }

    protected void addPrimaryKeyColumn(String fieldName, String name, int type, TypeConvertor convertFrom) {
        this._primaryKeyColumns.add(new ColumnInfo(-1, fieldName, name, type, convertFrom, true, false, false));
    }

    protected void addSimpleColumn(int fieldIndex, String fieldName, String name, int type, TypeConvertor convertFrom, boolean store, boolean dirty) {
        this._simpleColumns.add(new ColumnInfo(fieldIndex, fieldName, name, type, convertFrom, false, store, dirty));
    }

    protected void addForeignKey(ForeignKeyInfo foreignKey) {
        this._foreignKeys.add(foreignKey);
    }

    protected void addForeignReference(ForeignReferenceInfo foreignReference) {
        this._foreignReferences.add(foreignReference);
    }

    public EntityTableInfo getExtendedTable() {
        return this._extendedTable;
    }

    public List<EntityTableInfo> getExtendingTables() {
        return this._extendingTables;
    }

    public List<ColumnInfo> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    public List<ColumnInfo> getSimpleColumns() {
        return this._simpleColumns;
    }

    public List<ForeignKeyInfo> getForeignKeys() {
        return this._foreignKeys;
    }

    public List<ForeignReferenceInfo> getForeignReferences() {
        return this._foreignReferences;
    }

    public List<ColumnValue> toSQL(Identity identity) {
        return EntityTableInfo.toSQL(this.getPrimaryKeyColumns(), identity);
    }

    public List<ColumnValue> toSQL(Object[] input) {
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        for (ColumnInfo column : this.getSimpleColumns()) {
            values.add(new ColumnValue(column, input[column.getFieldIndex()]));
        }
        for (ForeignKeyInfo foreignKey : this.getForeignKeys()) {
            Identity identity = (Identity)input[foreignKey.getFieldIndex()];
            values.addAll(EntityTableInfo.toSQL(foreignKey.getFromColumns(), identity));
        }
        return values;
    }
}

