/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.castor.core.nature.PropertyHolder;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.EntityTableInfo;
import org.castor.cpa.persistence.sql.engine.info.ForeignKeyInfo;
import org.castor.cpa.persistence.sql.engine.info.ForeignReferenceInfo;
import org.castor.cpa.persistence.sql.engine.info.RelationTableInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoFactory {
    private final Map<String, EntityTableInfo> _entityMap = new HashMap<String, EntityTableInfo>();

    public EntityTableInfo createTableInfo(ClassDescriptor classDescriptor) throws MappingException {
        String name = classDescriptor.getJavaClass().getName();
        EntityTableInfo table = this._entityMap.get(name);
        if (table == null) {
            if (!classDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
                throw new MappingException("ClassDescriptor is not a JDOClassDescriptor");
            }
            ClassDescriptorJDONature classNature = new ClassDescriptorJDONature((PropertyHolder)classDescriptor);
            table = new EntityTableInfo(classNature.getTableName());
            this._entityMap.put(name, table);
            if (classDescriptor.getExtends() != null) {
                table.setExtendedTable(this.createTableInfo(classDescriptor.getExtends()));
            }
            for (ClassDescriptor extending : classNature.getExtended()) {
                table.addExtendingTable(this.createTableInfo(extending));
            }
            this.resolvePrimaryKeys(classDescriptor, table);
            this.resolveColumns(classDescriptor, table);
        }
        return table;
    }

    private void resolvePrimaryKeys(ClassDescriptor classDescriptor, EntityTableInfo table) throws MappingException {
        for (FieldDescriptor id : ((ClassDescriptorImpl)classDescriptor).getIdentities()) {
            if (!id.hasNature(FieldDescriptorJDONature.class.getName())) {
                throw new MappingException("Excepted JDOFieldDescriptor");
            }
            FieldDescriptorJDONature fieldNature = new FieldDescriptorJDONature((PropertyHolder)id);
            String columnName = fieldNature.getSQLName()[0];
            int columnType = fieldNature.getSQLType()[0];
            FieldHandlerImpl columnHandler = (FieldHandlerImpl)id.getHandler();
            table.addPrimaryKeyColumn(id.getFieldName(), columnName, columnType, columnHandler.getConvertFrom());
        }
    }

    private void resolveColumns(ClassDescriptor classDescriptor, EntityTableInfo table) throws MappingException {
        int index = 0;
        for (FieldDescriptor fieldDescriptor : classDescriptor.getFields()) {
            if (fieldDescriptor.isTransient()) continue;
            ClassDescriptor referedCD = fieldDescriptor.getClassDescriptor();
            FieldDescriptorJDONature fieldNature = null;
            if (fieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName())) {
                fieldNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
            }
            if (referedCD != null) {
                if (!referedCD.hasNature(ClassDescriptorJDONature.class.getName())) {
                    throw new MappingException("Related class is not a JDOClassDescriptor");
                }
                if (fieldNature == null) {
                    this.resolveForeignReference(classDescriptor, fieldDescriptor, table, index);
                } else if (fieldNature.getManyTable() != null) {
                    this.resolveManyToMany(classDescriptor, fieldDescriptor, table, index);
                } else if (fieldNature.getSQLName() != null) {
                    this.resolveForeignKey(fieldDescriptor, table, index);
                } else {
                    this.resolveForeignReference(classDescriptor, fieldDescriptor, table, index);
                }
                ++index;
                continue;
            }
            if (fieldNature == null) continue;
            this.resolveSimpleColumn(fieldDescriptor, table, index);
            ++index;
        }
    }

    private void resolveSimpleColumn(FieldDescriptor fieldDescriptor, EntityTableInfo table, int fieldIndex) {
        FieldDescriptorJDONature fieldNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
        boolean isExtended = table.getExtendedTable() != null;
        boolean isStore = !fieldNature.isReadonly() && !isExtended;
        boolean isDirtyCheck = fieldNature.isDirtyCheck();
        String columnName = fieldDescriptor.getFieldName();
        if (fieldNature.getSQLName() != null) {
            columnName = fieldNature.getSQLName()[0];
        }
        int columnType = fieldNature.getSQLType()[0];
        FieldHandlerImpl columnHandler = (FieldHandlerImpl)fieldDescriptor.getHandler();
        table.addSimpleColumn(fieldIndex, fieldDescriptor.getFieldName(), columnName, columnType, columnHandler.getConvertFrom(), isStore, isDirtyCheck);
    }

    private void resolveForeignKey(FieldDescriptor fieldDescriptor, EntityTableInfo table, int fieldIndex) throws MappingException {
        FieldDescriptorJDONature fieldNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
        ClassDescriptor referedCD = fieldDescriptor.getClassDescriptor();
        EntityTableInfo referedTable = this.createTableInfo(referedCD);
        ForeignKeyInfo foreignKey = new ForeignKeyInfo(fieldIndex, fieldDescriptor.getFieldName(), table, referedTable, referedTable.getTableName() + "_f" + fieldIndex);
        boolean isExtended = table.getExtendedTable() != null;
        boolean isStore = !fieldNature.isReadonly() && !isExtended;
        boolean isDirtyCheck = fieldNature.isDirtyCheck();
        String[] columnNames = fieldNature.getSQLName();
        List<ColumnInfo> columns = this.createColumnInfos(fieldIndex, fieldDescriptor.getFieldName(), referedCD, columnNames, isStore, isDirtyCheck);
        for (ColumnInfo column : columns) {
            foreignKey.addFromColumn(column);
        }
        table.addForeignKey(foreignKey);
    }

    private void resolveForeignReference(ClassDescriptor classDescriptor, FieldDescriptor fieldDescriptor, EntityTableInfo table, int fieldIndex) throws MappingException {
        ClassDescriptor referingCD = fieldDescriptor.getClassDescriptor();
        EntityTableInfo referingTable = this.createTableInfo(referingCD);
        ForeignReferenceInfo foreignReference = new ForeignReferenceInfo(fieldIndex, fieldDescriptor.getFieldName(), table, referingTable, referingTable.getTableName() + "_f" + fieldIndex);
        String[] columnNames = null;
        if (fieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName())) {
            FieldDescriptorJDONature fieldNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
            columnNames = fieldNature.getManyKey();
        }
        List<ColumnInfo> columns = this.createColumnInfos(fieldIndex, fieldDescriptor.getFieldName(), classDescriptor, columnNames, false, false);
        for (ColumnInfo column : columns) {
            foreignReference.addFromColumn(column);
        }
        table.addForeignReference(foreignReference);
    }

    private void resolveManyToMany(ClassDescriptor classDescriptor, FieldDescriptor fieldDescriptor, EntityTableInfo table, int fieldIndex) throws MappingException {
        FieldDescriptorJDONature fieldNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
        ClassDescriptor referedCD = fieldDescriptor.getClassDescriptor();
        EntityTableInfo referedTable = this.createTableInfo(referedCD);
        String relationTableName = fieldNature.getManyTable();
        RelationTableInfo relationTable = new RelationTableInfo(relationTableName);
        ForeignReferenceInfo manyToMany = new ForeignReferenceInfo(fieldIndex, fieldDescriptor.getFieldName(), table, relationTable, relationTable.getTableName() + "_f" + fieldIndex);
        String[] columnNames = fieldNature.getManyKey();
        List<ColumnInfo> columns = this.createColumnInfos(fieldIndex, fieldDescriptor.getFieldName(), classDescriptor, columnNames, false, false);
        for (ColumnInfo column : columns) {
            manyToMany.addFromColumn(column);
        }
        ForeignKeyInfo leftForeignKey = new ForeignKeyInfo(0, null, relationTable, table, table.getTableName() + "_f" + 0);
        relationTable.setLeftForeignKey(leftForeignKey);
        String[] leftColumnNames = fieldNature.getManyKey();
        List<ColumnInfo> leftColumns = this.createColumnInfos(0, null, classDescriptor, leftColumnNames, false, false);
        for (ColumnInfo column : leftColumns) {
            leftForeignKey.addFromColumn(column);
        }
        ForeignKeyInfo rightForeignKey = new ForeignKeyInfo(1, null, relationTable, referedTable, referedTable.getTableName() + "_f" + 1);
        relationTable.setRightForeignKey(rightForeignKey);
        String[] rightColumnNames = fieldNature.getSQLName();
        List<ColumnInfo> rightColumns = this.createColumnInfos(1, null, referedCD, rightColumnNames, false, false);
        for (ColumnInfo column : rightColumns) {
            rightForeignKey.addFromColumn(column);
        }
        table.addForeignReference(manyToMany);
    }

    private List<ColumnInfo> createColumnInfos(int fieldIndex, String fieldName, ClassDescriptor classDescriptor, String[] columnNames, boolean store, boolean dirty) throws MappingException {
        FieldDescriptor[] ids = ((ClassDescriptorImpl)classDescriptor).getIdentities();
        if (columnNames != null && columnNames.length != ids.length) {
            throw new MappingException("The number of columns of foreign key does not match with primary key of refered class");
        }
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        for (int j = 0; j < ids.length; ++j) {
            FieldDescriptor id = ids[j];
            FieldDescriptorJDONature nature = new FieldDescriptorJDONature((PropertyHolder)id);
            String columnName = null;
            if (columnNames != null) {
                columnName = columnNames[j];
            } else {
                columnName = nature.getSQLName()[0];
                if (columnName == null) {
                    throw new MappingException("Related class identities field does not contain sql information!");
                }
            }
            int columnType = nature.getSQLType()[0];
            FieldHandlerImpl columnHandler = (FieldHandlerImpl)id.getHandler();
            columns.add(new ColumnInfo(fieldIndex, fieldName, columnName, columnType, columnHandler.getConvertFrom(), false, store, dirty));
        }
        return columns;
    }
}

