/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.SQLEngine;
import org.castor.cpa.persistence.sql.engine.SQLStatementInsertCheck;
import org.castor.cpa.persistence.sql.keygen.AbstractKeyGenerator;
import org.castor.cpa.persistence.sql.query.Insert;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public abstract class AbstractBeforeKeyGenerator
extends AbstractKeyGenerator {
    private static final Log LOG = LogFactory.getLog(AbstractBeforeKeyGenerator.class);
    private PersistenceFactory _factory;
    private SQLEngine _engine;
    private String _engineType = null;
    private String _mapTo;
    private Insert _insert;

    public AbstractBeforeKeyGenerator(PersistenceFactory factory) {
        this._factory = factory;
    }

    public final void buildStatement(SQLEngine engine) {
        this._engine = engine;
        ClassDescriptor clsDesc = this._engine.getDescriptor();
        this._engineType = clsDesc.getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)clsDesc).getTableName();
        this._insert = new Insert(this._mapTo);
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        for (int i = 0; i < ids.length; ++i) {
            String name = ids[i].getName();
            this._insert.addAssignment(new Column(name), new Parameter(name));
        }
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                String name = columns[j].getName();
                this._insert.addAssignment(new Column(name), new Parameter(name));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object executeStatement(Database database, CastorConnection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        Identity identity2;
        Identity internalIdentity = identity;
        CastorStatement stmt = conn.createStatement();
        try {
            try {
                internalIdentity = this.generateKey(database, conn);
                stmt.prepareStatement(this._insert);
                this.bindIdentity(internalIdentity, stmt);
                this.bindFields(entity, stmt);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)stmt.toString()));
                }
                stmt.executeUpdate();
                identity2 = internalIdentity;
                Object var10_9 = null;
            }
            catch (SQLException except) {
                LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._engineType, (Object)stmt.toString()), (Throwable)except);
                SQLStatementInsertCheck lookupStatement = new SQLStatementInsertCheck(this._engine, this._factory);
                lookupStatement.insertDuplicateKeyCheck(conn, internalIdentity);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            return identity2;
        }
        stmt.close();
        return identity2;
    }

    private void bindIdentity(Identity internalIdentity, CastorStatement stmt) throws SQLException, PersistenceException {
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        if (internalIdentity.size() != ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        for (int i = 0; i < ids.length; ++i) {
            stmt.bindParameter(ids[i].getName(), ids[i].toSQL(internalIdentity.get(i)), ids[i].getSqlType());
        }
    }

    private void bindFields(ProposedEntity entity, CastorStatement stmt) throws SQLException, PersistenceException {
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            if (!fields[i].isStore()) continue;
            Object value = entity.getField(i);
            if (value == null) {
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(columns[j].getName(), null, columns[j].getSqlType());
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity identity = (Identity)value;
                if (identity.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(columns[j].getName(), columns[j].toSQL(identity.get(j)), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            stmt.bindParameter(columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Identity generateKey(Database database, CastorConnection conn) throws PersistenceException {
        Object object;
        SQLColumnInfo id = this._engine.getColumnInfoForIdentities()[0];
        Connection connection = conn.getConnection();
        if (!this.isInSameConnection()) {
            connection = this.getSeparateConnection(database);
        }
        try {
            Object identity;
            object = connection;
            synchronized (object) {
                identity = this.generateKey(connection, this._mapTo, id.getName());
            }
            if (identity == null) {
                throw new PersistenceException(Messages.format((String)"persist.noIdentity", (Object)this._engineType));
            }
            object = new Identity(id.toJava(identity));
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var9_9 = null;
                if (this.isInSameConnection()) break block8;
                this.closeSeparateConnection(connection);
            }
            throw throwable;
        }
        if (!this.isInSameConnection()) {
            this.closeSeparateConnection(connection);
        }
        return object;
    }
}

