/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.AbstractBeforeKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandler;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerBigDecimal;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerInteger;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerLong;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerString;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SequenceBeforeKeyGenerator
extends AbstractBeforeKeyGenerator {
    private static final Log LOG = LogFactory.getLog(SequenceBeforeKeyGenerator.class);
    private static final int STRING_KEY_LENGTH = 8;
    private PersistenceFactory _factory;
    private String _seqName;
    private int _increment;
    private KeyGeneratorTypeHandler<? extends Object> _typeHandler;

    public SequenceBeforeKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        super(factory);
        this._factory = factory;
        this._seqName = params.getProperty("sequence", "{0}_seq");
        try {
            this._increment = Integer.parseInt(params.getProperty("increment", "1"));
        }
        catch (NumberFormatException nfe) {
            this._increment = 1;
        }
        this.initSqlTypeHandler(sqlType);
    }

    protected void initSqlTypeHandler(int sqlType) {
        this._typeHandler = sqlType == 4 ? new KeyGeneratorTypeHandlerInteger(true) : (sqlType == -5 ? new KeyGeneratorTypeHandlerLong(true) : (sqlType == 1 || sqlType == 12 ? new KeyGeneratorTypeHandlerString(true, 8) : new KeyGeneratorTypeHandlerBigDecimal(true)));
    }

    private String getSeqName(String tableName, String primKeyName) {
        return MessageFormat.format(this._seqName, tableName, primKeyName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection conn, String tableName, String primKeyName) throws PersistenceException {
        Object object;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = this._factory.getSequenceBeforeSelectString(this.getSeqName(tableName, primKeyName), tableName, this._increment);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                object = this._typeHandler.getValue(rs);
                Object var9_10 = null;
            }
            catch (SQLException e) {
                String msg = Messages.format((String)"persist.keyGenSQL", (Object)this.getClass().getName(), (Object)e.toString());
                throw new PersistenceException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e2);
            return object;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt == null) return object;
        stmt.close();
        return object;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

