/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.SQLEngine;
import org.castor.cpa.persistence.sql.keygen.AbstractKeyGenerator;
import org.castor.cpa.persistence.sql.query.Insert;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.NextVal;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SequenceDuringKeyGenerator
extends AbstractKeyGenerator {
    private static final Log LOG = LogFactory.getLog(SequenceDuringKeyGenerator.class);
    private PersistenceFactory _factory;
    private boolean _triggerPresent;
    private String _seqName;
    private SQLEngine _engine;
    private String _mapTo;
    private String _engineType = null;
    private Insert _insert;

    public SequenceDuringKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        this._factory = factory;
        this._triggerPresent = "true".equals(params.getProperty("trigger", "false"));
        this._seqName = params.getProperty("sequence", "{0}_seq");
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName) throws PersistenceException {
        return null;
    }

    public boolean isInSameConnection() {
        return true;
    }

    public void buildStatement(SQLEngine engine) {
        this._engine = engine;
        ClassDescriptor clsDesc = this._engine.getDescriptor();
        this._engineType = clsDesc.getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)clsDesc).getTableName();
        this._insert = new Insert(this._mapTo);
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                String name = columns[j].getName();
                this._insert.addAssignment(new Column(name), new Parameter(name));
            }
        }
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        if (!this._triggerPresent) {
            this._insert.addAssignment(new Column(ids[0].getName()), new NextVal(this.getSeqName(this._mapTo, ids[0].getName())));
        }
    }

    private String getSeqName(String tableName, String primKeyName) {
        return MessageFormat.format(this._seqName, tableName, primKeyName);
    }

    /*
     * Loose catch block
     */
    public Object executeStatement(Database database, CastorConnection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        CastorStatement stmt = conn.createStatement();
        Statement cstmt = null;
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        stmt.prepareStatement(this._insert);
        String statement = stmt.toString();
        statement = statement + " RETURNING ";
        statement = statement + this._factory.quoteName(ids[0].getName());
        statement = statement + " INTO ?";
        statement = "{call " + statement + "}";
        stmt.setStatement(conn.getConnection().prepareCall(statement));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)stmt.toString()));
        }
        this.bindFields(entity, stmt);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)stmt.toString()));
        }
        cstmt = (CallableStatement)stmt.getStatement();
        int sqlType = ids[0].getSqlType();
        cstmt.registerOutParameter(stmt.getParameterSize() + 1, sqlType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)cstmt.toString()));
        }
        cstmt.execute();
        while (cstmt.getMoreResults() || cstmt.getUpdateCount() != -1) {
        }
        Object temp = sqlType == 4 ? new Integer(cstmt.getInt(stmt.getParameterSize() + 1)) : cstmt.getObject(stmt.getParameterSize() + 1);
        Identity identity2 = new Identity(ids[0].toJava(temp));
        Object var13_13 = null;
        try {
            if (cstmt != null) {
                cstmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
        }
        return identity2;
        catch (SQLException except) {
            try {
                LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._engineType, (Object)stmt.toString()), (Throwable)except);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    private void bindFields(ProposedEntity entity, CastorStatement stmt) throws SQLException, PersistenceException {
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            if (!fields[i].isStore()) continue;
            Object value = entity.getField(i);
            if (value == null) {
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(columns[j].getName(), null, columns[j].getSqlType());
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity identity = (Identity)value;
                if (identity.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(columns[j].getName(), columns[j].toSQL(identity.get(j)), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            stmt.bindParameter(columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
        }
    }
}

