/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query;

import java.util.ArrayList;
import java.util.List;
import org.castor.cpa.persistence.sql.query.Join;
import org.castor.cpa.persistence.sql.query.JoinOperator;
import org.castor.cpa.persistence.sql.query.QueryObject;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Qualifier
implements QueryObject {
    private final String _name;
    private final List<Join> _joins = new ArrayList<Join>();

    protected Qualifier(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this._name = name;
    }

    public final String name() {
        return this._name;
    }

    public final List<Join> getJoins() {
        return this._joins;
    }

    public final Column column(String name) {
        return new Column(this, name);
    }

    public final void addInnerJoin(Qualifier join) {
        this._joins.add(new Join(JoinOperator.INNER, join));
    }

    public final void addInnerJoin(Qualifier join, Condition cond) {
        this._joins.add(new Join(JoinOperator.INNER, join, cond));
    }

    public final void addLeftJoin(Qualifier join) {
        this._joins.add(new Join(JoinOperator.LEFT, join));
    }

    public final void addLeftJoin(Qualifier join, Condition cond) {
        this._joins.add(new Join(JoinOperator.LEFT, join, cond));
    }

    public final void addRightJoin(Qualifier join) {
        this._joins.add(new Join(JoinOperator.RIGHT, join));
    }

    public final void addRightJoin(Qualifier join, Condition cond) {
        this._joins.add(new Join(JoinOperator.RIGHT, join, cond));
    }

    public final void addFullJoin(Qualifier join) {
        this._joins.add(new Join(JoinOperator.FULL, join));
    }

    public final void addFullJoin(Qualifier join, Condition cond) {
        this._joins.add(new Join(JoinOperator.FULL, join, cond));
    }

    public final void addJoin(Join join) {
        this._joins.add(join);
    }

    public final boolean hasJoin() {
        return !this._joins.isEmpty();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._name);
        return sb.toString();
    }
}

