/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query.visitor;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cpa.persistence.sql.query.Assignment;
import org.castor.cpa.persistence.sql.query.Delete;
import org.castor.cpa.persistence.sql.query.Insert;
import org.castor.cpa.persistence.sql.query.Join;
import org.castor.cpa.persistence.sql.query.Qualifier;
import org.castor.cpa.persistence.sql.query.QueryObject;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.TableAlias;
import org.castor.cpa.persistence.sql.query.Update;
import org.castor.cpa.persistence.sql.query.Visitor;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Compare;
import org.castor.cpa.persistence.sql.query.condition.CompoundCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.condition.IsNullPredicate;
import org.castor.cpa.persistence.sql.query.condition.OrCondition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Expression;
import org.castor.cpa.persistence.sql.query.expression.NextVal;
import org.castor.cpa.persistence.sql.query.expression.Parameter;

public class DefaultQueryVisitor
implements Visitor {
    protected final StringBuilder _queryString = new StringBuilder();
    protected static final Log LOG = LogFactory.getLog(DefaultQueryVisitor.class);

    public void visit(Assignment assignment) {
        assignment.leftExpression().accept(this);
        this._queryString.append('=');
        assignment.rightExpression().accept(this);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit assignment: " + this.toString()));
        }
    }

    public void visit(Delete delete) {
        Condition condition = delete.getCondition();
        this._queryString.append("DELETE");
        this._queryString.append(' ');
        this._queryString.append("FROM");
        this._queryString.append(' ');
        delete.getQualifier().accept(this);
        if (condition != null) {
            this._queryString.append(' ');
            this._queryString.append("WHERE");
            this._queryString.append(' ');
            condition.accept(this);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit delete: " + this.toString()));
        }
    }

    public void visit(Insert insert) {
        this._queryString.append("INSERT");
        this._queryString.append(' ');
        this._queryString.append("INTO");
        this._queryString.append(' ');
        insert.getQualifier().accept(this);
        this._queryString.append(' ');
        this._queryString.append('(');
        Iterator<Assignment> iter = insert.getAssignment().iterator();
        while (iter.hasNext()) {
            iter.next().leftExpression().accept(this);
            if (!iter.hasNext()) continue;
            this._queryString.append(',');
            this._queryString.append(' ');
        }
        this._queryString.append(')');
        this._queryString.append(' ');
        this._queryString.append("VALUES");
        this._queryString.append(' ');
        this._queryString.append('(');
        iter = insert.getAssignment().iterator();
        while (iter.hasNext()) {
            iter.next().rightExpression().accept(this);
            if (!iter.hasNext()) continue;
            this._queryString.append(',');
            this._queryString.append(' ');
        }
        this._queryString.append(')');
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit insert: " + this.toString()));
        }
    }

    public void visit(Join join) {
        Condition condition = join.getCondition();
        this._queryString.append(join.getOperator().toString());
        this._queryString.append(' ');
        this._queryString.append("JOIN");
        this._queryString.append(' ');
        this.handleJoinConstruction(join.getJoin());
        if (condition != null) {
            this._queryString.append(' ');
            this._queryString.append("ON");
            this._queryString.append(' ');
            condition.accept(this);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit join: " + this.toString()));
        }
    }

    public void visit(Select select) {
        Iterator<QueryObject> iter;
        List<Expression> expressions = select.getSelect();
        Condition condition = select.getCondition();
        this._queryString.append("SELECT");
        this._queryString.append(' ');
        if (expressions.isEmpty()) {
            this._queryString.append('*');
        } else {
            iter = expressions.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this);
                if (!iter.hasNext()) continue;
                this._queryString.append(',');
                this._queryString.append(' ');
            }
        }
        this._queryString.append(' ');
        this._queryString.append("FROM");
        this._queryString.append(' ');
        iter = select.getFrom().iterator();
        while (iter.hasNext()) {
            this.handleJoinConstruction((Qualifier)iter.next());
            if (!iter.hasNext()) continue;
            this._queryString.append(',');
            this._queryString.append(' ');
        }
        if (condition != null) {
            this._queryString.append(' ');
            this._queryString.append("WHERE");
            this._queryString.append(' ');
            condition.accept(this);
        }
        this.handleLock(select);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit select: " + this.toString()));
        }
    }

    protected void handleJoinConstruction(Qualifier qualifier) {
        if (!qualifier.hasJoin()) {
            this.addTableNames(qualifier);
        } else {
            int i;
            for (i = 0; i < qualifier.getJoins().size(); ++i) {
                this._queryString.append('(');
            }
            for (i = 0; i < qualifier.getJoins().size(); ++i) {
                Join join = qualifier.getJoins().get(i);
                if (i == 0) {
                    this.addTableNames(qualifier);
                }
                this._queryString.append(' ');
                join.accept(this);
                this._queryString.append(')');
            }
        }
    }

    protected void addTableNames(Qualifier qualifier) {
        if (qualifier instanceof TableAlias) {
            ((TableAlias)qualifier).getTable().accept(this);
            this._queryString.append(' ');
        }
        qualifier.accept(this);
    }

    public void visit(Table table) {
        this._queryString.append(this.quoteName(table.name()));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit table: " + this.toString()));
        }
    }

    public void visit(TableAlias tableAlias) {
        this._queryString.append(this.quoteName(tableAlias.name()));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit tableAlias: " + this.toString()));
        }
    }

    public void visit(Update update) {
        Condition condition = update.getCondition();
        this._queryString.append("UPDATE");
        this._queryString.append(' ');
        update.getQualifier().accept(this);
        this._queryString.append(' ');
        this._queryString.append("SET");
        this._queryString.append(' ');
        Iterator<Assignment> iter = update.getAssignment().iterator();
        while (iter.hasNext()) {
            iter.next().accept(this);
            if (!iter.hasNext()) continue;
            this._queryString.append(',');
            this._queryString.append(' ');
        }
        if (condition != null) {
            this._queryString.append(' ');
            this._queryString.append("WHERE");
            this._queryString.append(' ');
            condition.accept(this);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit update: " + this.toString()));
        }
    }

    public void visit(AndCondition andCondition) {
        Condition condition = null;
        Iterator<Condition> iter = andCondition.iterator();
        while (iter.hasNext()) {
            condition = iter.next();
            if (condition instanceof CompoundCondition) {
                this._queryString.append('(');
                condition.accept(this);
                this._queryString.append(')');
            } else {
                condition.accept(this);
            }
            if (!iter.hasNext()) continue;
            this._queryString.append(' ');
            this._queryString.append("AND");
            this._queryString.append(' ');
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit andCondition: " + this.toString()));
        }
    }

    public void visit(Compare compare) {
        compare.leftExpression().accept(this);
        this._queryString.append(compare.operator().toString());
        compare.rightExpression().accept(this);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit compare: " + this.toString()));
        }
    }

    public void visit(IsNullPredicate isNullPredicate) {
        isNullPredicate.expression().accept(this);
        this._queryString.append(' ');
        this._queryString.append("IS");
        if (!isNullPredicate.evaluateTo()) {
            this._queryString.append(' ');
            this._queryString.append("NOT");
        }
        this._queryString.append(' ');
        this._queryString.append("NULL");
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit isNullPredicate: " + this.toString()));
        }
    }

    public void visit(OrCondition orCondition) {
        Condition condition = null;
        Iterator<Condition> iter = orCondition.iterator();
        while (iter.hasNext()) {
            condition = iter.next();
            if (condition instanceof CompoundCondition) {
                this._queryString.append('(');
                condition.accept(this);
                this._queryString.append(')');
            } else {
                condition.accept(this);
            }
            if (!iter.hasNext()) continue;
            this._queryString.append(' ');
            this._queryString.append("OR");
            this._queryString.append(' ');
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit orCondition: " + this.toString()));
        }
    }

    public void visit(Column column) {
        Qualifier qualifier = column.qualifier();
        if (qualifier != null) {
            qualifier.accept(this);
            this._queryString.append('.');
        }
        this._queryString.append(this.quoteName(column.name()));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit column: " + this.toString()));
        }
    }

    public void visit(NextVal nextVal) {
        this._queryString.append(this.getSequenceNextValString(nextVal.getSeqName()));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit nextVal: " + this.toString()));
        }
    }

    public void visit(Parameter parameter) {
        this._queryString.append('?');
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit parameter: " + this.toString()));
        }
    }

    protected String quoteName(String name) {
        return name;
    }

    protected String getSequenceNextValString(String seqName) {
        return null;
    }

    protected void handleLock(Select select) {
    }

    public String toString() {
        return this._queryString.toString();
    }
}

