/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query.visitor;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.castor.cpa.persistence.sql.query.Join;
import org.castor.cpa.persistence.sql.query.Qualifier;
import org.castor.cpa.persistence.sql.query.QueryObject;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Expression;
import org.castor.cpa.persistence.sql.query.visitor.DefaultQueryVisitor;

public final class SapDbQueryVisitor
extends DefaultQueryVisitor {
    public void visit(Join join) {
        this._queryString.append(join.getOperator().toString());
        this._queryString.append(' ');
        this._queryString.append("JOIN");
        this._queryString.append(' ');
        this.addTableNames(join.getJoin());
        Condition condition = join.getCondition();
        if (condition != null) {
            this._queryString.append(' ');
            this._queryString.append("ON");
            this._queryString.append(' ');
            condition.accept(this);
        }
        this.handleJoinConstruction(join.getJoin());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit join: " + this.toString()));
        }
    }

    public void visit(Select select) {
        Iterator<QueryObject> iter;
        List<Expression> expressions = select.getSelect();
        Condition condition = select.getCondition();
        this._queryString.append("SELECT");
        this._queryString.append(' ');
        if (expressions.isEmpty()) {
            this._queryString.append('*');
        } else {
            iter = expressions.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this);
                if (!iter.hasNext()) continue;
                this._queryString.append(',');
                this._queryString.append(' ');
            }
        }
        this._queryString.append(' ');
        this._queryString.append("FROM");
        this._queryString.append(' ');
        iter = select.getFrom().iterator();
        while (iter.hasNext()) {
            Qualifier qualifier = (Qualifier)iter.next();
            this.addTableNames(qualifier);
            this.handleJoinConstruction(qualifier);
            if (!iter.hasNext()) continue;
            this._queryString.append(',');
            this._queryString.append(' ');
        }
        if (condition != null) {
            this._queryString.append(' ');
            this._queryString.append("WHERE");
            this._queryString.append(' ');
            condition.accept(this);
        }
        this.handleLock(select);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Visit select: " + this.toString()));
        }
    }

    protected void handleJoinConstruction(Qualifier qualifier) {
        if (qualifier.hasJoin()) {
            for (Join join : qualifier.getJoins()) {
                this._queryString.append(' ');
                join.accept(this);
            }
        }
    }

    protected String quoteName(String name) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(name, ".");
        String token = null;
        boolean addQuote = true;
        buffer.append('\"');
        buffer.append(tokens.nextToken().toUpperCase());
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (this.isAFunction(token)) {
                addQuote = false;
                buffer.append("\".");
            } else {
                buffer.append("\".\"");
                token = token.toUpperCase();
            }
            buffer.append(token);
        }
        if (addQuote) {
            buffer.append('\"');
        }
        return buffer.toString();
    }

    private boolean isAFunction(String text) {
        boolean isAFunction = false;
        String[] knownFunctions = new String[]{"nextval", "currval"};
        for (int i = 0; i < knownFunctions.length; ++i) {
            String function = knownFunctions[i];
            if (!text.equals(function)) continue;
            return true;
        }
        return isAFunction;
    }

    protected void handleLock(Select select) {
        if (select.isLocked()) {
            this._queryString.append(' ');
            this._queryString.append("WITH");
            this._queryString.append(' ');
            this._queryString.append("LOCK");
        }
    }
}

