/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.query.ejbql;

import java.text.SimpleDateFormat;
import org.castor.cpa.query.Condition;
import org.castor.cpa.query.Expression;
import org.castor.cpa.query.InCondition;
import org.castor.cpa.query.Literal;
import org.castor.cpa.query.Order;
import org.castor.cpa.query.OrderDirection;
import org.castor.cpa.query.Parameter;
import org.castor.cpa.query.ParseException;
import org.castor.cpa.query.QueryFactory;
import org.castor.cpa.query.Schema;
import org.castor.cpa.query.SelectQuery;
import org.castor.cpa.query.TrimSpecification;
import org.castor.cpa.query.ejbql.EjbQLParserConstants;
import org.castor.cpa.query.ejbql.EjbQLParserTreeConstants;
import org.castor.cpa.query.ejbql.SimpleNode;
import org.castor.cpa.query.object.literal.BooleanLiteral;
import org.castor.cpa.query.object.literal.DateLiteral;
import org.castor.cpa.query.object.literal.DoubleLiteral;
import org.castor.cpa.query.object.literal.EnumLiteral;
import org.castor.cpa.query.object.literal.LongLiteral;
import org.castor.cpa.query.object.literal.StringLiteral;
import org.castor.cpa.query.object.literal.TimeLiteral;
import org.castor.cpa.query.object.literal.TimestampLiteral;
import org.castor.cpa.query.object.parameter.NamedParameter;
import org.castor.cpa.query.object.parameter.PositionalParameter;

public final class EjbQLTreeWalker
implements EjbQLParserTreeConstants,
EjbQLParserConstants {
    private SelectQuery _select;
    private Schema _schema;
    private Order _order;

    public EjbQLTreeWalker(SimpleNode node) throws ParseException {
        if (node != null) {
            if (node.id != 0) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new NullPointerException();
        }
        this.selectStatement((SimpleNode)node.jjtGetChild(0));
    }

    public SelectQuery getSelect() {
        return this._select;
    }

    public void setSelect(SelectQuery select) {
        this._select = select;
    }

    private void selectStatement(SimpleNode node) throws ParseException {
        this._select = QueryFactory.newSelectQuery();
        if (((SimpleNode)node.jjtGetChild((int)1)).id == 4) {
            this.fromClause((SimpleNode)node.jjtGetChild(1));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 2) {
            this.selectClause((SimpleNode)node.jjtGetChild(0));
        }
        for (int i = 2; node.jjtGetNumChildren() > i; ++i) {
            if (((SimpleNode)node.jjtGetChild((int)i)).id == 6) {
                this.whereClause((SimpleNode)node.jjtGetChild(i));
            }
            if (((SimpleNode)node.jjtGetChild((int)i)).id == 7) {
                this.orderbyClause((SimpleNode)node.jjtGetChild(i));
            }
            if (((SimpleNode)node.jjtGetChild((int)i)).id != 9) continue;
            this.limitClause((SimpleNode)node.jjtGetChild(i));
        }
    }

    private void selectClause(SimpleNode node) {
        if (node.getKind() == 52) {
            this._select.setDistinct(true);
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 3) {
            this.selectExpression((SimpleNode)node.jjtGetChild(0));
        }
    }

    private void selectExpression(SimpleNode node) {
        for (int i = 0; node.jjtGetNumChildren() > i; ++i) {
            if (((SimpleNode)node.jjtGetChild((int)i)).id != 31) continue;
            this._select.addProjection(this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(i).jjtGetChild(1))));
        }
        this._select.addSchema(this._schema);
    }

    private void fromClause(SimpleNode node) {
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 5) {
            this.fromDeclaration((SimpleNode)node.jjtGetChild(0));
        }
    }

    private void fromDeclaration(SimpleNode node) {
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 31 && ((SimpleNode)node.jjtGetChild((int)1)).id == 32) {
            this._schema = this._select.newSchema(this.path((SimpleNode)node.jjtGetChild(0)), this.identifier((SimpleNode)node.jjtGetChild(1)));
        }
    }

    private void whereClause(SimpleNode node) throws ParseException {
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 10) {
            Condition condition = null;
            condition = this.conditionalExpression((SimpleNode)node.jjtGetChild(0), condition);
            this._select.setWhere(condition);
        }
    }

    private void orderbyClause(SimpleNode node) {
        for (int i = 0; node.jjtGetNumChildren() > i; ++i) {
            if (((SimpleNode)node.jjtGetChild((int)i)).id != 8) continue;
            this.orderbyItem((SimpleNode)node.jjtGetChild(i));
        }
    }

    private void orderbyItem(SimpleNode node) {
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 31) {
            if (this._order == null) {
                if (node.getKind() == 28) {
                    this._order = this._select.newOrder(this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))), OrderDirection.DESCENDING);
                    this._select.setOrder(this._order);
                } else {
                    this._order = this._select.newOrder(this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))));
                    this._select.setOrder(this._order);
                }
            } else if (node.getKind() == 28) {
                this._order.add(this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))), OrderDirection.DESCENDING);
            } else {
                this._order.add(this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))));
            }
        }
    }

    private void limitClause(SimpleNode node) {
        if (node.jjtGetNumChildren() == 2) {
            if (((SimpleNode)node.jjtGetChild((int)0)).id == 28 && ((SimpleNode)node.jjtGetChild((int)1)).id == 28) {
                this._select.setLimit(this.parameter((SimpleNode)node.jjtGetChild(0)), this.parameter((SimpleNode)node.jjtGetChild(1)));
            } else if (((SimpleNode)node.jjtGetChild((int)0)).id == 34 && ((SimpleNode)node.jjtGetChild((int)1)).id == 34) {
                this._select.setLimit(this.integerLiteral((SimpleNode)node.jjtGetChild(0)), this.integerLiteral((SimpleNode)node.jjtGetChild(1)));
            }
        }
    }

    private Condition conditionalExpression(SimpleNode node, Condition condition) throws ParseException {
        Condition c = condition;
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 11) {
            c = this.conditionalTerm((SimpleNode)node.jjtGetChild(0), c);
        }
        for (int i = 1; node.jjtGetNumChildren() > i; ++i) {
            if (((SimpleNode)node.jjtGetChild((int)i)).id != 11) continue;
            c = c.or(this.conditionalTerm((SimpleNode)node.jjtGetChild(i), c));
        }
        return c;
    }

    private Condition conditionalTerm(SimpleNode node, Condition condition) throws ParseException {
        Condition c = condition;
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 12) {
            c = this.conditionalFactor((SimpleNode)node.jjtGetChild(0), c);
        }
        for (int i = 1; node.jjtGetNumChildren() > i; ++i) {
            if (((SimpleNode)node.jjtGetChild((int)i)).id != 12) continue;
            c = c.and(this.conditionalFactor((SimpleNode)node.jjtGetChild(i), c));
        }
        return c;
    }

    private Condition conditionalFactor(SimpleNode node, Condition condition) throws ParseException {
        Condition c = condition;
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 13) {
            c = this.conditionalPrimary((SimpleNode)node.jjtGetChild(0), c);
            if (node.getKind() == 26) {
                c.not();
            }
        }
        return c;
    }

    private Condition conditionalPrimary(SimpleNode node, Condition condition) throws ParseException {
        Condition c = condition;
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 10) {
            return this.conditionalExpression((SimpleNode)node.jjtGetChild(0), c);
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 14) {
            return this.comparisonExpression((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 16) {
            return this.betweenExpression((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 17) {
            return this.likeExpression((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 18) {
            return this.inExpression((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 20) {
            return this.nullExpression((SimpleNode)node.jjtGetChild(0));
        }
        return c;
    }

    private Condition comparisonExpression(SimpleNode node) {
        Condition condition = null;
        switch (this.comparisonOperator((SimpleNode)node.jjtGetChild(1))) {
            case 15: {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).equal(this.expression((SimpleNode)node.jjtGetChild(2)));
                break;
            }
            case 16: {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).notEqual(this.expression((SimpleNode)node.jjtGetChild(2)));
                break;
            }
            case 11: {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).greaterThan(this.expression((SimpleNode)node.jjtGetChild(2)));
                break;
            }
            case 12: {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).lessThan(this.expression((SimpleNode)node.jjtGetChild(2)));
                break;
            }
            case 13: {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).greaterEqual(this.expression((SimpleNode)node.jjtGetChild(2)));
                break;
            }
            case 14: {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).lessEqual(this.expression((SimpleNode)node.jjtGetChild(2)));
                break;
            }
        }
        return condition;
    }

    private int comparisonOperator(SimpleNode node) {
        return node.getKind();
    }

    private Condition betweenExpression(SimpleNode node) {
        if (node.getKind() == 26) {
            return this.expression((SimpleNode)node.jjtGetChild(0)).notBetween(this.expression((SimpleNode)node.jjtGetChild(1)), this.expression((SimpleNode)node.jjtGetChild(2)));
        }
        return this.expression((SimpleNode)node.jjtGetChild(0)).between(this.expression((SimpleNode)node.jjtGetChild(1)), this.expression((SimpleNode)node.jjtGetChild(2)));
    }

    private Condition likeExpression(SimpleNode node) {
        Condition condition = null;
        int three = 3;
        if (node.getKind() == 26) {
            if (node.jjtGetNumChildren() == 3) {
                if (((SimpleNode)node.jjtGetChild((int)1)).id == 28 && ((SimpleNode)node.jjtGetChild((int)2)).id == 28) {
                    condition = this.expression((SimpleNode)node.jjtGetChild(0)).notLike(this.parameter((SimpleNode)node.jjtGetChild(1)), this.parameter((SimpleNode)node.jjtGetChild(2)));
                } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 35 && ((SimpleNode)node.jjtGetChild((int)2)).id == 35) {
                    condition = this.expression((SimpleNode)node.jjtGetChild(0)).notLike(this.stringLiteral((SimpleNode)node.jjtGetChild(1)), this.stringLiteral((SimpleNode)node.jjtGetChild(2)).charAt(0));
                } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 28 && ((SimpleNode)node.jjtGetChild((int)2)).id == 35) {
                    condition = this.expression((SimpleNode)node.jjtGetChild(0)).notLike(this.parameter((SimpleNode)node.jjtGetChild(1)), this.stringLiteral((SimpleNode)node.jjtGetChild(2)).charAt(0));
                } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 35 && ((SimpleNode)node.jjtGetChild((int)2)).id == 28) {
                    condition = this.expression((SimpleNode)node.jjtGetChild(0)).notLike(this.stringLiteral((SimpleNode)node.jjtGetChild(1)), this.parameter((SimpleNode)node.jjtGetChild(2)));
                }
            } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 28) {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).notLike(this.parameter((SimpleNode)node.jjtGetChild(1)));
            } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 35) {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).notLike(this.stringLiteral((SimpleNode)node.jjtGetChild(1)));
            }
        } else if (node.jjtGetNumChildren() == 3) {
            if (((SimpleNode)node.jjtGetChild((int)1)).id == 28 && ((SimpleNode)node.jjtGetChild((int)2)).id == 28) {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).like(this.parameter((SimpleNode)node.jjtGetChild(1)), this.parameter((SimpleNode)node.jjtGetChild(2)));
            } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 35 && ((SimpleNode)node.jjtGetChild((int)2)).id == 35) {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).like(this.stringLiteral((SimpleNode)node.jjtGetChild(1)), this.stringLiteral((SimpleNode)node.jjtGetChild(2)).charAt(0));
            } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 28 && ((SimpleNode)node.jjtGetChild((int)2)).id == 35) {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).like(this.parameter((SimpleNode)node.jjtGetChild(1)), this.stringLiteral((SimpleNode)node.jjtGetChild(2)).charAt(0));
            } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 35 && ((SimpleNode)node.jjtGetChild((int)2)).id == 28) {
                condition = this.expression((SimpleNode)node.jjtGetChild(0)).like(this.stringLiteral((SimpleNode)node.jjtGetChild(1)), this.parameter((SimpleNode)node.jjtGetChild(2)));
            }
        } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 28) {
            condition = this.expression((SimpleNode)node.jjtGetChild(0)).like(this.parameter((SimpleNode)node.jjtGetChild(1)));
        } else if (((SimpleNode)node.jjtGetChild((int)1)).id == 35) {
            condition = this.expression((SimpleNode)node.jjtGetChild(0)).like(this.stringLiteral((SimpleNode)node.jjtGetChild(1)));
        }
        return condition;
    }

    private Condition inExpression(SimpleNode node) throws ParseException {
        InCondition inCond = null;
        if (node.getKind() == 26) {
            if (((SimpleNode)node.jjtGetChild((int)0)).id == 31) {
                inCond = this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))).notIn();
            }
        } else if (((SimpleNode)node.jjtGetChild((int)0)).id == 31) {
            inCond = this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))).in();
        }
        for (int i = 1; node.jjtGetNumChildren() > i; ++i) {
            if (((SimpleNode)node.jjtGetChild((int)i).jjtGetChild((int)0)).id == 28) {
                inCond.add(this.parameter((SimpleNode)node.jjtGetChild(i).jjtGetChild(0)));
                continue;
            }
            if (((SimpleNode)node.jjtGetChild((int)i).jjtGetChild((int)0)).id == 25) {
                inCond.add(this.literal((SimpleNode)node.jjtGetChild(i).jjtGetChild(0)));
                continue;
            }
            if (((SimpleNode)node.jjtGetChild((int)i).jjtGetChild((int)0)).id != 31) continue;
            try {
                inCond.add(new EnumLiteral(this.path((SimpleNode)node.jjtGetChild(i).jjtGetChild(0))));
                continue;
            }
            catch (IllegalArgumentException ille) {
                throw new ParseException(ille);
            }
            catch (NullPointerException e) {
                throw new ParseException(e);
            }
        }
        return inCond;
    }

    private Condition nullExpression(SimpleNode node) {
        Condition condition = null;
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 31) {
            condition = node.getKind() == 26 ? this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))).isNotNull() : this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1))).isNull();
        }
        return condition;
    }

    private Expression expression(SimpleNode node) {
        if (node.getKind() == 5) {
            return this.term((SimpleNode)node.jjtGetChild(0)).add(this.term((SimpleNode)node.jjtGetChild(1)));
        }
        if (node.getKind() == 6) {
            return this.term((SimpleNode)node.jjtGetChild(0)).subtract(this.term((SimpleNode)node.jjtGetChild(0)));
        }
        if (node.getKind() == 7) {
            return this.term((SimpleNode)node.jjtGetChild(0)).concat(this.term((SimpleNode)node.jjtGetChild(0)));
        }
        return this.term((SimpleNode)node.jjtGetChild(0));
    }

    private Expression term(SimpleNode node) {
        if (node.getKind() == 8) {
            return this.factor((SimpleNode)node.jjtGetChild(0)).multiply(this.factor((SimpleNode)node.jjtGetChild(1)));
        }
        if (node.getKind() == 9) {
            return this.factor((SimpleNode)node.jjtGetChild(0)).divide(this.factor((SimpleNode)node.jjtGetChild(0)));
        }
        if (node.getKind() == 23) {
            return this.factor((SimpleNode)node.jjtGetChild(0)).remainder(this.factor((SimpleNode)node.jjtGetChild(0)));
        }
        if (node.getKind() == 10) {
            return this.factor((SimpleNode)node.jjtGetChild(0)).remainder(this.factor((SimpleNode)node.jjtGetChild(0)));
        }
        return this.factor((SimpleNode)node.jjtGetChild(0));
    }

    private Expression factor(SimpleNode node) {
        if (node.getKind() == 5) {
            return this.primary((SimpleNode)node.jjtGetChild(0)).plus();
        }
        if (node.getKind() == 6) {
            return this.primary((SimpleNode)node.jjtGetChild(0)).negate();
        }
        return this.primary((SimpleNode)node.jjtGetChild(0));
    }

    private Expression primary(SimpleNode node) {
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 21) {
            return this.expression((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 31) {
            return this._schema.field(this.identifier((SimpleNode)node.jjtGetChild(0).jjtGetChild(1)));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 28) {
            return this.parameter((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 25) {
            return this.literal((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 26) {
            return this.function((SimpleNode)node.jjtGetChild(0));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression function(SimpleNode node) {
        switch (node.getKind()) {
            case 47: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).length();
            }
            case 48: {
                if (node.jjtGetNumChildren() != 2) return this.expression((SimpleNode)node.jjtGetChild(0)).locate(this.expression((SimpleNode)node.jjtGetChild(1)), this.expression((SimpleNode)node.jjtGetChild(2)));
                return this.expression((SimpleNode)node.jjtGetChild(0)).locate(this.expression((SimpleNode)node.jjtGetChild(1)));
            }
            case 22: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).abs();
            }
            case 36: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).sqrt();
            }
            case 23: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).remainder(this.expression((SimpleNode)node.jjtGetChild(1)));
            }
            case 45: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).concat(this.expression((SimpleNode)node.jjtGetChild(1)));
            }
            case 53: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).substring(this.expression((SimpleNode)node.jjtGetChild(1)), this.expression((SimpleNode)node.jjtGetChild(2)));
            }
            case 32: {
                int three = 3;
                if (node.jjtGetNumChildren() == 1) {
                    return this.expression((SimpleNode)node.jjtGetChild(0)).trim();
                }
                if (node.jjtGetNumChildren() == 2) {
                    if (((SimpleNode)node.jjtGetChild((int)0)).id == 35) {
                        return this.expression((SimpleNode)node.jjtGetChild(1)).trim(this.stringLiteral((SimpleNode)node.jjtGetChild(0)).charAt(0));
                    }
                    if (((SimpleNode)node.jjtGetChild((int)0)).id != 27) return this.expression((SimpleNode)node.jjtGetChild(0)).lower();
                    return this.expression((SimpleNode)node.jjtGetChild(1)).trim(this.trimSpecification((SimpleNode)node.jjtGetChild(0)));
                }
                if (node.jjtGetNumChildren() != 3) return this.expression((SimpleNode)node.jjtGetChild(0)).lower();
                if (((SimpleNode)node.jjtGetChild((int)0)).id != 27) return this.expression((SimpleNode)node.jjtGetChild(0)).lower();
                return this.expression((SimpleNode)node.jjtGetChild(2)).trim(this.trimSpecification((SimpleNode)node.jjtGetChild(0)), this.stringLiteral((SimpleNode)node.jjtGetChild(1)).charAt(0));
            }
            case 40: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).lower();
            }
            case 41: {
                return this.expression((SimpleNode)node.jjtGetChild(0)).upper();
            }
            case 58: {
                return null;
            }
            case 59: {
                return null;
            }
            case 60: {
                return null;
            }
            case 35: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                DateLiteral date = null;
                try {
                    return new DateLiteral(sdf.parse(this.dateLiteral((SimpleNode)node.jjtGetChild(0))));
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                }
                return date;
            }
            case 33: {
                int eight = 8;
                int ten = 10;
                int eleven = 11;
                String sTime = this.timeLiteral((SimpleNode)node.jjtGetChild(0));
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
                TimeLiteral time = null;
                if (sTime.length() == 8) {
                    sTime = sTime + ".000";
                } else if (sTime.length() == 10) {
                    sTime = sTime + "00";
                } else if (sTime.length() == 11) {
                    sTime = sTime + "0";
                }
                try {
                    return new TimeLiteral(sdf.parse(sTime));
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace(System.out);
                }
                return time;
            }
            case 54: {
                String sTimestamp = this.timestampLiteral((SimpleNode)node.jjtGetChild(0));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                TimestampLiteral timestamp = null;
                try {
                    return new TimestampLiteral(sdf.parse(sTimestamp));
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                }
                return timestamp;
            }
        }
        return null;
    }

    private TrimSpecification trimSpecification(SimpleNode node) {
        if (node.getKind() == 50) {
            return TrimSpecification.LEADING;
        }
        if (node.getKind() == 31) {
            return TrimSpecification.BOTH;
        }
        if (node.getKind() == 51) {
            return TrimSpecification.TRAILING;
        }
        return null;
    }

    private Literal literal(SimpleNode node) {
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 36) {
            return new BooleanLiteral(this.booleanLiteral((SimpleNode)node.jjtGetChild(0)));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 34) {
            return new LongLiteral(this.integerLiteral((SimpleNode)node.jjtGetChild(0)));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 33) {
            return new DoubleLiteral(this.floatLiteral((SimpleNode)node.jjtGetChild(0)));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 35) {
            return new StringLiteral(this.stringLiteral((SimpleNode)node.jjtGetChild(0)));
        }
        return null;
    }

    private Parameter parameter(SimpleNode node) {
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 29) {
            return this.positionalParameter((SimpleNode)node.jjtGetChild(0));
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 30) {
            return this.namedParameter((SimpleNode)node.jjtGetChild(0));
        }
        return null;
    }

    private PositionalParameter positionalParameter(SimpleNode node) {
        return new PositionalParameter(this.integerLiteral((SimpleNode)node.jjtGetChild(0)));
    }

    private NamedParameter namedParameter(SimpleNode node) {
        return new NamedParameter(this.identifier((SimpleNode)node.jjtGetChild(0)));
    }

    private String path(SimpleNode node) {
        int i;
        String path = "";
        for (i = 0; node.jjtGetNumChildren() - 1 > i; ++i) {
            path = path + this.identifier((SimpleNode)node.jjtGetChild(i)) + ".";
        }
        path = path + this.identifier((SimpleNode)node.jjtGetChild(i));
        return path;
    }

    private String identifier(SimpleNode node) {
        return node.getText();
    }

    private boolean booleanLiteral(SimpleNode node) {
        return Boolean.parseBoolean(node.getText());
    }

    private int integerLiteral(SimpleNode node) {
        return Integer.parseInt(node.getText());
    }

    private double floatLiteral(SimpleNode node) {
        return Double.parseDouble(node.getText());
    }

    private String stringLiteral(SimpleNode node) {
        return node.getText().replace("'", "");
    }

    private String timestampLiteral(SimpleNode node) {
        return node.getText().replace("'", "");
    }

    private String dateLiteral(SimpleNode node) {
        return node.getText().replace("'", "");
    }

    private String timeLiteral(SimpleNode node) {
        return node.getText().replace("'", "");
    }
}

