/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.query.object;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.castor.cpa.query.Condition;
import org.castor.cpa.query.Expression;
import org.castor.cpa.query.Field;
import org.castor.cpa.query.Literal;
import org.castor.cpa.query.Order;
import org.castor.cpa.query.OrderDirection;
import org.castor.cpa.query.Parameter;
import org.castor.cpa.query.Projection;
import org.castor.cpa.query.Schema;
import org.castor.cpa.query.SelectQuery;
import org.castor.cpa.query.TemporalType;
import org.castor.cpa.query.object.AbstractQueryObject;
import org.castor.cpa.query.object.OrderImpl;
import org.castor.cpa.query.object.ProjectionImpl;
import org.castor.cpa.query.object.SchemaImpl;
import org.castor.cpa.query.object.literal.BigDecimalLiteral;
import org.castor.cpa.query.object.literal.BooleanLiteral;
import org.castor.cpa.query.object.literal.DoubleLiteral;
import org.castor.cpa.query.object.literal.LongLiteral;
import org.castor.cpa.query.object.literal.StringLiteral;
import org.castor.cpa.query.object.parameter.NamedParameter;
import org.castor.cpa.query.object.parameter.PositionalParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectQueryImpl
extends AbstractQueryObject
implements SelectQuery {
    private boolean _distinct;
    private final List<Projection> _projections = new ArrayList<Projection>();
    private final List<Schema> _schemas = new ArrayList<Schema>();
    private Condition _where;
    private Order _order;
    private Expression _limit;
    private Expression _offset;

    @Override
    public Schema newSchema(String name, String identifier) {
        return new SchemaImpl(name, identifier);
    }

    @Override
    public Schema newSchema(Class<?> type, String identifier) {
        return new SchemaImpl(type, identifier);
    }

    @Override
    public Parameter newParameter(int position) {
        return new PositionalParameter(position);
    }

    @Override
    public Parameter newParameter(String name) {
        return new NamedParameter(name);
    }

    @Override
    public Literal newBoolean(boolean value) {
        return new BooleanLiteral(value);
    }

    @Override
    public Literal newNumeric(long value) {
        return new LongLiteral(value);
    }

    @Override
    public Literal newNumeric(double value) {
        return new DoubleLiteral(value);
    }

    @Override
    public Literal newNumeric(BigDecimal value) {
        return new BigDecimalLiteral(value);
    }

    @Override
    public Literal newString(String value) {
        return new StringLiteral(value);
    }

    @Override
    public Literal newEnum(Enum<?> identifier) {
        return null;
    }

    @Override
    public Order newOrder(Field field) {
        OrderImpl order = new OrderImpl();
        order.add(field);
        return order;
    }

    @Override
    public Order newOrder(Field field, OrderDirection direction) {
        OrderImpl order = new OrderImpl();
        order.add(field, direction);
        return order;
    }

    @Override
    public Expression newTemporal(TemporalType temporalType) {
        return null;
    }

    @Override
    public Expression newTemporal(TemporalType temporalType, Date value) {
        return null;
    }

    @Override
    public Expression newTemporal(TemporalType temporalType, Calendar value) {
        return null;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this._distinct = distinct;
    }

    @Override
    public void addProjection(Field field) {
        this._projections.add(new ProjectionImpl(field));
    }

    @Override
    public void addProjection(Field field, String alias) {
        this._projections.add(new ProjectionImpl(field, alias));
    }

    @Override
    public void addSchema(Schema schema) {
        this._schemas.add(schema);
    }

    @Override
    public void setWhere(Condition condition) {
        this._where = condition;
    }

    @Override
    public void setOrder(Order order) {
        this._order = order;
    }

    @Override
    public void setLimit(int limit) {
        this._limit = new LongLiteral(limit);
        this._offset = null;
    }

    @Override
    public void setLimit(Parameter limit) {
        this._limit = limit;
        this._offset = null;
    }

    @Override
    public void setLimit(int limit, int offset) {
        this._limit = new LongLiteral(limit);
        this._offset = new LongLiteral(offset);
    }

    @Override
    public void setLimit(int limit, Parameter offset) {
        this._limit = new LongLiteral(limit);
        this._offset = offset;
    }

    @Override
    public void setLimit(Parameter limit, Parameter offset) {
        this._limit = limit;
        this._offset = offset;
    }

    @Override
    public void setLimit(Parameter limit, int offset) {
        this._limit = limit;
        this._offset = new LongLiteral(offset);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("SELECT ");
        if (this._distinct) {
            sb.append("DISTINCT ");
        }
        Iterator<Field> iter = this._projections.iterator();
        while (iter.hasNext()) {
            iter.next().toFullString(sb);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" FROM ");
        iter = this._schemas.iterator();
        while (iter.hasNext()) {
            ((Schema)iter.next()).toFullString(sb);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        if (this._where != null) {
            sb.append(" WHERE ");
            this._where.toString(sb);
        }
        if (this._order != null) {
            sb.append(" ORDER BY ");
            this._order.toString(sb);
        }
        if (this._limit != null) {
            sb.append(" LIMIT ");
            this._limit.toString(sb);
            if (this._offset != null) {
                sb.append(" OFFSET ");
                this._offset.toString(sb);
            }
        }
        return sb;
    }
}

