/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist;

import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.persist.AbstractTransactionContext;
import org.exolab.castor.jdo.ConnectionFailedException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.persist.LockEngine;

public final class GlobalTransactionContext
extends AbstractTransactionContext {
    private static final Log LOG = LogFactory.getLog(GlobalTransactionContext.class);

    public GlobalTransactionContext(Database db) {
        super(db);
    }

    protected CastorConnection createConnection(LockEngine engine) throws ConnectionFailedException {
        try {
            return engine.getDatabaseContext().getConnectionFactory().createCastorConnection();
        }
        catch (SQLException ex) {
            throw new ConnectionFailedException(Messages.format((String)"persist.nested", (Object)ex), ex);
        }
    }

    protected void commitConnections() throws TransactionAbortedException {
        Iterator<CastorConnection> iter = this.connectionsIterator();
        while (iter.hasNext()) {
            try {
                iter.next().close();
            }
            catch (SQLException ex) {
                LOG.warn((Object)"SQLException at close JDBC Connection instance.", (Throwable)ex);
            }
        }
        this.clearConnections();
    }

    protected void rollbackConnections() {
        Iterator<CastorConnection> iter = this.connectionsIterator();
        while (iter.hasNext()) {
            try {
                iter.next().close();
                LOG.debug((Object)"Connection closed");
            }
            catch (SQLException ex) {
                LOG.warn((Object)"SQLException at close JDBC Connection instance.", (Throwable)ex);
            }
        }
        this.clearConnections();
    }

    protected void closeConnections() throws TransactionAbortedException {
        SQLException error = null;
        Iterator<CastorConnection> iter = this.connectionsIterator();
        while (iter.hasNext()) {
            try {
                iter.next().close();
            }
            catch (SQLException ex) {
                error = ex;
            }
        }
        this.clearConnections();
        if (error != null) {
            throw new TransactionAbortedException(Messages.format((String)"persist.nested", (Object)error), error);
        }
    }
}

