/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist;

import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.connection.ConnectionFactory;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.persist.AbstractTransactionContext;
import org.exolab.castor.jdo.ConnectionFailedException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.persist.LockEngine;

public final class LocalTransactionContext
extends AbstractTransactionContext {
    private static final Log LOG = LogFactory.getLog(LocalTransactionContext.class);

    public LocalTransactionContext(Database db) {
        super(db);
    }

    protected CastorConnection createConnection(LockEngine engine) throws ConnectionFailedException {
        try {
            ConnectionFactory factory = engine.getDatabaseContext().getConnectionFactory();
            CastorConnection castorConn = factory.createCastorConnection();
            castorConn.setAutoCommit(false);
            return castorConn;
        }
        catch (SQLException ex) {
            throw new ConnectionFailedException(Messages.format((String)"persist.nested", (Object)ex), ex);
        }
    }

    /*
     * Loose catch block
     */
    protected void commitConnections() throws TransactionAbortedException {
        block10: {
            try {
                Iterator<CastorConnection> iter = this.connectionsIterator();
                while (iter.hasNext()) {
                    iter.next().commit();
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                Iterator<CastorConnection> iter = this.connectionsIterator();
                while (iter.hasNext()) {
                    try {
                        iter.next().close();
                    }
                    catch (SQLException ex) {
                        LOG.warn((Object)"SQLException at close JDBC Connection instance.", (Throwable)ex);
                    }
                }
                this.clearConnections();
                throw throwable;
            }
            Iterator<CastorConnection> iter = this.connectionsIterator();
            while (iter.hasNext()) {
                try {
                    iter.next().close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"SQLException at close JDBC Connection instance.", (Throwable)ex);
                }
            }
            {
                break block10;
                catch (SQLException ex) {
                    throw new TransactionAbortedException(Messages.format((String)"persist.nested", (Object)ex), ex);
                }
            }
        }
        this.clearConnections();
    }

    protected void rollbackConnections() {
        Iterator<CastorConnection> iter = this.connectionsIterator();
        while (iter.hasNext()) {
            CastorConnection conn = iter.next();
            try {
                conn.rollback();
                LOG.debug((Object)"Connection rolled back");
                conn.close();
                LOG.debug((Object)"Connection closed");
            }
            catch (SQLException ex) {
                LOG.warn((Object)"SQLException at rollback/close JDBC Connection instance.", (Throwable)ex);
            }
        }
        this.clearConnections();
    }

    protected void closeConnections() throws TransactionAbortedException {
    }
}

