/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.util.ClassLoadingUtils;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.spi.Identity;

public abstract class CollectionProxy {
    private static final Log LOG = LogFactory.getLog(CollectionProxy.class);

    public abstract Object getCollection();

    public abstract void add(Identity var1, Object var2);

    public abstract void close();

    public static CollectionProxy create(FieldMolder fieldMolder, Object object, ClassLoader classLoader) {
        Class<?> cls = fieldMolder.getCollectionType();
        if (cls == Vector.class) {
            return new ColProxy(fieldMolder, object, classLoader, new Vector());
        }
        if (cls == ArrayList.class) {
            return new ColProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == Collection.class) {
            return new ColProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == Set.class) {
            return new ColProxy(fieldMolder, object, classLoader, new HashSet());
        }
        if (cls == HashSet.class) {
            return new ColProxy(fieldMolder, object, classLoader, new HashSet());
        }
        if (cls == Hashtable.class) {
            return new MapProxy(fieldMolder, object, classLoader, new Hashtable());
        }
        if (cls == HashMap.class) {
            return new MapProxy(fieldMolder, object, classLoader, new HashMap());
        }
        if (cls == Iterator.class) {
            return new IteratorProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == Enumeration.class) {
            return new EnumerationProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == Map.class) {
            return new MapProxy(fieldMolder, object, classLoader, new HashMap());
        }
        if (cls == SortedSet.class) {
            String comparatorClassName = fieldMolder.getComparator();
            if (comparatorClassName != null) {
                Comparator comparator = CollectionProxy.loadComparator(classLoader, comparatorClassName);
                return new ColProxy(fieldMolder, object, classLoader, new TreeSet(comparator));
            }
            return new ColProxy(fieldMolder, object, classLoader, new TreeSet());
        }
        throw new IllegalArgumentException("Collection Proxy doesn't exist for this type : " + cls);
    }

    private static Comparator loadComparator(ClassLoader classLoader, String comparatorClassName) {
        Comparator comparator;
        String message = "Problem instantiating instance of " + comparatorClassName;
        try {
            Class<?> comparatorClass = ClassLoadingUtils.loadClass(classLoader, comparatorClassName);
            comparator = (Comparator)comparatorClass.newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        catch (IllegalAccessException e) {
            message = "Problem accessing constructor of " + comparatorClassName;
            LOG.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Problem loading class for " + comparatorClassName));
            throw new IllegalArgumentException(message);
        }
        return comparator;
    }

    private static final class MapProxy
    extends CollectionProxy {
        private Map _map;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private MapProxy(FieldMolder fm, Object object, ClassLoader cl, Map map) {
            this._cl = cl;
            this._map = map;
            this._fm = fm;
            this._object = object;
        }

        public Object getCollection() {
            return this._map;
        }

        public void add(Identity key, Object value) {
            if (key.size() == 1) {
                this._map.put(key.get(0), value);
            } else {
                this._map.put(key, value);
            }
        }

        public void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._map, this._cl);
            }
        }
    }

    private static final class IteratorProxy
    extends CollectionProxy {
        private Collection _collection;
        private FieldMolder _fieldMolder;
        private Object _object;
        private ClassLoader _cl;

        private IteratorProxy(FieldMolder fm, Object object, ClassLoader cl, Collection col) {
            this._cl = cl;
            this._fieldMolder = fm;
            this._collection = col;
            this._object = object;
        }

        public Object getCollection() {
            return this._collection.iterator();
        }

        public void add(Identity key, Object value) {
            if (!this._fieldMolder.isAddable()) {
                this._collection.add(value);
            } else {
                this._fieldMolder.addValue(this._object, value, this._cl);
            }
        }

        public void close() {
            if (!this._fieldMolder.isAddable()) {
                this._fieldMolder.setValue(this._object, this._collection.iterator(), this._cl);
            }
        }
    }

    private static final class EnumerationProxy
    extends CollectionProxy {
        private Collection _collection;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private EnumerationProxy(FieldMolder fm, Object object, ClassLoader cl, Collection collection) {
            this._cl = cl;
            this._fm = fm;
            this._collection = collection;
            this._object = object;
        }

        public Object getCollection() {
            return Collections.enumeration(this._collection);
        }

        public void add(Identity key, Object value) {
            if (!this._fm.isAddable()) {
                this._collection.add(value);
            } else {
                this._fm.addValue(this._object, value, this._cl);
            }
        }

        public void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, Collections.enumeration(this._collection), this._cl);
            }
        }
    }

    private static final class ColProxy
    extends CollectionProxy {
        private Collection _col;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private ColProxy(FieldMolder fm, Object object, ClassLoader cl, Collection col) {
            this._cl = cl;
            this._fm = fm;
            this._col = col;
            this._object = object;
        }

        public Object getCollection() {
            return this._col;
        }

        public void add(Identity key, Object value) {
            if (!this._fm.isAddable()) {
                this._col.add(value);
            } else {
                this._fm.addValue(this._object, value, this._cl);
            }
        }

        public void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._col, this._cl);
            }
        }
    }
}

