/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.proxy;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.proxy.LazyCollection;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyHashSet<E>
implements LazyCollection<E>,
Set<E> {
    private final TransactionContext _tx;
    private final ClassMolder _molder;
    private final List<Identity> _current = new ArrayList<Identity>();
    private final List<Identity> _removed = new ArrayList<Identity>();
    private final List<Identity> _added = new ArrayList<Identity>();
    private final Map<Identity, E> _loaded = new HashMap<Identity, E>();
    private int _changecount;
    private int _size;

    public LazyHashSet(TransactionContext tx, ClassMolder molder, List<Identity> ids) {
        this._tx = tx;
        this._molder = molder;
        if (ids != null) {
            this._current.addAll(ids);
        }
        this._size = this._current.size();
    }

    @Override
    public boolean add(E entity) {
        Identity id = this._molder.getIdentity(this._tx, entity);
        if (this._current.contains(id)) {
            if (this._removed.contains(id)) {
                this._removed.remove(id);
                this._loaded.put(id, entity);
                ++this._changecount;
                ++this._size;
                return true;
            }
            return this._loaded.put(id, entity) != entity;
        }
        if (this._removed.contains(id)) {
            throw new RuntimeException("Illegal Internal State.");
        }
        if (this._added.add(id)) {
            this._loaded.put(id, entity);
            ++this._changecount;
            ++this._size;
            return true;
        }
        return this._loaded.put(id, entity) != entity;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        Iterator<E> iter = collection.iterator();
        while (iter.hasNext()) {
            if (!this.add(iter.next())) continue;
            changed = true;
        }
        if (changed) {
            ++this._changecount;
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean contains(Object entity) {
        Identity id = this._molder.getIdentity(this._tx, entity);
        if (this._added.contains(id)) {
            return true;
        }
        return this._current.contains(id) && !this._removed.contains(id);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImp(this);
    }

    @Override
    public boolean remove(Object entity) {
        Identity id = this._molder.getIdentity(this._tx, entity);
        if (this._removed.contains(id)) {
            return false;
        }
        if (this._added.contains(id)) {
            this._added.remove(id);
            ++this._changecount;
            --this._size;
            return true;
        }
        if (this._current.contains(id)) {
            this._loaded.put(id, entity);
            this._removed.add(id);
            ++this._changecount;
            --this._size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            changed = true;
        }
        if (changed) {
            ++this._changecount;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            E entity = iter.next();
            if (collection.contains(entity)) continue;
            changed = true;
            iter.remove();
        }
        if (changed) {
            ++this._changecount;
        }
        return changed;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int count = 0;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            result[count++] = iter.next();
        }
        return result;
    }

    @Override
    public <A> A[] toArray(A[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int size = this.size();
        Object[] result = size <= array.length ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        Iterator<E> iter = this.iterator();
        int count = 0;
        while (iter.hasNext()) {
            result[count++] = iter.next();
        }
        while (count < result.length) {
            result[count++] = null;
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public List<Identity> getIdsList() {
        ArrayList<Identity> result = new ArrayList<Identity>();
        result.addAll(this._current);
        result.addAll(this._added);
        result.removeAll(this._removed);
        return result;
    }

    @Override
    public List<Identity> getRemovedIdsList() {
        return this._removed;
    }

    @Override
    public List<E> getAddedEntitiesList() {
        ArrayList<E> added = new ArrayList<E>();
        Iterator<Identity> iter = this._added.iterator();
        while (iter.hasNext()) {
            added.add(this._loaded.get(iter.next()));
        }
        return added;
    }

    @Override
    public void committed(TransactionContext tx) {
        if (tx == this._tx) {
            this._added.clear();
            this._removed.clear();
            this._changecount = 0;
            tx.removeTxSynchronizable(this);
        }
    }

    @Override
    public void rolledback(TransactionContext tx) {
        this.committed(tx);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IteratorImp
    implements Iterator<E> {
        private int _changestamp;
        private int _cursor;
        private int _iterationsize;
        private LazyHashSet<E> _parent;

        private IteratorImp(LazyHashSet<E> rc) {
            this._parent = rc;
            this._changestamp = rc._changecount;
            this._iterationsize = this._parent._added.size() + this._parent._current.size();
        }

        @Override
        public boolean hasNext() {
            if (this._changestamp != this._parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            if (this._cursor >= LazyHashSet.this._added.size()) {
                while (this._cursor < this._iterationsize && this.isSkipped((Identity)LazyHashSet.this._current.get(this._cursor - LazyHashSet.this._added.size()))) {
                    ++this._cursor;
                }
            }
            return this._cursor < this._iterationsize;
        }

        @Override
        public E next() {
            if (this._changestamp != this._parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("Read after the end of iterator!");
            }
            if (this._cursor < LazyHashSet.this._added.size()) {
                Identity id = (Identity)LazyHashSet.this._added.get(this._cursor++);
                Object entity = LazyHashSet.this._loaded.get(id);
                if (entity != null) {
                    return entity;
                }
                return this.lazyLoad(id);
            }
            Identity id = (Identity)LazyHashSet.this._current.get(this._cursor++ - LazyHashSet.this._added.size());
            Object entity = LazyHashSet.this._loaded.get(id);
            if (entity != null) {
                return entity;
            }
            return this.lazyLoad(id);
        }

        private boolean isSkipped(Identity id) {
            if (LazyHashSet.this._removed.contains(id)) {
                return true;
            }
            OID oid = new OID(this._parent._molder, id);
            return this._parent._tx.isDeletedByOID(this._parent._molder.getLockEngine(), oid);
        }

        private E lazyLoad(Identity ids) {
            if (!LazyHashSet.this._tx.isOpen()) {
                throw new RuntimeException("Transaction is closed!");
            }
            try {
                ProposedEntity proposedValue = new ProposedEntity(this._parent._molder);
                Object o = this._parent._tx.load(ids, proposedValue, null);
                this._parent._loaded.put(ids, o);
                return o;
            }
            catch (LockNotGrantedException e) {
                throw new RuntimeException("Lock Not Granted for lazy loaded object\n" + (Object)((Object)e));
            }
            catch (PersistenceException e) {
                throw new RuntimeException("PersistenceException for lazy loaded object\n" + (Object)((Object)e));
            }
        }

        @Override
        public void remove() {
            if (this._cursor <= 0) {
                throw new IllegalStateException("Method next() must be called before remove!");
            }
            if (this._changestamp != this._parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            --this._cursor;
            if (this._cursor < LazyHashSet.this._added.size()) {
                this._parent._added.remove(this._cursor);
                this._parent._size--;
                --this._iterationsize;
                this._parent._changecount++;
                this._changestamp = this._parent._changecount;
            } else {
                Identity id = (Identity)LazyHashSet.this._current.get(this._cursor);
                while (LazyHashSet.this._removed.contains(id)) {
                    id = (Identity)LazyHashSet.this._current.get(this._cursor--);
                }
                if (this._cursor < LazyHashSet.this._added.size()) {
                    this._parent._added.remove(id);
                    this._parent._size--;
                    --this._iterationsize;
                    this._parent._changecount++;
                    this._changestamp = this._parent._changecount;
                } else {
                    this._parent._removed.add(id);
                    this._parent._size--;
                    this._parent._changecount++;
                    ++this._cursor;
                    this._changestamp = this._parent._changecount;
                }
            }
        }
    }
}

