/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.proxy.CollectionProxy;
import org.castor.persist.proxy.LazyCollection;
import org.castor.persist.proxy.LazyHashSet;
import org.castor.persist.resolver.BaseRelationResolver;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

public abstract class ManyRelationResolver
extends BaseRelationResolver {
    private final int _fieldIndex;

    public ManyRelationResolver(ClassMolder classMolder, FieldMolder fieldMolder, int fieldIndex) {
        super(classMolder, fieldMolder);
        this._fieldIndex = fieldIndex;
    }

    public final Object create(TransactionContext tx, Object object) {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            return ClassMolderHelper.getIdsList(tx, fieldClassMolder, o);
        }
        return null;
    }

    public abstract boolean markCreate(TransactionContext var1, OID var2, Object var3) throws PersistenceException;

    public abstract UpdateFlags preStore(TransactionContext var1, OID var2, Object var3, int var4, Object var5) throws PersistenceException;

    public final Object store(TransactionContext tx, Object object, Object field) {
        return null;
    }

    public abstract void update(TransactionContext var1, OID var2, Object var3, AccessMode var4, Object var5) throws PersistenceException;

    public final Object updateCache(TransactionContext tx, OID oid, Object object) {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (value != null) {
            if (!(value instanceof LazyCollection)) {
                return ClassMolderHelper.getIdsList(tx, fieldClassMolder, value);
            }
            LazyCollection lazy = (LazyCollection)value;
            return lazy.getIdsList();
        }
        return null;
    }

    public abstract void markDelete(TransactionContext var1, Object var2, Object var3) throws PersistenceException;

    public final void revertObject(TransactionContext tx, OID oid, Object object, Object field) throws PersistenceException {
        Object o = field;
        if (o == null) {
            this._fieldMolder.setValue(object, null, tx.getClassLoader());
        } else if (!this._fieldMolder.isLazy()) {
            ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
            Class<?> collectionType = this._fieldMolder.getCollectionType();
            ArrayList v = (ArrayList)field;
            if (v != null) {
                if (collectionType.isArray()) {
                    Object[] arrayValue = (Object[])Array.newInstance(collectionType.getComponentType(), v.size());
                    for (int j = 0; j < v.size(); ++j) {
                        arrayValue[j] = tx.fetch(fieldClassMolder, (Identity)v.get(j), null);
                    }
                    this._fieldMolder.setValue(object, arrayValue, tx.getClassLoader());
                } else {
                    CollectionProxy cp = CollectionProxy.create(this._fieldMolder, object, tx.getClassLoader());
                    this._fieldMolder.setValue(object, cp.getCollection(), tx.getClassLoader());
                    for (int j = 0; j < v.size(); ++j) {
                        Object obj = tx.fetch(fieldClassMolder, (Identity)v.get(j), null);
                        if (obj == null) continue;
                        cp.add((Identity)v.get(j), obj);
                    }
                    cp.close();
                }
            } else {
                this._fieldMolder.setValue(object, null, tx.getClassLoader());
            }
        } else {
            List list = (List)field;
            ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
            LazyHashSet relcol = new LazyHashSet(tx, fieldClassMolder, list);
            this._fieldMolder.setValue(object, relcol, tx.getClassLoader());
        }
    }

    public final void expireCache(TransactionContext tx, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        ArrayList v = (ArrayList)field;
        if (v != null) {
            for (int j = 0; j < v.size(); ++j) {
                tx.expireCache(fieldClassMolder, (Identity)v.get(j));
            }
        }
    }

    public final void load(TransactionContext tx, OID oid, ProposedEntity proposedObject, AccessMode suggestedAccessMode) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        if (!this._fieldMolder.isLazy()) {
            ArrayList v = (ArrayList)proposedObject.getField(this._fieldIndex);
            if (v != null) {
                Class<?> collectionType = this._fieldMolder.getCollectionType();
                if (collectionType.isArray()) {
                    Object[] value = (Object[])Array.newInstance(collectionType.getComponentType(), v.size());
                    for (int j = 0; j < v.size(); ++j) {
                        ProposedEntity proposedValue = new ProposedEntity(fieldClassMolder);
                        value[j] = tx.load((Identity)v.get(j), proposedValue, suggestedAccessMode);
                    }
                    this._fieldMolder.setValue(proposedObject.getEntity(), value, tx.getClassLoader());
                } else {
                    CollectionProxy cp = CollectionProxy.create(this._fieldMolder, proposedObject.getEntity(), tx.getClassLoader());
                    for (int j = 0; j < v.size(); ++j) {
                        ProposedEntity proposedValue = new ProposedEntity(fieldClassMolder);
                        cp.add((Identity)v.get(j), tx.load((Identity)v.get(j), proposedValue, suggestedAccessMode));
                    }
                    cp.close();
                }
            } else {
                this._fieldMolder.setValue(proposedObject.getEntity(), null, tx.getClassLoader());
            }
        } else {
            List list = (List)proposedObject.getField(this._fieldIndex);
            LazyHashSet relcol = new LazyHashSet(tx, fieldClassMolder, list);
            this._fieldMolder.setValue(proposedObject.getEntity(), relcol, tx.getClassLoader());
        }
    }

    public abstract Object postCreate(TransactionContext var1, OID var2, Object var3, Object var4, Identity var5) throws PersistenceException;

    public final UpdateAndRemovedFlags removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        ClassMolder relatedBaseMolder;
        UpdateAndRemovedFlags flags = new UpdateAndRemovedFlags();
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        for (relatedBaseMolder = relatedMolder; fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null; relatedBaseMolder = relatedBaseMolder.getExtends()) {
        }
        if (fieldClassMolder == relatedBaseMolder) {
            boolean changed = false;
            Object related = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (related instanceof LazyCollection) {
                LazyCollection lazy = (LazyCollection)related;
                changed = lazy.remove(relatedObject);
            } else {
                Iterator itor = ClassMolderHelper.getIterator(related);
                while (itor.hasNext()) {
                    Object o = itor.next();
                    if (o != relatedObject) continue;
                    changed = true;
                    itor.remove();
                }
            }
            if (changed) {
                flags.setUpdateCache(true);
                flags.setUpdatePersist(false);
                flags.setRemoved(true);
            }
        }
        return flags;
    }
}

