/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo;

import org.castor.core.util.Messages;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.Identity;

public class CacheManager {
    private Database _db;
    private LockEngine _lockEngine;
    private TransactionContext _transactionContext;

    public CacheManager(Database db, TransactionContext transactionContext, LockEngine lockEngine) {
        this._db = db;
        this._transactionContext = transactionContext;
        this._lockEngine = lockEngine;
    }

    public boolean isCached(Class cls, Object identity) throws PersistenceException {
        if (this._transactionContext != null && this._transactionContext.isOpen()) {
            ClassMolder molder = this._lockEngine.getClassMolderRegistry().getClassMolder(cls);
            return this._transactionContext.isCached(molder, cls, new Identity(identity));
        }
        throw new PersistenceException("isCached() has to be called within an active transaction.");
    }

    public void dumpCache() {
        this._lockEngine.dumpCache();
    }

    public void dumpCache(Class cls) {
        this._lockEngine.dumpCache(cls);
    }

    public void expireCache() {
        this._lockEngine.expireCache();
    }

    public void expireCache(Class type, Object identity) throws PersistenceException {
        this.expireCache(type, new Object[]{identity});
    }

    public void expireCache(Class type, Object[] identity) throws PersistenceException {
        this.testForOpenDatabase();
        ClassMolder molder = this._lockEngine.getClassMolderRegistry().getClassMolder(type);
        for (int i = 0; i < identity.length; ++i) {
            this._transactionContext.expireCache(molder, new Identity(identity[i]));
        }
    }

    public void expireCache(Class[] type) {
        for (int i = 0; i < type.length; ++i) {
            this._lockEngine.expireCache(type[i]);
        }
    }

    private void testForOpenDatabase() throws PersistenceException {
        if (this._db.isClosed()) {
            throw new PersistenceException(Messages.message((String)"jdo.dbClosed"));
        }
    }
}

