/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import org.castor.core.nature.PropertyHolder;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;

public class SQLFieldInfo {
    private final String _tableName;
    private String _tableAlias;
    private final boolean _store;
    private final boolean _multi;
    private final boolean _joined;
    private final boolean _dirtyCheck;
    private final String[] _joinFields;
    private final SQLColumnInfo[] _columns;
    private final FieldDescriptor _fieldDescriptor;

    public SQLFieldInfo(ClassDescriptor clsDesc, FieldDescriptor fieldDesc, String classTable, boolean ext) throws MappingException {
        this._fieldDescriptor = fieldDesc;
        ClassDescriptor related = fieldDesc.getClassDescriptor();
        if (related != null) {
            if (!related.hasNature(ClassDescriptorJDONature.class.getName())) {
                throw new MappingException("Related class is not JDOClassDescriptor");
            }
            FieldDescriptor[] relids = ((ClassDescriptorImpl)related).getIdentities();
            String[] relnames = new String[relids.length];
            for (int i = 0; i < relids.length; ++i) {
                relnames[i] = new FieldDescriptorJDONature((PropertyHolder)relids[i]).getSQLName()[0];
                if (relnames[i] != null) continue;
                throw new MappingException("Related class identities field does not contains sql information!");
            }
            FieldDescriptor[] classids = ((ClassDescriptorImpl)clsDesc).getIdentities();
            String[] classnames = new String[classids.length];
            for (int i = 0; i < classids.length; ++i) {
                classnames[i] = new FieldDescriptorJDONature((PropertyHolder)classids[i]).getSQLName()[0];
                if (classnames[i] != null) continue;
                throw new MappingException("Related class identities field does not contains sql information!");
            }
            String[] names = relnames;
            if (!fieldDesc.hasNature(FieldDescriptorJDONature.class.getName())) {
                this._tableName = new ClassDescriptorJDONature((PropertyHolder)related).getTableName();
                this._store = false;
                this._multi = fieldDesc.isMultivalued();
                this._joined = true;
                this._joinFields = classnames;
                this._dirtyCheck = true;
            } else {
                FieldDescriptorJDONature jdoFieldNature = new FieldDescriptorJDONature((PropertyHolder)fieldDesc);
                names = jdoFieldNature.getSQLName();
                if (names != null && names.length != relids.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                names = names != null ? names : relnames;
                String[] joins = jdoFieldNature.getManyKey();
                if (joins != null && joins.length != classids.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                if (jdoFieldNature.getManyTable() != null) {
                    this._tableName = jdoFieldNature.getManyTable();
                    this._store = false;
                    this._multi = fieldDesc.isMultivalued();
                    this._joined = true;
                    this._joinFields = joins != null ? joins : classnames;
                } else if (jdoFieldNature.getSQLName() != null) {
                    this._tableName = classTable;
                    this._store = !ext && !jdoFieldNature.isReadonly();
                    this._multi = false;
                    this._joined = false;
                    this._joinFields = classnames;
                } else {
                    this._tableName = new ClassDescriptorJDONature((PropertyHolder)related).getTableName();
                    this._store = false;
                    this._multi = fieldDesc.isMultivalued();
                    this._joined = true;
                    this._joinFields = joins != null ? joins : classnames;
                }
                this._dirtyCheck = jdoFieldNature.isDirtyCheck();
            }
            this._columns = new SQLColumnInfo[relids.length];
            for (int i = 0; i < relids.length; ++i) {
                if (!relids[i].hasNature(FieldDescriptorJDONature.class.getName())) {
                    throw new MappingException("Related class identities field does not contains sql information!");
                }
                FieldDescriptor relId = relids[i];
                FieldHandlerImpl fh = (FieldHandlerImpl)relId.getHandler();
                this._columns[i] = new SQLColumnInfo(names[i], new FieldDescriptorJDONature((PropertyHolder)relId).getSQLType()[0], fh.getConvertTo(), fh.getConvertFrom());
            }
        } else {
            FieldDescriptorJDONature jdoFieldNature = new FieldDescriptorJDONature((PropertyHolder)fieldDesc);
            this._tableName = classTable;
            this._store = !ext && !new FieldDescriptorJDONature((PropertyHolder)fieldDesc).isReadonly();
            this._multi = false;
            this._joined = false;
            this._joinFields = null;
            this._dirtyCheck = jdoFieldNature.isDirtyCheck();
            this._columns = new SQLColumnInfo[1];
            String sqlName = fieldDesc.getFieldName();
            if (jdoFieldNature.getSQLName() != null) {
                sqlName = jdoFieldNature.getSQLName()[0];
            }
            FieldHandlerImpl fh = (FieldHandlerImpl)fieldDesc.getHandler();
            this._columns[0] = new SQLColumnInfo(sqlName, jdoFieldNature.getSQLType()[0], fh.getConvertTo(), fh.getConvertFrom());
        }
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getTableAlias() {
        return this._tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this._tableAlias = tableAlias;
    }

    public boolean isStore() {
        return this._store;
    }

    public boolean isMulti() {
        return this._multi;
    }

    public boolean isJoined() {
        return this._joined;
    }

    public boolean isDirtyCheck() {
        return this._dirtyCheck;
    }

    public String[] getJoinFields() {
        return this._joinFields;
    }

    public SQLColumnInfo[] getColumnInfo() {
        return this._columns;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this._fieldDescriptor;
    }

    public String toString() {
        return this._tableName + "." + this._fieldDescriptor.getFieldName();
    }
}

