/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.HashMap;
import org.exolab.castor.jdo.oql.InvalidCharException;
import org.exolab.castor.jdo.oql.Token;

public final class Lexer {
    private static final HashMap KEYWORDS = new HashMap();
    private int _pos;
    private String _queryString;
    private boolean _noMoreTokens = false;

    public Lexer(String oqlQueryString) {
        this._queryString = oqlQueryString;
    }

    public boolean hasMoreTokens() {
        return !this._noMoreTokens;
    }

    public Token nextToken() throws InvalidCharException {
        char curChar;
        char oldChar = this._pos > 0 ? this._queryString.charAt(this._pos - 1) : (char)'\u0000';
        if (this._pos < this._queryString.length()) {
            curChar = this._queryString.charAt(this._pos);
        } else {
            this._noMoreTokens = true;
            return Token.END_OF_QUERY;
        }
        while (this.isWhiteSpace(curChar)) {
            oldChar = curChar;
            ++this._pos;
            if (this._pos < this._queryString.length()) {
                curChar = this._queryString.charAt(this._pos);
                continue;
            }
            this._noMoreTokens = true;
            return Token.END_OF_QUERY;
        }
        if (this.isDigit(curChar)) {
            return this.numericLiteral();
        }
        if (this.isLetter(curChar)) {
            return this.identifier(oldChar);
        }
        int nextChar = 0;
        if (this._pos + 1 < this._queryString.length()) {
            nextChar = this._queryString.charAt(this._pos + 1);
        }
        if (curChar == '!' && nextChar == 61) {
            this._pos += 2;
            return Token.NOT_EQUAL;
        }
        if (curChar == '>' && nextChar == 61) {
            this._pos += 2;
            return Token.GTE;
        }
        if (curChar == '<' && nextChar == 61) {
            this._pos += 2;
            return Token.LTE;
        }
        if (curChar == '|' && nextChar == 124) {
            this._pos += 2;
            return Token.CONCAT;
        }
        if (curChar == '-' && nextChar == 62) {
            this._pos += 2;
            return Token.ARROW;
        }
        Token retToken = null;
        switch (curChar) {
            case '\'': {
                return this.charLiteral();
            }
            case '\"': {
                return this.stringLiteral();
            }
            case ':': {
                retToken = Token.COLON;
                break;
            }
            case '=': {
                retToken = Token.EQUAL;
                break;
            }
            case '<': {
                retToken = Token.LT;
                break;
            }
            case '>': {
                retToken = Token.GT;
                break;
            }
            case '+': {
                retToken = Token.PLUS;
                break;
            }
            case '-': {
                retToken = Token.MINUS;
                break;
            }
            case '*': {
                retToken = Token.TIMES;
                break;
            }
            case '/': {
                retToken = Token.DIVIDE;
                break;
            }
            case '(': {
                retToken = Token.LPAREN;
                break;
            }
            case ')': {
                retToken = Token.RPAREN;
                break;
            }
            case '.': {
                retToken = Token.DOT;
                break;
            }
            case '$': {
                retToken = Token.DOLLAR;
                break;
            }
            case ',': {
                retToken = Token.COMMA;
                break;
            }
        }
        if (retToken == null) {
            throw new InvalidCharException("An invalid character was found in the query at position " + this._pos);
        }
        ++this._pos;
        return retToken;
    }

    private boolean isWhiteSpace(char theChar) {
        switch (theChar) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private boolean isDigit(char theChar) {
        return Character.isDigit(theChar);
    }

    private boolean isLetter(char theChar) {
        return Character.isLetter(theChar);
    }

    private Token stringLiteral() throws InvalidCharException {
        if (this._pos >= this._queryString.length()) {
            return null;
        }
        char curChar = this._queryString.charAt(this._pos);
        if (curChar != '\"') {
            throw new InvalidCharException("stringLiteral() was called when the next character was not a double quote.  Position: " + this._pos);
        }
        StringBuffer sb = new StringBuffer("\"");
        ++this._pos;
        try {
            curChar = this._queryString.charAt(this._pos);
            while (curChar != '\"') {
                sb.append(curChar);
                if (curChar == '\\') {
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
                    sb.append(curChar);
                }
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            sb.append(curChar);
            ++this._pos;
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query string reached, but \" expected.");
        }
        return new Token(36, sb.toString());
    }

    private Token charLiteral() throws InvalidCharException {
        StringBuffer sb;
        block6: {
            if (this._pos >= this._queryString.length()) {
                return null;
            }
            char curChar = this._queryString.charAt(this._pos);
            if (curChar != '\'') {
                throw new InvalidCharException("charLiteral() was called when the next character was not a double quote.  Position: " + this._pos);
            }
            sb = new StringBuffer("'");
            ++this._pos;
            try {
                curChar = this._queryString.charAt(this._pos);
                sb.append(curChar);
                ++this._pos;
                if (curChar == '\\') {
                    curChar = this._queryString.charAt(this._pos);
                    sb.append(curChar);
                    ++this._pos;
                }
                if ((curChar = this._queryString.charAt(this._pos)) == '\'') {
                    sb.append(curChar);
                    ++this._pos;
                    break block6;
                }
                throw new InvalidCharException("Character literals may only contain a single character or escape sequence.  Position: " + this._pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidCharException("End of query string reached, but ' expected.");
            }
        }
        return new Token(35, sb.toString());
    }

    private char getChar() {
        if (this._pos < this._queryString.length()) {
            return this._queryString.charAt(this._pos);
        }
        return '\u0000';
    }

    private Token numericLiteral() throws InvalidCharException {
        if (this._pos >= this._queryString.length()) {
            return null;
        }
        char curChar = this._queryString.charAt(this._pos);
        if (!this.isDigit(curChar)) {
            throw new InvalidCharException("numericLiteral() was called when the next character was not a digit.  Position: " + this._pos);
        }
        StringBuffer sb = new StringBuffer().append(curChar);
        ++this._pos;
        curChar = this.getChar();
        while (this.isDigit(curChar)) {
            sb.append(curChar);
            ++this._pos;
            curChar = this.getChar();
        }
        if (curChar == '.') {
            sb.append('.');
            ++this._pos;
            curChar = this.getChar();
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected after decimal point in double literal. Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this.getChar();
            }
            if (curChar == 'E' || curChar == 'e') {
                sb.append(curChar);
                ++this._pos;
                curChar = this.getChar();
                boolean isExponentSigned = false;
                if (curChar == '+' || curChar == '-') {
                    isExponentSigned = true;
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this.getChar();
                }
                if (!this.isDigit(curChar)) {
                    if (isExponentSigned) {
                        throw new InvalidCharException("Digit expected after sign in exponent (double literal).  Position: " + this._pos);
                    }
                    throw new InvalidCharException("Digit expected after exponent character (double literal).  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this.getChar();
                while (this.isDigit(curChar)) {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this.getChar();
                }
            }
            return new Token(34, sb.toString());
        }
        return new Token(33, sb.toString());
    }

    private Token identifier(char oldChar) throws InvalidCharException {
        if (this._pos >= this._queryString.length()) {
            return null;
        }
        char curChar = this._queryString.charAt(this._pos);
        if (!this.isLetter(curChar)) {
            throw new InvalidCharException("identifier() was called when the next character was not a letter.  Position: " + this._pos);
        }
        StringBuffer sb = new StringBuffer().append(curChar);
        ++this._pos;
        curChar = this.getChar();
        while (this.isDigit(curChar) || this.isLetter(curChar) || curChar == '_') {
            sb.append(curChar);
            ++this._pos;
            curChar = this.getChar();
        }
        String ident = sb.toString().toLowerCase();
        if (oldChar == '.') {
            return new Token(2, sb.toString());
        }
        if (ident.equals("date")) {
            return this.dateLiteral(sb.toString());
        }
        if (ident.equals("time")) {
            return this.timeLiteral(sb.toString());
        }
        if (ident.equals("timestamp")) {
            return this.timeStampLiteral(sb.toString());
        }
        if (ident.equals("true") || ident.equals("false")) {
            return new Token(32, sb.toString());
        }
        if (KEYWORDS.containsKey(ident)) {
            return new Token((Integer)KEYWORDS.get(ident), sb.toString());
        }
        return new Token(2, sb.toString());
    }

    private Token dateLiteral(String alreadyConsumed) throws InvalidCharException {
        StringBuffer sb = new StringBuffer(alreadyConsumed);
        char curChar = this.getChar();
        try {
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (curChar != '\'') {
                throw new InvalidCharException("The date keyword must be followed by a single quote.  Position: " + this._pos);
            }
            sb.append(" '");
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '-') {
                throw new InvalidCharException("- expected.  Fields in date literal must be separated by a dash.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '-') {
                throw new InvalidCharException("- expected.  Fields in date literal must be separated by a dash.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '\'') {
                throw new InvalidCharException("' expected.  Date literal must be enclosed by a single quotes.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            return new Token(37, sb.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query encountered in the middle of date literal.");
        }
    }

    private Token timeLiteral(String alreadyConsumed) throws InvalidCharException {
        StringBuffer sb = new StringBuffer(alreadyConsumed);
        char curChar = this.getChar();
        try {
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (curChar != '\'') {
                throw new InvalidCharException("The time keyword must be followed by a single quote.  Position: " + this._pos);
            }
            sb.append(" '");
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                throw new InvalidCharException(": expected.  Fields in time literal must be separated by a colon.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                throw new InvalidCharException(": expected.  Fields in time literal must be separated by a colon.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if (curChar == '.') {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                if (!this.isDigit(curChar)) {
                    throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
                }
                while (this.isDigit(curChar)) {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
                }
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '\'') {
                throw new InvalidCharException("' expected.  Time literal must be enclosed by a single quotes.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            return new Token(38, sb.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query encountered in the middle of time literal.");
        }
    }

    private Token timeStampLiteral(String alreadyConsumed) throws InvalidCharException {
        StringBuffer sb = new StringBuffer(alreadyConsumed);
        char curChar = this.getChar();
        try {
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (curChar != '\'') {
                throw new InvalidCharException("The timestamp keyword must be followed by a single quote.  Position: " + this._pos);
            }
            sb.append(" '");
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '-') {
                throw new InvalidCharException("- expected.  Fields in date part of timestamp literal must be separated by a dash.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '-') {
                throw new InvalidCharException("- expected.  Fields in date part of timestamp literal must be separated by a dash.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if (!this.isWhiteSpace(curChar)) {
                throw new InvalidCharException("White space expected in timestamp literal.  Position: " + this._pos);
            }
            curChar = this.consumeWhiteSpace(curChar);
            sb.append(' ');
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                throw new InvalidCharException(": expected.  Fields in time part of timestamp literal must be separated by a colon.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                throw new InvalidCharException(": expected.  Fields in time part of timestamp literal must be separated by a colon.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            if (curChar == '.') {
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                if (!this.isDigit(curChar)) {
                    throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
                }
                while (this.isDigit(curChar)) {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
                }
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '\'') {
                throw new InvalidCharException("' expected.  Timestamp literal must be enclosed by a single quotes.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            return new Token(39, sb.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query encountered in the middle of time literal.");
        }
    }

    private char consumeWhiteSpace(char curChar) {
        char currentChar = curChar;
        while (this.isWhiteSpace(currentChar)) {
            ++this._pos;
            currentChar = this._queryString.charAt(this._pos);
        }
        return currentChar;
    }

    static {
        KEYWORDS.put("select", new Integer(1));
        KEYWORDS.put("as", new Integer(3));
        KEYWORDS.put("from", new Integer(5));
        KEYWORDS.put("in", new Integer(6));
        KEYWORDS.put("where", new Integer(7));
        KEYWORDS.put("or", new Integer(8));
        KEYWORDS.put("and", new Integer(9));
        KEYWORDS.put("like", new Integer(12));
        KEYWORDS.put("mod", new Integer(22));
        KEYWORDS.put("abs", new Integer(23));
        KEYWORDS.put("not", new Integer(24));
        KEYWORDS.put("nil", new Integer(28));
        KEYWORDS.put("undefined", new Integer(29));
        KEYWORDS.put("between", new Integer(40));
        KEYWORDS.put("distinct", new Integer(41));
        KEYWORDS.put("is_defined", new Integer(42));
        KEYWORDS.put("is_undefined", new Integer(43));
        KEYWORDS.put("list", new Integer(44));
        KEYWORDS.put("order", new Integer(46));
        KEYWORDS.put("by", new Integer(47));
        KEYWORDS.put("asc", new Integer(48));
        KEYWORDS.put("desc", new Integer(49));
        KEYWORDS.put("count", new Integer(50));
        KEYWORDS.put("sum", new Integer(51));
        KEYWORDS.put("min", new Integer(52));
        KEYWORDS.put("max", new Integer(53));
        KEYWORDS.put("avg", new Integer(54));
        KEYWORDS.put("limit", new Integer(55));
        KEYWORDS.put("offset", new Integer(56));
    }
}

