/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.EnumerationIterator;
import org.castor.persist.TransactionContext;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.spi.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMolderHelper {
    public static final Log LOG = LogFactory.getLog(ClassMolderHelper.class);

    private ClassMolderHelper() {
    }

    public static boolean isEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof BigDecimal && ((BigDecimal)o1).compareTo((BigDecimal)o2) == 0) {
            return true;
        }
        if (o1 instanceof Timestamp && o2 instanceof Timestamp) {
            Timestamp t1 = (Timestamp)o1;
            Timestamp t2 = (Timestamp)o2;
            return t1.getTime() == t2.getTime() && t1.getNanos() / 1000000 == t2.getNanos() / 1000000;
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        return false;
    }

    public static boolean isEquals(Collection c1, Collection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.containsAll(c2) && c2.containsAll(c1);
    }

    public static List<Identity> getIdsList(TransactionContext tx, ClassMolder molder, Object col) {
        ArrayList<Identity> idList = new ArrayList<Identity>();
        if (col.getClass().isArray()) {
            Object[] colArr = (Object[])col;
            for (int i = 0; i < colArr.length; ++i) {
                Identity id = molder.getIdentity(tx, colArr[i]);
                if (id == null) continue;
                idList.add(id);
            }
        } else if (col instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)col;
            while (enumeration.hasMoreElements()) {
                Identity id = molder.getIdentity(tx, enumeration.nextElement());
                if (id == null) continue;
                idList.add(id);
            }
        } else {
            Iterator<Object> iter;
            if (col instanceof Iterator) {
                iter = (Iterator)col;
            } else if (col instanceof Collection) {
                iter = ((Collection)col).iterator();
            } else if (col instanceof Map) {
                iter = ((Map)col).values().iterator();
            } else {
                throw new IllegalArgumentException("A Collection or Map is expected!");
            }
            while (iter.hasNext()) {
                Identity id = molder.getIdentity(tx, iter.next());
                if (id == null) continue;
                idList.add(id);
            }
        }
        return idList;
    }

    public static Iterator getIterator(Object object) {
        if (object == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)object);
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        if (object.getClass().isArray()) {
            final class ArrayIterator
            implements Iterator {
                private Object[] _array;
                private int _i = 0;

                ArrayIterator(Object[] array) {
                    this._array = array;
                }

                public boolean hasNext() {
                    return this._i < this._array.length;
                }

                public Object next() {
                    return this._array[this._i++];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new ArrayIterator((Object[])object);
        }
        throw new IllegalArgumentException();
    }

    public static Collection<Object> getAddedEntitiesList(TransactionContext tx, List<Identity> orgIds, Object collection, ClassMolder molder) {
        if (collection == null) {
            return new ArrayList<Object>(0);
        }
        if (orgIds == null || orgIds.size() == 0) {
            if (collection.getClass().isArray()) {
                ArrayList<Object> added = new ArrayList<Object>();
                Object[] newArr = (Object[])collection;
                for (int i = 0; i < newArr.length; ++i) {
                    Object newValue = newArr[i];
                    added.add(newValue);
                }
                return added;
            }
            if (collection instanceof Enumeration) {
                ArrayList<Object> added = new ArrayList<Object>();
                Enumeration newEnum = (Enumeration)collection;
                while (newEnum.hasMoreElements()) {
                    Object newValue = newEnum.nextElement();
                    added.add(newValue);
                }
                return added;
            }
            if (collection instanceof Iterator) {
                ArrayList<Object> added = new ArrayList<Object>();
                Iterator newIter = (Iterator)collection;
                while (newIter.hasNext()) {
                    Object newValue = newIter.next();
                    added.add(newValue);
                }
                return added;
            }
            if (collection instanceof Collection) {
                return (Collection)collection;
            }
            if (collection instanceof Map) {
                return ((Map)collection).values();
            }
            throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
        }
        ArrayList<Object> added = new ArrayList<Object>();
        HashSet<Identity> orgSet = new HashSet<Identity>(orgIds);
        if (collection.getClass().isArray()) {
            Object[] newArr = (Object[])collection;
            for (int i = 0; i < newArr.length; ++i) {
                Object newValue = newArr[i];
                Identity newId = molder.getIdentity(tx, newValue);
                if (newId != null && orgSet.contains(newId)) continue;
                added.add(newValue);
            }
        } else if (collection instanceof Enumeration) {
            Enumeration newEnum = (Enumeration)collection;
            while (newEnum.hasMoreElements()) {
                Object newValue = newEnum.nextElement();
                Identity newId = molder.getIdentity(tx, newValue);
                if (newId != null && orgSet.contains(newId)) continue;
                added.add(newValue);
            }
        } else {
            Iterator<Object> newIter;
            if (collection instanceof Iterator) {
                newIter = (Iterator)collection;
            } else if (collection instanceof Collection) {
                newIter = ((Collection)collection).iterator();
            } else if (collection instanceof Map) {
                newIter = ((Map)collection).values().iterator();
            } else {
                throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
            }
            while (newIter.hasNext()) {
                Object newValue = newIter.next();
                Identity newId = molder.getIdentity(tx, newValue);
                if (newId != null && orgSet.contains(newId)) continue;
                added.add(newValue);
            }
        }
        return added;
    }

    public static List<Identity> getRemovedIdsList(TransactionContext tx, List<Identity> orgIds, Object collection, ClassMolder molder) {
        Identity newId;
        if (orgIds == null || orgIds.size() == 0) {
            return new ArrayList<Identity>(0);
        }
        if (collection == null) {
            return orgIds;
        }
        HashSet<Identity> newSet = new HashSet<Identity>();
        if (collection.getClass().isArray()) {
            Object[] newArr = (Object[])collection;
            for (int i = 0; i < newArr.length; ++i) {
                Object newObject = newArr[i];
                Identity newId2 = molder.getIdentity(tx, newObject);
                if (newId2 == null) continue;
                newSet.add(newId2);
            }
        } else if (collection instanceof Enumeration) {
            Enumeration newEnum = (Enumeration)collection;
            while (newEnum.hasMoreElements()) {
                Object newObject = newEnum.nextElement();
                newId = molder.getIdentity(tx, newObject);
                if (newId == null) continue;
                newSet.add(newId);
            }
        } else {
            Collection newCol;
            Iterator<Object> newIter;
            if (collection instanceof Iterator) {
                newIter = (Iterator)collection;
            } else if (collection instanceof Collection) {
                newCol = (Collection)collection;
                newIter = newCol.iterator();
            } else if (collection instanceof Map) {
                newCol = ((Map)collection).values();
                newIter = newCol.iterator();
            } else {
                throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
            }
            while (newIter.hasNext()) {
                Object newObject = newIter.next();
                newId = molder.getIdentity(tx, newObject);
                if (newId == null) continue;
                newSet.add(newId);
            }
        }
        ArrayList<Identity> removedIds = new ArrayList<Identity>();
        for (Identity id : orgIds) {
            if (newSet.contains(id)) continue;
            removedIds.add(id);
        }
        return removedIds;
    }
}

