/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.castor.core.nature.PropertyHolder;
import org.castor.cpa.util.JDOClassDescriptorResolver;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.xml.ClassDescriptorResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMolderRegistry {
    private final HashMap<String, ClassMolder> _classMolders = new HashMap();

    public ClassMolderRegistry(ClassDescriptorResolver cdResolver, PersistenceFactory persistenceFactory, LockEngine engine) throws MappingException {
        try {
            JDOClassDescriptorResolver jdoResolver = (JDOClassDescriptorResolver)cdResolver;
            DatingService ds = new DatingService(jdoResolver.getMappingLoader().getClassLoader());
            Iterator<ClassDescriptor> iter = jdoResolver.descriptorIterator();
            while (iter.hasNext()) {
                ClassDescriptor desc = iter.next();
                if (!desc.hasNature(ClassDescriptorJDONature.class.getName())) {
                    throw new IllegalArgumentException("Class does not have a JDO descriptor");
                }
                if (new ClassDescriptorJDONature((PropertyHolder)desc).hasMappedSuperclass()) continue;
                Persistence persistence = persistenceFactory.getPersistence(desc);
                ClassMolder molder = new ClassMolder(ds, engine, desc, persistence);
                this._classMolders.put(molder.getName(), molder);
            }
            ds.close();
            for (ClassMolder molder : this._classMolders.values()) {
                molder.resetResolvers();
                molder.getPriority();
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Declared Class not found!");
        }
    }

    public ClassMolder getClassMolder(Class<?> cls) {
        return this.getClassMolder(cls.getName());
    }

    public ClassMolder getClassMolder(String classname) {
        ClassMolder molder = this._classMolders.get(classname);
        if (molder != null && !molder.isDependent()) {
            return molder;
        }
        return null;
    }

    public ClassMolder getClassMolderWithDependent(Class<?> cls) {
        return this.getClassMolderWithDependent(cls.getName());
    }

    public ClassMolder getClassMolderWithDependent(String classname) {
        return this._classMolders.get(classname);
    }

    public ClassMolder getClassMolderByQuery(String name) {
        for (ClassMolder molder : this._classMolders.values()) {
            if (molder.getNamedQuery(name) == null) continue;
            return molder;
        }
        return null;
    }

    public ClassMolder getClassMolderByNativeQuery(String name) {
        for (ClassMolder molder : this._classMolders.values()) {
            if (molder.getNamedNativeQuery(name) == null) continue;
            return molder;
        }
        return null;
    }

    HashSet<ClassMolder> getAllClassMolders() {
        HashSet<ClassMolder> molders = new HashSet<ClassMolder>();
        Iterator<ClassMolder> iter = this._classMolders.values().iterator();
        while (iter.hasNext()) {
            molders.add(iter.next());
        }
        return molders;
    }
}

