/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.castor.cpa.persistence.sql.engine.SQLEngine;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.FieldMolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatingService {
    private ClassLoader _loader;
    private Hashtable<String, ClassMolder> _clsMolders;
    private Vector<ClassPair> _needExtendsClassMolder;
    private Vector<ClassPair> _needDependsClassMolder;
    private Vector<FieldPair> _needFieldClass;
    private Hashtable<String, Class<?>> _javaClasses;

    DatingService(ClassLoader loader) {
        this._loader = loader;
    }

    void close() throws MappingException {
        ClassMolder targetCm;
        ClassMolder initiateCm;
        Object pair;
        Enumeration<Object> e;
        if (this._needExtendsClassMolder != null) {
            e = this._needExtendsClassMolder.elements();
            while (e.hasMoreElements()) {
                pair = e.nextElement();
                initiateCm = ((ClassPair)pair).getValue();
                targetCm = this._clsMolders.get(((ClassPair)pair).getKey());
                if (targetCm == null) {
                    throw new MappingException("Extended element, \"" + ((ClassPair)pair).getKey() + "\"  not found!");
                }
                initiateCm.setExtends(targetCm);
                ((SQLEngine)initiateCm.getPersistence()).setExtends((SQLEngine)targetCm.getPersistence());
            }
        }
        if (this._needDependsClassMolder != null) {
            e = this._needDependsClassMolder.elements();
            while (e.hasMoreElements()) {
                pair = (ClassPair)e.nextElement();
                initiateCm = ((ClassPair)pair).getValue();
                targetCm = this._clsMolders.get(((ClassPair)pair).getKey());
                if (targetCm == null) {
                    throw new MappingException("Depended element, \"" + ((ClassPair)pair).getKey() + "\"  not found!");
                }
                initiateCm.setDepends(targetCm);
            }
        }
        if (this._needFieldClass != null) {
            e = this._needFieldClass.elements();
            while (e.hasMoreElements()) {
                pair = (FieldPair)e.nextElement();
                FieldMolder initiateFm = ((FieldPair)pair).getValue();
                targetCm = this._clsMolders.get(((FieldPair)pair).getKey());
                if (targetCm == null) {
                    throw new MappingException("Field element, \"" + ((FieldPair)pair).getKey() + "\"  not found!");
                }
                initiateFm.setFieldClassMolder(targetCm);
            }
        }
    }

    boolean pairExtends(ClassMolder me, String extName) throws MappingException {
        if (extName == null || extName.equals("")) {
            throw new IllegalArgumentException("Null classname not allowed!");
        }
        ClassMolder clsMold = this._clsMolders.get(extName);
        if (clsMold != null) {
            me.setExtends(clsMold);
            SQLEngine sql = (SQLEngine)me.getPersistence();
            if (sql == null) {
                throw new MappingException("Class " + me + " extends on " + extName + " which is not persistence capable!");
            }
            sql.setExtends((SQLEngine)clsMold.getPersistence());
            return true;
        }
        if (this._needExtendsClassMolder == null) {
            this._needExtendsClassMolder = new Vector();
        }
        this._needExtendsClassMolder.add(new ClassPair(extName, me));
        return false;
    }

    boolean pairDepends(ClassMolder me, String depName) {
        if (depName == null || depName.equals("")) {
            return true;
        }
        ClassMolder clsMold = this._clsMolders.get(depName);
        if (clsMold != null) {
            me.setDepends(clsMold);
            return true;
        }
        if (this._needDependsClassMolder == null) {
            this._needDependsClassMolder = new Vector();
        }
        this._needDependsClassMolder.add(new ClassPair(depName, me));
        return false;
    }

    Class<?> resolve(String className) throws ClassNotFoundException {
        if (this._javaClasses == null) {
            this._javaClasses = new Hashtable();
        } else if (this._javaClasses.contains(className)) {
            return this._javaClasses.get(className);
        }
        Class resolved = Types.typeFromName((ClassLoader)this._loader, (String)className);
        this._javaClasses.put(className, resolved);
        return resolved;
    }

    boolean pairFieldClass(FieldMolder fieldMolder, String typeName) throws MappingException {
        try {
            if (typeName == null || typeName.equals("")) {
                return true;
            }
            if (Types.isSimpleType(this.resolve(typeName))) {
                return true;
            }
            if (Types.isEnumType(this.resolve(typeName))) {
                return true;
            }
            if (Types.isConvertibleType(this.resolve(typeName))) {
                return true;
            }
            ClassMolder clsMold = this._clsMolders.get(typeName);
            if (clsMold != null) {
                fieldMolder.setFieldClassMolder(clsMold);
                return true;
            }
            if (this._needFieldClass == null) {
                this._needFieldClass = new Vector();
            }
            this._needFieldClass.add(new FieldPair(typeName, fieldMolder));
            return false;
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("ClassNotFound :\n" + e);
        }
    }

    void register(String name, ClassMolder clsMold) {
        if (this._clsMolders == null) {
            this._clsMolders = new Hashtable();
        }
        this._clsMolders.put(name, clsMold);
    }

    private final class FieldPair {
        private String _key;
        private FieldMolder _value;

        private FieldPair(String key, FieldMolder value) {
            this._key = key;
            this._value = value;
        }

        public String getKey() {
            return this._key;
        }

        public FieldMolder getValue() {
            return this._value;
        }
    }

    private final class ClassPair {
        private String _key;
        private ClassMolder _value;

        private ClassPair(String key, ClassMolder value) {
            this._key = key;
            this._value = value;
        }

        public String getKey() {
            return this._key;
        }

        public ClassMolder getValue() {
            return this._value;
        }
    }
}

