/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.SQLRelationLoader;
import org.castor.jdo.util.ClassLoadingUtils;
import org.castor.persist.CascadingType;
import org.exolab.castor.jdo.DataObjectAccessException;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.types.FieldMappingCollectionType;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.FieldPersistenceType;
import org.exolab.castor.persist.LockEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMolder {
    private static final String COLLECTION_TYPE_ARRAY = "array";
    private static final String COLLECTION_TYPE_COLLECTION = "collection";
    private static final String COLLECTION_TYPE_VECTOR = "vector";
    private static final String COLLECTION_TYPE_ARRAYLIST = "arraylist";
    private static final String COLLECTION_TYPE_HASHTABLE = "hashtable";
    private static final String COLLECTION_TYPE_MAP = "map";
    private static final String COLLECTION_TYPE_SET = "set";
    private static final String COLLECTION_TYPE_HASHMAP = "hashmap";
    private static final String COLLECTION_TYPE_HASHSET = "hashset";
    private static final String COLLECTION_TYPE_SORTED_SET = "sortedset";
    private static final String COLLECTION_TYPE_ITERATOR = "iterator";
    private static final String COLLECTION_TYPE_ENUMERATON = "enumerate";
    private static final String COLLECTION_TYPE_SORTED_MAP = "sortedmap";
    private static Log _log = LogFactory.getFactory().getInstance(FieldMolder.class);
    private static final String METHOD_GET_PREFIX = "get";
    private static final String METHOD_IS_PREFIX = "is";
    private static final String METHOD_SET_PREFIX = "set";
    private static final String METHOD_ADD_PREFIX = "add";
    private static final String METHOD_CREATE_PREFIX = "create";
    private static final String METHOD_DELETE_PREFIX = "delete";
    private static final String METHOD_HAS_PREFIX = "has";
    private boolean _lazy;
    private boolean _check;
    private boolean _store;
    private boolean _multi;
    private boolean _serial;
    private boolean _addable;
    private ClassMolder _enclosingClassMolder;
    private ClassMolder _fieldClassMolder;
    private Class<?> _collectionClass;
    private String _fieldType;
    private String _fieldName;
    private Object _default;
    private boolean _readonly;
    private EnumSet<CascadingType> _cascading;
    private boolean _transient;
    private String _comparator;
    private HashMap<ClassLoader, ReflectService> _reflectServices;
    private ReflectService _defaultReflectService;
    private SQLRelationLoader _manyToManyLoader;
    private static final CollectionInfo[] INFO = new CollectionInfo[]{new CollectionInfo("collection", Collection.class), new CollectionInfo("vector", Vector.class), new CollectionInfo("arraylist", ArrayList.class), new CollectionInfo("hashtable", Hashtable.class), new CollectionInfo("hashmap", HashMap.class), new CollectionInfo("set", Set.class), new CollectionInfo("hashset", HashSet.class), new CollectionInfo("map", Map.class), new CollectionInfo("array", Object[].class), new CollectionInfo("sortedset", SortedSet.class), new CollectionInfo("iterator", Iterator.class), new CollectionInfo("enumerate", Enumeration.class), new CollectionInfo("sortedmap", SortedMap.class)};

    public String toString() {
        return "FieldMolder for " + this._enclosingClassMolder.getName() + "." + this._fieldName + " of type " + this.getFieldTypeName();
    }

    public String getName() {
        return this._fieldName;
    }

    public String getComparator() {
        return this._comparator;
    }

    public FieldPersistenceType getFieldPertsistenceType() {
        if (!this.isPersistanceCapable()) {
            return this.isSerializable() ? FieldPersistenceType.SERIALIZABLE : FieldPersistenceType.PRIMITIVE;
        }
        if (!this.isMulti()) {
            return FieldPersistenceType.PERSISTANCECAPABLE;
        }
        if (!this.isManyToMany()) {
            return FieldPersistenceType.ONE_TO_MANY;
        }
        return FieldPersistenceType.MANY_TO_MANY;
    }

    public SQLRelationLoader getRelationLoader() {
        return this._manyToManyLoader;
    }

    public boolean isStored() {
        return this._fieldClassMolder == null || this._store;
    }

    public boolean isManyToMany() {
        return this._manyToManyLoader != null;
    }

    public boolean isDependent() {
        if (this._fieldClassMolder == null) {
            return false;
        }
        ClassMolder depends = this._fieldClassMolder.getDepends();
        for (ClassMolder extendPath = this._enclosingClassMolder; extendPath != null; extendPath = extendPath.getExtends()) {
            if (extendPath != depends) continue;
            return true;
        }
        return false;
    }

    public boolean isMulti() {
        return this._multi;
    }

    public boolean isPersistanceCapable() {
        return this._fieldClassMolder != null;
    }

    public boolean isSerializable() {
        return this._serial;
    }

    public boolean isCheckDirty() {
        return this._check;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isAddable() {
        return this._addable;
    }

    public boolean isTransient() {
        return this._transient;
    }

    void setFieldClassMolder(ClassMolder fMold) {
        this._fieldClassMolder = fMold;
    }

    public ClassMolder getEnclosingClassMolder() {
        return this._enclosingClassMolder;
    }

    public ClassMolder getFieldClassMolder() {
        return this._fieldClassMolder;
    }

    public LockEngine getFieldLockEngine() {
        return this._fieldClassMolder == null ? null : this._fieldClassMolder.getLockEngine();
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public Class<?> getCollectionType() {
        return this._collectionClass;
    }

    public EnumSet<CascadingType> getCascading() {
        return this._cascading;
    }

    public Object getValue(Object object, ClassLoader loader) {
        Object internalObject = object;
        ReflectService rf = this.getContextReflectService(loader);
        try {
            if (rf.getField() != null) {
                return rf.getField().get(internalObject);
            }
            if (rf.getGetMethod() != null) {
                if (rf._getSequence != null) {
                    for (int i = 0; i < rf._getSequence.length && (internalObject = rf._getSequence[i].invoke(internalObject, (Object[])null)) != null; ++i) {
                    }
                }
                if (internalObject == null || rf._hasMethod != null && !((Boolean)rf._hasMethod.invoke(internalObject, (Object[])null)).booleanValue()) {
                    return null;
                }
                return rf.getGetMethod().invoke(internalObject, (Object[])null);
            }
            return null;
        }
        catch (IllegalAccessException except) {
            throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeNoAccess", (Object)this.toString()), except);
        }
        catch (InvocationTargetException except) {
            throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeInvocation", (Object)this.toString(), (Object)except), except);
        }
    }

    public void addValue(Object object, Object value, ClassLoader loader) {
        ReflectService rf = this.getContextReflectService(loader);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling " + rf.getAddMethod().getName() + " on " + object.getClass().getName() + " with value " + value));
        }
        try {
            if (rf.getAddMethod() == null) {
                throw new DataObjectAccessException(Messages.format((String)"mapping.addMethodNotDefined", (Object)this.getName()));
            }
            if (value == null) {
                throw new NullPointerException("Adding null value is not allowed");
            }
            rf.getAddMethod().invoke(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new DataObjectAccessException("Argument ," + value + ", cannot be added!", e);
        }
        catch (IllegalAccessException e) {
            throw new DataObjectAccessException("Field access error", e);
        }
        catch (InvocationTargetException e) {
            throw new DataObjectAccessException("Field invocation error", e);
        }
    }

    public void setValue(Object object, Object value, ClassLoader loader) {
        block12: {
            Object internalObject = object;
            ReflectService rf = this.getContextReflectService(loader);
            try {
                if (rf.getField() != null) {
                    rf.getField().set(internalObject, value == null ? this._default : value);
                    break block12;
                }
                if (rf.getSetMethod() != null) {
                    if (rf._getSequence != null) {
                        for (int i = 0; i < rf._getSequence.length; ++i) {
                            Object last = internalObject;
                            internalObject = rf._getSequence[i].invoke(internalObject, (Object[])null);
                            if (internalObject != null) continue;
                            if (value == null || rf._setSequence[i] == null) break;
                            internalObject = Types.newInstance(rf._getSequence[i].getReturnType());
                            rf._setSequence[i].invoke(last, internalObject);
                        }
                    }
                    if (internalObject != null) {
                        if (value == null && rf._deleteMethod != null) {
                            rf._deleteMethod.invoke(internalObject, (Object[])null);
                        } else {
                            rf.getSetMethod().invoke(internalObject, value == null ? this._default : value);
                        }
                    }
                    break block12;
                }
                throw new DataObjectAccessException("no method to set value for field: " + this.getFieldTypeName() + " in class: " + this._enclosingClassMolder);
            }
            catch (IllegalArgumentException except) {
                if (value == null) {
                    throw new DataObjectAccessException(Messages.format((String)"mapping.typeConversionNull", (Object)this.toString()));
                }
                throw new DataObjectAccessException(Messages.format((String)"mapping.typeConversion", (Object)this.toString(), (Object)value.getClass().getName()));
            }
            catch (IllegalAccessException except) {
                throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeNoAccess", (Object)this.toString()), except);
            }
            catch (InvocationTargetException except) {
                throw new DataObjectAccessException(Messages.format((String)"mapping.schemaChangeInvocation", (Object)this.toString(), (Object)except.getMessage()), except);
            }
        }
    }

    public boolean isDefault(Object value) {
        if (this._default == value) {
            return true;
        }
        if (this._default == null) {
            return false;
        }
        return this._default.equals(value);
    }

    protected Class<?> getCollectionType(String coll, boolean lazy) {
        for (int i = 0; i < INFO.length; ++i) {
            if (!INFO[i].getName().equals(coll)) continue;
            return INFO[i].getType();
        }
        return null;
    }

    public FieldMolder(DatingService ds, ClassMolder eMold, FieldDescriptor fieldDescriptor, SQLRelationLoader loader) throws MappingException {
        this(ds, eMold, fieldDescriptor);
        this._manyToManyLoader = loader;
    }

    public FieldMolder(DatingService datingService, ClassMolder enclosingClassMolder, FieldDescriptor fieldDescriptor) throws MappingException {
        String fieldName = fieldDescriptor.getFieldName();
        String fieldType = fieldDescriptor.getFieldType().getName();
        try {
            Class<?> enclosingClass;
            this._defaultReflectService = new ReflectService();
            this._reflectServices = new HashMap();
            this._enclosingClassMolder = enclosingClassMolder;
            if ("java.io.Serializable".equals(fieldType)) {
                this._serial = true;
            }
            this._transient = fieldDescriptor.isTransient();
            this.dealWithSqlMapping(fieldDescriptor);
            String comparator = ((FieldDescriptorImpl)fieldDescriptor).getComparator();
            if (comparator != null) {
                this._comparator = comparator;
            }
            this.establishCollectionDefinition(datingService, ((FieldDescriptorImpl)fieldDescriptor).getCollection(), fieldType);
            this.setFieldTypeName(fieldType);
            try {
                enclosingClass = datingService.resolve(enclosingClassMolder.getName());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("mapping.classNotFound", (Object)enclosingClassMolder.getName());
            }
            this._defaultReflectService._loader = enclosingClass.getClassLoader();
            if (null != this._defaultReflectService._loader) {
                this._reflectServices.put(this._defaultReflectService._loader, this._defaultReflectService);
            }
            Class<?> declaredClass = null;
            if (fieldType != null) {
                try {
                    declaredClass = Types.typeFromName((ClassLoader)enclosingClass.getClassLoader(), (String)fieldType);
                    this._defaultReflectService.setFieldType(declaredClass);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException("mapping.classNotFound", (Object)declaredClass);
                }
            }
            if (((FieldDescriptorImpl)fieldDescriptor).isDirect()) {
                this.establishDirectFieldAccess(fieldName, enclosingClass);
            } else {
                String getMethod = ((FieldDescriptorImpl)fieldDescriptor).getGetMethod();
                String setMethod = ((FieldDescriptorImpl)fieldDescriptor).getSetMethod();
                if (getMethod == null && setMethod == null) {
                    Method getMethodTemp;
                    ArrayList<Method> getSeq = new ArrayList<Method>();
                    ArrayList<Method> setSeq = new ArrayList<Method>();
                    String name = fieldName;
                    Method method = null;
                    String methodName = null;
                    try {
                        int point;
                        while ((point = name.indexOf(46)) >= 0) {
                            Class<?> last;
                            block37: {
                                last = enclosingClass;
                                if (fieldType.compareTo("boolean") == 0 || fieldType.compareTo("java.lang.Boolean") == 0) {
                                    try {
                                        methodName = METHOD_IS_PREFIX + this.capitalize(name.substring(0, point));
                                        method = enclosingClass.getMethod(methodName, null);
                                    }
                                    catch (NoSuchMethodException nsme) {
                                        if (!_log.isDebugEnabled()) break block37;
                                        _log.debug((Object)Messages.format((String)"mapping.accessorNotFound", methodName, (Object)"boolean", (Object)this.getName()));
                                    }
                                }
                            }
                            if (method == null) {
                                methodName = METHOD_GET_PREFIX + this.capitalize(name.substring(0, point));
                                method = enclosingClass.getMethod(methodName, null);
                            }
                            name = name.substring(point + 1);
                            if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                                throw new MappingException("mapping.accessorNotAccessible", (Object)methodName, (Object)enclosingClass.getName());
                            }
                            getSeq.add(method);
                            enclosingClass = method.getReturnType();
                            methodName = fieldType.compareTo("boolean") == 0 || fieldType.compareTo("java.lang.Boolean") == 0 ? "set" + methodName.substring(2) : "set" + methodName.substring(3);
                            try {
                                method = last.getMethod(methodName, enclosingClass);
                                if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                                    method = null;
                                }
                            }
                            catch (Exception except) {
                                method = null;
                            }
                            setSeq.add(method);
                            method = null;
                        }
                    }
                    catch (Exception ex) {
                        throw new MappingException(Messages.format((String)"mapping.accessorNotFound", methodName, null, (Object)enclosingClass.getName()), ex);
                    }
                    if (getSeq.size() > 0) {
                        ReflectService.access$202(this._defaultReflectService, getSeq.toArray(new Method[getSeq.size()]));
                        ReflectService.access$602(this._defaultReflectService, setSeq.toArray(new Method[setSeq.size()]));
                    }
                    Class<?> methodClass = this._collectionClass != null ? this._collectionClass : declaredClass;
                    this._defaultReflectService.setGetMethod(null);
                    if (fieldType != null && (fieldType.compareTo("boolean") == 0 || fieldType.compareTo("java.lang.Boolean") == 0)) {
                        this._defaultReflectService.setGetMethod(FieldMolder.findAccessor(enclosingClass, METHOD_IS_PREFIX + this.capitalize(name), methodClass, true));
                    }
                    if (this._defaultReflectService.getGetMethod() == null) {
                        this._defaultReflectService.setGetMethod(FieldMolder.findAccessor(enclosingClass, METHOD_GET_PREFIX + this.capitalize(name), methodClass, true));
                    }
                    if ((getMethodTemp = this._defaultReflectService.getGetMethod()) == null) {
                        if (fieldType.compareTo("boolean") == 0 || fieldType.compareTo("java.lang.Boolean") == 0) {
                            throw new MappingException("mapping.accessorNotFound", (Object)("get/is" + this.capitalize(name)), (Object)fieldType, (Object)enclosingClassMolder.getName());
                        }
                        throw new MappingException("mapping.accessorNotFound", (Object)(METHOD_GET_PREFIX + this.capitalize(name)), (Object)fieldType, (Object)enclosingClassMolder.getName());
                    }
                    if (this._collectionClass == null) {
                        this._defaultReflectService.setFieldType(this._defaultReflectService.getGetMethod().getReturnType());
                    }
                    this._defaultReflectService.setSetMethod(FieldMolder.findAccessor(enclosingClass, "set" + this.capitalize(name), methodClass, false));
                    if (this._defaultReflectService.getSetMethod() == null) {
                        this._defaultReflectService.setAddMethod(FieldMolder.findAccessor(enclosingClass, METHOD_ADD_PREFIX + this.capitalize(name), declaredClass, false));
                        if (this._defaultReflectService.getAddMethod() == null && name.endsWith("s")) {
                            this._defaultReflectService.setAddMethod(FieldMolder.findAccessor(enclosingClass, METHOD_ADD_PREFIX + this.capitalize(name).substring(0, name.length() - 1), declaredClass, false));
                        }
                        if (this._defaultReflectService.getAddMethod() != null) {
                            this._addable = true;
                        }
                    }
                    if (this._defaultReflectService.getSetMethod() == null && this._defaultReflectService.getAddMethod() == null) {
                        throw new MappingException("mapping.accessorNotFound", (Object)("set/add" + this.capitalize(name)), declaredClass, (Object)enclosingClass.getName());
                    }
                } else {
                    Class fieldClassType = this._defaultReflectService.getFieldType();
                    this.establishGetMethod(enclosingClass, getMethod, fieldClassType);
                    this.establishSetAndAddMethod(((FieldDescriptorImpl)fieldDescriptor).isLazy(), enclosingClass, declaredClass, setMethod, fieldClassType);
                }
            }
            this.establishCreateMethod(((FieldDescriptorImpl)fieldDescriptor).getCreateMethod(), fieldName, enclosingClass);
            this.establishHasAndDeleteMethods(fieldName, enclosingClass);
            if (this._defaultReflectService.getField() == null && this._defaultReflectService.getSetMethod() == null && this._defaultReflectService.getGetMethod() == null) {
                throw new MappingException("_field or _setMethod can't be created");
            }
            datingService.pairFieldClass(this, this.getFieldTypeName());
        }
        catch (NullPointerException e) {
            _log.fatal((Object)"Caught unexpected NullPointerException: ", (Throwable)e);
            throw new MappingException("Unexpected Null pointer!\n" + e);
        }
        this._fieldName = fieldName;
        this._default = Types.getDefault((Class)this._defaultReflectService.getFieldType());
        if (!this._defaultReflectService.getFieldType().isPrimitive()) {
            this._default = null;
        }
    }

    private void establishCollectionDefinition(DatingService datingService, FieldMappingCollectionType collectionType, String fieldType) throws MappingException {
        if (collectionType != null) {
            this._multi = true;
            if (COLLECTION_TYPE_ARRAY.equals(collectionType.toString())) {
                String arrayClassName = "[L" + fieldType + ";";
                try {
                    this._collectionClass = datingService.resolve(arrayClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new MappingException("mapping.classNotFound", (Object)arrayClassName);
                }
            } else {
                this._collectionClass = this.getCollectionType(collectionType.toString(), this._lazy);
                if (this._collectionClass != SortedSet.class && this._comparator != null) {
                    throw new MappingException(Messages.message((String)"mapping.wrong.use.of.comparator"));
                }
            }
            this._store = false;
        }
    }

    private void establishDirectFieldAccess(String fieldName, Class<?> enclosingClass) throws MappingException {
        Class<?> fieldClass = this._collectionClass != null ? this._collectionClass : null;
        this._defaultReflectService.setField(this.findField(enclosingClass, fieldName, fieldClass));
        if (this._defaultReflectService.getField() == null) {
            throw new MappingException(Messages.format((String)"mapping.fieldNotAccessible", (Object)fieldName, (Object)enclosingClass.getName()));
        }
        this._defaultReflectService.setFieldType(this._defaultReflectService.getField().getType());
        int modifiers = this._defaultReflectService.getField().getModifiers();
        if (modifiers != 1 && modifiers != 65) {
            throw new MappingException(Messages.format((String)"mapping.fieldNotAccessible", (Object)this._defaultReflectService.getField().getName(), (Object)this._defaultReflectService.getField().getDeclaringClass().getName()));
        }
    }

    private void establishSetAndAddMethod(boolean isLazy, Class<?> enclosingClass, Class<?> declaredClass, String setMethod, Class<?> fieldClassType) throws MappingException {
        if (setMethod != null) {
            if (this._collectionClass != null) {
                this._defaultReflectService.setSetMethod(FieldMolder.findAccessor(enclosingClass, setMethod, this._collectionClass, false));
                if (this._defaultReflectService.getSetMethod() == null && !isLazy) {
                    this._defaultReflectService.setAddMethod(FieldMolder.findAccessor(enclosingClass, setMethod, declaredClass, false));
                    if (this._defaultReflectService.getAddMethod() != null) {
                        this._addable = true;
                    }
                }
            } else {
                this._defaultReflectService.setSetMethod(FieldMolder.findAccessor(enclosingClass, setMethod, fieldClassType, false));
            }
            if (this._defaultReflectService.getSetMethod() == null && this._defaultReflectService.getAddMethod() == null) {
                throw new MappingException("mapping.accessorNotFound", (Object)setMethod, fieldClassType, (Object)enclosingClass.getName());
            }
            if (this._defaultReflectService.getFieldType() == null) {
                this._defaultReflectService.setFieldType(this._defaultReflectService.getSetMethod().getParameterTypes()[0]);
            }
        } else {
            throw new MappingException("mapping.setMethodMappingNotFound", this._collectionClass != null ? this._collectionClass : fieldClassType, (Object)enclosingClass.getName());
        }
    }

    private void establishGetMethod(Class<?> enclosingClass, String getMethod, Class<?> fieldClassType) throws MappingException {
        if (getMethod != null) {
            if (this._collectionClass != null) {
                this._defaultReflectService.setGetMethod(FieldMolder.findAccessor(enclosingClass, getMethod, this._collectionClass, true));
            } else {
                this._defaultReflectService.setGetMethod(FieldMolder.findAccessor(enclosingClass, getMethod, fieldClassType, true));
            }
            if (this._defaultReflectService.getGetMethod() == null) {
                throw new MappingException("mapping.accessorNotFound", (Object)getMethod, fieldClassType, (Object)enclosingClass.getName());
            }
            if (this._collectionClass == null) {
                this._defaultReflectService.setFieldType(this._defaultReflectService.getGetMethod().getReturnType());
            }
        } else {
            throw new MappingException("mapping.getMethodMappingNotFound", this._collectionClass != null ? this._collectionClass : fieldClassType, (Object)enclosingClass.getName());
        }
    }

    private void establishHasAndDeleteMethods(String fieldName, Class<?> javaClass) {
        if (fieldName != null) {
            Method hasMethod = null;
            Method deleteMethod = null;
            try {
                hasMethod = javaClass.getMethod(METHOD_HAS_PREFIX + this.capitalize(fieldName), null);
                if ((hasMethod.getModifiers() & 1) == 0 || (hasMethod.getModifiers() & 8) != 0) {
                    hasMethod = null;
                }
                try {
                    if ((hasMethod.getModifiers() & 1) == 0 || (hasMethod.getModifiers() & 8) != 0) {
                        deleteMethod = null;
                    }
                    deleteMethod = javaClass.getMethod(METHOD_DELETE_PREFIX + this.capitalize(fieldName), null);
                }
                catch (Exception except) {
                    // empty catch block
                }
                this._defaultReflectService._hasMethod = hasMethod;
                this._defaultReflectService._deleteMethod = deleteMethod;
            }
            catch (Exception except) {
                // empty catch block
            }
        }
    }

    private void establishCreateMethod(String createMethod, String fieldName, Class<?> javaClass) throws MappingException {
        if (createMethod != null) {
            try {
                this._defaultReflectService.setCreateMethod(javaClass.getMethod(createMethod, null));
            }
            catch (Exception except) {
                throw new MappingException("mapping.createMethodNotFound", (Object)createMethod, (Object)javaClass.getName());
            }
        }
        if (fieldName != null && !Types.isSimpleType((Class)this._defaultReflectService.getFieldType())) {
            try {
                Method method = javaClass.getMethod(METHOD_CREATE_PREFIX + this.capitalize(fieldName), null);
                this._defaultReflectService.setCreateMethod(method);
            }
            catch (Exception except) {
                // empty catch block
            }
        }
    }

    private void dealWithSqlMapping(FieldDescriptor fieldDescriptor) throws MappingException {
        if (fieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName())) {
            FieldDescriptorJDONature nature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
            if (nature.isDirtyCheck()) {
                this._check = true;
            }
            this._store = nature.getManyTable() != null ? false : nature.getSQLName() != null && nature.getSQLName().length != 0;
            this._readonly = nature.isReadonly();
            this._cascading = EnumSet.noneOf(CascadingType.class);
            if (nature.getCascading() != null) {
                String[] temp = nature.getCascading().toLowerCase().trim().split("\\s+");
                List<String> cascadingTypes = Arrays.asList(temp);
                if (cascadingTypes.contains("all")) {
                    this._cascading = EnumSet.allOf(CascadingType.class);
                } else {
                    if (cascadingTypes.contains(METHOD_CREATE_PREFIX)) {
                        this._cascading.add(CascadingType.CREATE);
                    }
                    if (cascadingTypes.contains(METHOD_DELETE_PREFIX)) {
                        this._cascading.add(CascadingType.DELETE);
                    }
                    if (cascadingTypes.contains("update")) {
                        this._cascading.add(CascadingType.UPDATE);
                    }
                }
            }
            boolean isSQLTransient = nature.isTransient();
            if (this._transient && !isSQLTransient) {
                throw new MappingException(Messages.message((String)"persist.transient.conflict"));
            }
            this._transient = isSQLTransient;
        }
        this._lazy = ((FieldDescriptorImpl)fieldDescriptor).isLazy();
    }

    private Field findField(Class<?> javaClass, String fieldName, Class<?> fieldType) throws MappingException {
        Class internalFieldType = fieldType;
        try {
            Field field = javaClass.getField(fieldName);
            if (field.getModifiers() != 1 && field.getModifiers() != 65) {
                throw new MappingException("mapping.fieldNotAccessible", (Object)fieldName, (Object)javaClass.getName());
            }
            if (internalFieldType == null) {
                internalFieldType = Types.typeFromPrimitive(field.getType());
            } else if (Types.typeFromPrimitive(internalFieldType) != Types.typeFromPrimitive(field.getType())) {
                throw new MappingException("mapping.fieldTypeMismatch", (Object)field, (Object)internalFieldType.getName());
            }
            return field;
        }
        catch (NoSuchFieldException except) {
        }
        catch (SecurityException except) {
            // empty catch block
        }
        return null;
    }

    public static final Method findAccessor(Class<?> javaClass, String methodName, Class<?> fieldType, boolean getMethod) throws MappingException {
        Class internalFieldType = fieldType;
        try {
            Method method = null;
            if (getMethod) {
                method = javaClass.getMethod(methodName, new Class[0]);
                if (javaClass == MapItem.class) {
                    if (methodName.equals("getKey")) {
                        return method;
                    }
                    if (methodName.equals("getValue")) {
                        return method;
                    }
                }
                if (internalFieldType == null) {
                    internalFieldType = Types.typeFromPrimitive(method.getReturnType());
                } else {
                    internalFieldType = Types.typeFromPrimitive(internalFieldType);
                    Class returnType = Types.typeFromPrimitive(method.getReturnType());
                    if (internalFieldType.isInterface() || (internalFieldType.getModifiers() & 0x400) != 0 || internalFieldType == Serializable.class ? !internalFieldType.isAssignableFrom(returnType) : !returnType.isAssignableFrom(internalFieldType)) {
                        throw new MappingException("mapping.accessorReturnTypeMismatch", (Object)method, (Object)internalFieldType.getName());
                    }
                }
            } else {
                Class fieldTypePrimitive = null;
                if (internalFieldType != null) {
                    fieldTypePrimitive = Types.typeFromPrimitive(internalFieldType);
                    try {
                        method = javaClass.getMethod(methodName, fieldTypePrimitive);
                    }
                    catch (Exception ex) {
                        try {
                            method = javaClass.getMethod(methodName, internalFieldType);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                }
                if (method == null) {
                    Method[] methods = javaClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Class<?>[] paramTypes;
                        if (!methods[i].getName().equals(methodName) || (paramTypes = methods[i].getParameterTypes()).length != 1) continue;
                        Class paramType = Types.typeFromPrimitive(paramTypes[0]);
                        if (internalFieldType == null) {
                            method = methods[i];
                            break;
                        }
                        if (paramType.isAssignableFrom(fieldTypePrimitive)) {
                            method = methods[i];
                            break;
                        }
                        if (!internalFieldType.isInterface() && !FieldMolder.isAbstract(internalFieldType) || !fieldTypePrimitive.isAssignableFrom(paramType)) continue;
                        method = methods[i];
                        break;
                    }
                    if (method == null) {
                        return null;
                    }
                }
            }
            if ((method.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", (Object)methodName, (Object)javaClass.getName());
            }
            return method;
        }
        catch (MappingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static boolean isAbstract(Class<?> cls) {
        return (cls.getModifiers() & 0x400) != 0;
    }

    private String capitalize(String name) {
        char first = name.charAt(0);
        if (Character.isUpperCase(first)) {
            return name;
        }
        return Character.toUpperCase(first) + name.substring(1);
    }

    private ReflectService getContextReflectService(ClassLoader loader) {
        if (null == loader || this._defaultReflectService._loader == loader) {
            return this._defaultReflectService;
        }
        ReflectService resultReflectService = this._reflectServices.get(loader);
        if (null == resultReflectService) {
            resultReflectService = new ReflectService(this._defaultReflectService, loader);
        }
        return resultReflectService;
    }

    private void setFieldTypeName(String fieldType) {
        this._fieldType = fieldType;
    }

    private String getFieldTypeName() {
        return this._fieldType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReflectService {
        private ClassLoader _loader;
        private Class<?> _innerFieldType;
        private Field _field;
        private Method[] _getSequence;
        private Method[] _setSequence;
        private Method _getMethod;
        private Method _setMethod;
        private Method _addMethod;
        private Method _hasMethod;
        private Method _deleteMethod;
        private Method _createMethod;

        public ReflectService() {
        }

        public ReflectService(ReflectService refSrv, ClassLoader loader) {
            this._loader = loader;
            this.setFieldType(this.cloneClass(refSrv.getFieldType()));
            this.setField(this.cloneField(refSrv.getField()));
            this._getSequence = this.cloneMethods(refSrv._getSequence);
            this._setSequence = this.cloneMethods(refSrv._setSequence);
            this.setGetMethod(this.cloneMethod(refSrv.getGetMethod()));
            this.setAddMethod(this.cloneMethod(refSrv.getAddMethod()));
            this.setSetMethod(this.cloneMethod(refSrv.getSetMethod()));
            this._hasMethod = this.cloneMethod(refSrv._hasMethod);
            this._deleteMethod = this.cloneMethod(refSrv._deleteMethod);
            this.setCreateMethod(this.cloneMethod(refSrv.getCreateMethod()));
        }

        private Field cloneField(Field originalField) {
            if (null == originalField) {
                return null;
            }
            Field resultField = null;
            try {
                resultField = originalField.getDeclaringClass().getField(originalField.getName());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return resultField;
        }

        private Method cloneMethod(Method originalMethod) {
            if (null == originalMethod) {
                return null;
            }
            Method resultMethod = null;
            try {
                Class<?> newCls = this.loadClass(originalMethod.getDeclaringClass().getName());
                String methodName = originalMethod.getName();
                Class<?>[] methodParams = originalMethod.getParameterTypes();
                for (int i = 0; i < methodParams.length; ++i) {
                    if (methodParams[i].isPrimitive()) continue;
                    methodParams[i] = this.loadClass(methodParams[i].getName());
                }
                resultMethod = newCls.getMethod(methodName, methodParams);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return resultMethod;
        }

        private Method[] cloneMethods(Method[] originalMethods) {
            if (null == originalMethods) {
                return null;
            }
            Method[] resultMethods = new Method[originalMethods.length];
            for (int i = 0; i < originalMethods.length; ++i) {
                resultMethods[i] = this.cloneMethod(originalMethods[i]);
            }
            return resultMethods;
        }

        private Class<?> cloneClass(Class<?> originalClass) {
            if (null == originalClass) {
                return null;
            }
            if (originalClass.isPrimitive()) {
                return originalClass;
            }
            return this.loadClass(originalClass.getName());
        }

        private Class<?> loadClass(String name) {
            Class<?> resultClass = null;
            try {
                resultClass = ClassLoadingUtils.loadClass(this._loader, name);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return resultClass;
        }

        private void setCreateMethod(Method createMethod) {
            this._createMethod = createMethod;
        }

        private Method getCreateMethod() {
            return this._createMethod;
        }

        private void setField(Field field) {
            this._field = field;
        }

        private Field getField() {
            return this._field;
        }

        private void setFieldType(Class<?> fieldType) {
            this._innerFieldType = fieldType;
        }

        private Class<?> getFieldType() {
            return this._innerFieldType;
        }

        private void setGetMethod(Method getMethod) {
            this._getMethod = getMethod;
        }

        private Method getGetMethod() {
            return this._getMethod;
        }

        private void setSetMethod(Method setMethod) {
            this._setMethod = setMethod;
        }

        private Method getSetMethod() {
            return this._setMethod;
        }

        private void setAddMethod(Method addMethod) {
            this._addMethod = addMethod;
        }

        private Method getAddMethod() {
            return this._addMethod;
        }

        static /* synthetic */ Method[] access$202(ReflectService x0, Method[] x1) {
            x0._getSequence = x1;
            return x1;
        }

        static /* synthetic */ Method[] access$602(ReflectService x0, Method[] x1) {
            x0._setSequence = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionInfo {
        private String _name;
        private Class<?> _type;

        public CollectionInfo(String name, Class<?> type) {
            this._name = name;
            this._type = type;
        }

        public String getName() {
            return this._name;
        }

        public Class<?> getType() {
            return this._type;
        }
    }
}

