/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;
import org.castor.cache.CacheFactoryRegistry;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.jdo.engine.DatabaseContext;
import org.castor.persist.AbstractTransactionContext;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.cache.CacheEntry;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderRegistry;
import org.exolab.castor.persist.LockAction;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.TypeInfo;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.xml.ClassDescriptorResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LockEngine {
    private static Log _log = LogFactory.getFactory().getInstance(LockEngine.class);
    private static CacheFactoryRegistry<OID, CacheEntry> _cacheFactoryRegistry;
    private final HashMap<String, TypeInfo> _typeInfos = new HashMap();
    private final HashMap<Xid, TransactionContext> _xaTx = new HashMap();
    private DatabaseContext _databaseContext;
    private PersistenceFactory _persistenceFactory;
    private ClassMolderRegistry _classMolderRegistry;

    public LockEngine(DatabaseContext databaseContext, ClassDescriptorResolver cdResolver, PersistenceFactory persistenceFactory) throws MappingException {
        if (_cacheFactoryRegistry == null) {
            AbstractProperties properties = CPAProperties.getInstance();
            _cacheFactoryRegistry = new CacheFactoryRegistry(properties);
        }
        this._databaseContext = databaseContext;
        this._persistenceFactory = persistenceFactory;
        this._classMolderRegistry = new ClassMolderRegistry(cdResolver, persistenceFactory, this);
        HashSet<ClassMolder> freshClasses = this._classMolderRegistry.getAllClassMolders();
        HashSet<ClassMolder> processedClasses = new HashSet<ClassMolder>();
        int counter = 0;
        do {
            counter = freshClasses.size();
            Iterator<ClassMolder> itor = freshClasses.iterator();
            while (itor.hasNext()) {
                ClassMolder molder = itor.next();
                ClassMolder extend = molder.getExtends();
                if (extend == null) {
                    Cache<OID, CacheEntry> cache = null;
                    try {
                        cache = _cacheFactoryRegistry.getCache(molder.getCacheParams(), cdResolver.getMappingLoader().getClassLoader());
                    }
                    catch (CacheAcquireException e) {
                        String msg = Messages.message((String)"persist.cacheCreationFailed");
                        _log.error((Object)msg, (Throwable)e);
                        throw new MappingException(msg, (Exception)e);
                    }
                    TypeInfo info = new TypeInfo(cache);
                    this._typeInfos.put(molder.getName(), info);
                    itor.remove();
                    processedClasses.add(molder);
                    continue;
                }
                if (!processedClasses.contains(molder.getExtends())) continue;
                TypeInfo baseInfo = this._typeInfos.get(extend.getName());
                this._typeInfos.put(molder.getName(), baseInfo);
                itor.remove();
                processedClasses.add(molder);
            }
        } while (freshClasses.size() > 0 && counter != freshClasses.size());
        if (freshClasses.size() > 0) {
            for (ClassMolder molder : freshClasses) {
                _log.error((Object)("The base class, " + molder.getExtends().getName() + ", of the extends class ," + molder.getName() + " can not be resolved! "));
            }
            throw new MappingException("Some base class can not be resolved!");
        }
    }

    public DatabaseContext getDatabaseContext() {
        return this._databaseContext;
    }

    public ClassMolderRegistry getClassMolderRegistry() {
        return this._classMolderRegistry;
    }

    public Persistence getPersistence(Class<?> cls) {
        ClassMolder molder = this._classMolderRegistry.getClassMolder(cls);
        if (molder != null) {
            return molder.getPersistence();
        }
        return null;
    }

    public void load(AbstractTransactionContext tx, OID oid, ProposedEntity proposedObject, AccessMode suggestedAccessMode, int timeout, QueryResults results, ClassMolder paramMolder, Identity identity) throws PersistenceException {
        TypeInfo typeinfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        if (typeinfo == null || molder == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getTypeName()));
        }
        AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
        LockAction action = LockAction.READ;
        if (accessMode == AccessMode.Exclusive || accessMode == AccessMode.DbLocked) {
            action = LockAction.WRITE;
        }
        boolean succeed = false;
        ObjectLock lock = null;
        try {
            lock = typeinfo.acquire(oid, tx, action, timeout);
            if (lock.getObject() == null || accessMode == AccessMode.DbLocked) {
                molder.load(tx, lock, proposedObject, accessMode, results);
                if (proposedObject.isExpanded()) {
                    lock.getOID().setTypeName(proposedObject.getActualEntityClass().getName());
                }
            } else {
                proposedObject.setExpanded(!oid.getTypeName().equals(lock.getOID().getTypeName()));
            }
            if (proposedObject.isExpanded()) {
                molder = this._classMolderRegistry.getClassMolderWithDependent(lock.getOID().getTypeName());
                proposedObject.setExpanded(false);
            }
            Object objectInTx = proposedObject.getEntity() != null && proposedObject.getEntity().getClass().getName().equals(molder.getName()) ? proposedObject.getEntity() : molder.newInstance(tx);
            proposedObject.setProposedEntityClass(objectInTx.getClass());
            proposedObject.setActualEntityClass(objectInTx.getClass());
            proposedObject.setEntity(objectInTx);
            proposedObject.setActualClassMolder(molder);
            molder.setIdentity(tx, objectInTx, identity);
            proposedObject.setFields(lock.getObject(tx));
            tx.trackObject(molder, lock.getOID(), proposedObject.getEntity());
            try {
                molder.mold(tx, lock, proposedObject, accessMode);
            }
            catch (PersistenceException ex) {
                tx.untrackObject(proposedObject.getEntity());
                throw ex;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format((String)"jdo.loading.with.id", (Object)molder.getName(), (Object)oid.getIdentity()));
            }
            succeed = true;
        }
        catch (ObjectDeletedWaitingForLockException except) {
            throw new ObjectNotFoundException(Messages.format((String)"persist.objectNotFound", (Object)oid.getTypeName(), (Object)oid.getIdentity()), (Throwable)((Object)except));
        }
        catch (LockNotGrantedException e) {
            if (lock != null) {
                lock.release(tx);
            }
            throw e;
        }
        finally {
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
        }
    }

    public void markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        if (typeInfo == null || molder == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getTypeName()));
        }
        molder.markCreate(tx, oid, null, object);
    }

    public OID create(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        OID internaloid = oid;
        TypeInfo typeInfo = this.getTypeInfo(object.getClass());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(object.getClass());
        if (typeInfo == null || molder == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)object.getClass().getName()));
        }
        ObjectLock lock = null;
        if (internaloid.getIdentity() != null) {
            lock = null;
            boolean succeed = false;
            try {
                lock = typeInfo.acquire(internaloid, tx, LockAction.CREATE, 0);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)Messages.format((String)"jdo.creating.with.id", (Object)molder.getName(), (Object)internaloid.getIdentity()));
                }
                internaloid = lock.getOID();
                molder.create(tx, internaloid, lock, object);
                succeed = true;
                internaloid.setDbLock(true);
                OID oID = internaloid;
                return oID;
            }
            catch (LockNotGrantedException except) {
                throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)object.getClass().getName(), (Object)internaloid.getIdentity()), (Throwable)((Object)except));
            }
            catch (DuplicateIdentityException except) {
                throw except;
            }
            finally {
                if (lock != null) {
                    lock.confirm(tx, succeed);
                }
            }
        }
        boolean succeed = false;
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format((String)"jdo.creating.with.id", (Object)molder.getName(), (Object)internaloid.getIdentity()));
            }
            lock = typeInfo.acquire(internaloid, tx, LockAction.CREATE, 0);
            internaloid = lock.getOID();
            Identity newids = molder.create(tx, internaloid, lock, object);
            succeed = true;
            internaloid.setDbLock(true);
            OID newoid = new OID(molder, newids);
            newoid.setDepended(internaloid.getDepended());
            typeInfo.rename(internaloid, newoid, tx);
            OID oID = newoid;
            return oID;
        }
        catch (LockNotGrantedException e) {
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)"Key Generator Failure. Duplicated Identity is generated!"));
        }
        finally {
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        try {
            typeInfo.assure(oid, tx, true);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format((String)"jdo.removing", (Object)molder.getName(), (Object)oid.getIdentity()));
            }
            molder.delete(tx, oid);
        }
        catch (LockNotGrantedException except) {
            throw new IllegalStateException(Messages.format((String)"persist.internal", (Object)"Attempt to delete object for which no lock was acquired"));
        }
    }

    public void markDelete(TransactionContext tx, OID oid, Object object, int timeout) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        ObjectLock lock = typeInfo.upgrade(oid, tx, timeout);
        molder.markDelete(tx, oid, lock, object);
        lock.expire();
    }

    public boolean update(AbstractTransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, int timeout) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        if (typeInfo == null || molder == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getTypeName()));
        }
        boolean succeed = false;
        ObjectLock lock = null;
        OID internaloid = oid;
        try {
            if (!(typeInfo.isLocked(internaloid) || typeInfo.isCached(internaloid) || molder.isDependent() || internaloid.getIdentity() == null)) {
                lock = typeInfo.acquire(internaloid, tx, LockAction.UPDATE, timeout);
                internaloid = lock.getOID();
                try {
                    molder.loadTimeStamp(tx, lock, suggestedAccessMode);
                }
                catch (PersistenceException ex) {}
            } else {
                lock = typeInfo.acquire(internaloid, tx, LockAction.UPDATE, timeout);
                internaloid = lock.getOID();
            }
            succeed = !molder.update(tx, internaloid, lock, object, suggestedAccessMode);
            boolean ex = !succeed;
            return ex;
        }
        catch (ObjectModifiedException e) {
            throw e;
        }
        catch (ObjectDeletedWaitingForLockException except) {
            throw new ObjectNotFoundException(Messages.format((String)"persist.objectNotFound", (Object)internaloid.getTypeName(), (Object)internaloid.getIdentity()), (Throwable)((Object)except));
        }
        finally {
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
        }
    }

    public OID preStore(TransactionContext tx, OID oid, Object object, int timeout) throws PersistenceException {
        boolean modified;
        OID internaloid = oid;
        ObjectLock lock = null;
        TypeInfo typeInfo = this.getTypeInfo(object.getClass());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(object.getClass());
        internaloid = new OID(molder, internaloid.getIdentity());
        try {
            lock = typeInfo.assure(internaloid, tx, false);
            internaloid = lock.getOID();
            modified = molder.preStore(tx, internaloid, lock, object, timeout);
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
        catch (ObjectModifiedException e) {
            lock.invalidate(tx);
            throw e;
        }
        catch (ObjectDeletedException e) {
            lock.delete(tx);
            throw e;
        }
        if (modified) {
            return internaloid;
        }
        return null;
    }

    public void store(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        ObjectLock lock = null;
        try {
            lock = typeInfo.assure(oid, tx, false);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)Messages.format((String)"jdo.storing.with.id", (Object)molder.getName(), (Object)oid.getIdentity()));
            }
            molder.store(tx, oid, lock, object);
        }
        catch (ObjectModifiedException e) {
            lock.invalidate(tx);
            throw e;
        }
        catch (DuplicateIdentityException e) {
            throw e;
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
        catch (PersistenceException e) {
            lock.invalidate(tx);
            throw e;
        }
    }

    public void writeLock(TransactionContext tx, OID oid, int timeout) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        try {
            typeInfo.upgrade(oid, tx, timeout);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ObjectDeletedWaitingForLockException e) {
            throw new IllegalStateException("Object deleted waiting for lock?????????");
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
    }

    public void softLock(TransactionContext tx, OID oid, int timeout) throws LockNotGrantedException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        typeInfo.upgrade(oid, tx, timeout);
    }

    public void revertObject(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        try {
            ObjectLock lock = typeInfo.assure(oid, tx, false);
            molder.revertObject(tx, oid, lock, object);
        }
        catch (LockNotGrantedException e) {
            throw new IllegalStateException("Write Lock expected!");
        }
        catch (PersistenceException except) {
            throw except;
        }
    }

    public void updateCache(TransactionContext tx, OID oid, Object object) {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        ObjectLock lock = typeInfo.assure(oid, tx, true);
        molder.updateCache(tx, oid, lock, object);
    }

    public void releaseLock(TransactionContext tx, OID oid) {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ObjectLock lock = typeInfo.release(oid, tx);
        lock.getOID().setDbLock(false);
    }

    public void forgetObject(TransactionContext tx, OID oid) {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        typeInfo.assure(oid, tx, true);
        typeInfo.delete(oid, tx);
        typeInfo.release(oid, tx);
    }

    public boolean expireCache(TransactionContext tx, OID oid, int timeout) throws PersistenceException {
        TypeInfo typeInfo = this.getTypeInfo(oid.getTypeName());
        ClassMolder molder = this._classMolderRegistry.getClassMolderWithDependent(oid.getTypeName());
        if (typeInfo == null || molder == null) {
            throw new ClassNotPersistenceCapableException(Messages.format((String)"persist.classNotPersistenceCapable", (Object)oid.getTypeName()));
        }
        boolean succeed = false;
        ObjectLock lock = null;
        try {
            if (typeInfo.isCached(oid)) {
                lock = typeInfo.acquire(oid, tx, LockAction.WRITE, timeout);
                molder.expireCache(tx, lock);
                lock.expire();
                succeed = true;
            }
        }
        catch (LockNotGrantedException e) {
            throw e;
        }
        catch (ObjectDeletedException e) {
            throw e;
        }
        catch (PersistenceException e) {
            throw e;
        }
        finally {
            if (lock != null) {
                lock.confirm(tx, succeed);
            }
        }
        return succeed;
    }

    public void expireCache(Class<?> cls) {
        TypeInfo typeInfo = this.getTypeInfo(cls);
        if (typeInfo != null) {
            typeInfo.expireCache();
        }
    }

    public void expireCache() {
        for (TypeInfo typeInfo : this._typeInfos.values()) {
            typeInfo.expireCache();
        }
    }

    public void dumpCache() {
        for (String typeName : this._typeInfos.keySet()) {
            this.getTypeInfo(typeName).dumpCache(typeName);
        }
        for (String name : this._typeInfos.keySet()) {
            this._typeInfos.get(name).dumpCache(name);
        }
    }

    public void closeCaches() {
        for (TypeInfo typeInfo : this._typeInfos.values()) {
            typeInfo.closeCache();
        }
        for (CacheFactory cacheFactory : _cacheFactoryRegistry.getCacheFactories()) {
            cacheFactory.shutdown();
        }
    }

    public void dumpCache(Class<?> cls) {
        TypeInfo typeInfo = this.getTypeInfo(cls);
        if (typeInfo != null) {
            typeInfo.dumpCache(cls.getName());
        }
    }

    public HashMap<Xid, TransactionContext> getXATransactions() {
        return this._xaTx;
    }

    public boolean isCached(Class<?> cls, OID oid) {
        return this.getTypeInfo(cls).isCached(oid);
    }

    public boolean isLocked(Class<?> cls, OID oid) {
        return this.getTypeInfo(cls).isLocked(oid);
    }

    private TypeInfo getTypeInfo(Class<?> type) {
        return this.getTypeInfo(type.getName());
    }

    private TypeInfo getTypeInfo(String typeName) {
        return this._typeInfos.get(typeName);
    }

    public PersistenceFactory getPersistenceFactory() {
        return this._persistenceFactory;
    }
}

