/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.LockAction;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;

public final class ObjectLock
implements DepositBox {
    private static final Log LOG = LogFactory.getFactory().getInstance(ObjectLock.class);
    private static final long ONE_SECOND = 1000L;
    private static AtomicInteger _idcount = new AtomicInteger(0);
    private final int _id;
    private OID _oid;
    private Object[] _object;
    private Object[] _expiredObject;
    private long _version;
    private boolean _deleted;
    private boolean _invalidated;
    private boolean _expired;
    private int _gateCount;
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private final Condition _conditionForLock = this._lock.writeLock().newCondition();
    private TransactionContext _writeTransaction;
    private final Set<TransactionContext> _readTransactions = new HashSet<TransactionContext>();
    private final Set<TransactionContext> _readWaitingTransactions = new HashSet<TransactionContext>();
    private final Set<TransactionContext> _writeWaitingTransactions = new HashSet<TransactionContext>();
    private TransactionContext _confirmWaitingTransaction;
    private LockAction _confirmWaitingAction;

    protected ObjectLock(OID oid) {
        this._oid = oid;
        this._id = _idcount.getAndIncrement();
    }

    protected ObjectLock(OID oid, Object[] object, long version) {
        this(oid);
        this._object = object;
        this._version = version;
    }

    public OID getOID() {
        return this._oid;
    }

    protected void setOID(OID oid) {
        this._oid = oid;
    }

    public Object[] getObject() {
        if (this._expiredObject != null && this._object == null) {
            return this._expiredObject;
        }
        return this._object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getObject(TransactionContext tx) {
        try {
            this._lock.readLock().lock();
            if (!this.hasLock(tx)) {
                throw new IllegalArgumentException("Transaction tx does not own this lock!");
            }
            Object[] objectArray = this._object;
            return objectArray;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(TransactionContext tx, Object[] object, long version) {
        block7: {
            try {
                this._lock.writeLock().lock();
                this._deleted = false;
                this._expired = false;
                this._expiredObject = null;
                if (this._writeTransaction == tx) {
                    this._version = version;
                    this._object = object;
                    break block7;
                }
                if (this._confirmWaitingTransaction == tx) {
                    this._version = version;
                    this._object = object;
                    if (this._confirmWaitingAction == LockAction.READ) {
                        this._readTransactions.add(tx);
                    } else {
                        this._writeTransaction = tx;
                    }
                    this._confirmWaitingTransaction = null;
                    this._conditionForLock.signalAll();
                    break block7;
                }
                throw new IllegalArgumentException("Transaction tx does not own this lock, " + this.toString() + "!");
            }
            finally {
                this._lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVersion() {
        try {
            this._lock.readLock().lock();
            long l = this._version;
            return l;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void setVersion(long version) {
        this._lock.writeLock().lock();
        this._version = version;
        this._lock.writeLock().unlock();
    }

    protected void enter() {
        ++this._gateCount;
    }

    protected void leave() {
        --this._gateCount;
    }

    protected boolean isEntered() {
        return this._gateCount != 0;
    }

    protected void acquireLock(TransactionContext tx, LockAction action, int timeout) throws LockNotGrantedException {
        long endtime = Long.MAX_VALUE;
        if (timeout > 0) {
            endtime = System.currentTimeMillis() + (long)timeout * 1000L;
        }
        try {
            this._lock.writeLock().lock();
            while (true) {
                if (this._deleted && action != LockAction.CREATE) {
                    throw new ObjectDeletedWaitingForLockException("Object deleted");
                }
                if (this._confirmWaitingTransaction != null) {
                    try {
                        this._conditionForLock.await();
                    }
                    catch (InterruptedException e) {
                        throw new LockNotGrantedException("Thread interrupted acquiring lock!", e);
                    }
                }
                if (this._writeTransaction == null && this._readTransactions.isEmpty()) {
                    if (this._object != null && action == LockAction.READ) {
                        this._readTransactions.add(tx);
                    } else {
                        this._confirmWaitingTransaction = tx;
                        this._confirmWaitingAction = action;
                    }
                    return;
                }
                if (action == LockAction.CREATE) {
                    throw new LockNotGrantedException("Lock already exist!");
                }
                if (this._writeTransaction == tx) {
                    return;
                }
                if (!this._readTransactions.isEmpty() && action == LockAction.READ) {
                    if (!this._readTransactions.contains(tx)) {
                        this._readTransactions.add(tx);
                    }
                    return;
                }
                this.waitingForLock(tx, action != LockAction.READ, endtime);
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitingForLock(TransactionContext tx, boolean write, long endtime) throws LockNotGrantedException {
        if (System.currentTimeMillis() > endtime) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Timeout on " + this.toString() + " by " + tx));
            }
            throw new LockNotGrantedException((write ? "persist.writeLockTimeout" : "persist.readLockTimeout") + this._oid + "/" + this._id + " by " + tx);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Waiting on " + this.toString() + " by " + tx));
        }
        try {
            tx.setWaitOnLock(this);
            this.detectDeadlock(tx, 10);
            if (write) {
                this._writeWaitingTransactions.add(tx);
            } else {
                this._readWaitingTransactions.add(tx);
            }
            try {
                long waittime = endtime - System.currentTimeMillis();
                this._conditionForLock.await(waittime < 0L ? 0L : waittime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException except) {
                throw new LockNotGrantedException((write ? "persist.writeLockTimeout" : "persist.readLockTimeout") + this._oid + "/" + this._id + " by " + tx, except);
            }
            if (this._deleted) {
                throw new ObjectDeletedWaitingForLockException("object deleted" + this._oid + "/" + this._id + " by " + tx);
            }
        }
        finally {
            this.removeWaiting(tx);
            tx.setWaitOnLock(null);
        }
    }

    private void removeWaiting(TransactionContext tx) {
        try {
            this._writeWaitingTransactions.remove(tx);
            this._readWaitingTransactions.remove(tx);
        }
        catch (ThreadDeath death) {
            this.removeWaiting(tx);
            throw death;
        }
    }

    private void detectDeadlock(TransactionContext waitingTx, int numOfRec) throws LockNotGrantedException {
        if (numOfRec <= 0) {
            return;
        }
        if (this._writeTransaction != null) {
            ObjectLock waitOn = this._writeTransaction.getWaitOnLock();
            if (waitOn != null) {
                if (waitOn._writeTransaction == waitingTx) {
                    throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                }
                if (waitOn._readTransactions.contains(waitingTx)) {
                    throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                }
                waitOn.detectDeadlock(waitingTx, numOfRec - 1);
            }
        } else {
            for (TransactionContext tx : this._readTransactions) {
                ObjectLock waitOn = tx.getWaitOnLock();
                if (waitOn == null || tx == waitingTx) continue;
                if (waitOn._writeTransaction == waitingTx) {
                    throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                }
                if (waitOn._readTransactions.contains(waitingTx)) {
                    throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                }
                waitOn.detectDeadlock(waitingTx, numOfRec - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirm(TransactionContext tx, boolean succeed) {
        block11: {
            try {
                this._lock.writeLock().lock();
                if (this._confirmWaitingTransaction == tx) {
                    if (succeed) {
                        if (this._confirmWaitingAction == LockAction.READ) {
                            this._readTransactions.add(tx);
                        } else {
                            this._writeTransaction = tx;
                        }
                    }
                    this._confirmWaitingTransaction = null;
                    this._conditionForLock.signalAll();
                    break block11;
                }
                if (this._confirmWaitingTransaction == null) {
                    if (!succeed) {
                        if (this._writeTransaction != null) {
                            this._object = null;
                            this._version = System.currentTimeMillis();
                        } else {
                            this._readTransactions.remove(tx);
                        }
                    }
                    this._conditionForLock.signalAll();
                    break block11;
                }
                throw new IllegalStateException("Confirm transaction does not match the locked transaction");
            }
            finally {
                this._lock.writeLock().unlock();
            }
        }
    }

    protected void upgrade(TransactionContext tx, int timeout) throws LockNotGrantedException {
        try {
            long endtime;
            this._lock.writeLock().lock();
            if (this._confirmWaitingTransaction != null) {
                throw new IllegalStateException("Internal error: acquire when confirmWaiting is not null");
            }
            if (!this.hasLock(tx)) {
                throw new IllegalStateException("Transaction didn't previously acquire this lock");
            }
            long l = endtime = timeout > 0 ? System.currentTimeMillis() + (long)timeout * 1000L : Long.MAX_VALUE;
            while (true) {
                if (this._writeTransaction == tx) {
                    return;
                }
                if (this._writeTransaction == null && this._readTransactions.contains(tx) && this._readTransactions.size() == 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Acquired on " + this.toString() + " by " + tx));
                    }
                    this._writeTransaction = tx;
                    this._readTransactions.clear();
                    return;
                }
                this.waitingForLock(tx, true, endtime);
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void release(TransactionContext tx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Release " + this.toString() + " by " + tx));
        }
        try {
            this._lock.writeLock().lock();
            tx.setWaitOnLock(null);
            if (this._writeTransaction == tx) {
                this._writeTransaction = null;
                if (this._invalidated || this._deleted) {
                    this._version = System.currentTimeMillis();
                    if (this._expired) {
                        this._expiredObject = this._object;
                    }
                    this._object = null;
                }
                this._invalidated = false;
            } else if (!this._readTransactions.remove(tx)) {
                throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + this._oid + "/" + this._id + " by " + tx);
            }
            this._conditionForLock.signalAll();
        }
        catch (ThreadDeath death) {
            this.release(tx);
            throw death;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(TransactionContext tx) {
        try {
            this._lock.writeLock().lock();
            if (this._writeTransaction != tx) {
                throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + " oid:" + this._oid + "/" + this._id + " by " + tx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Delete " + this.toString() + " by " + tx));
            }
            this._deleted = true;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(TransactionContext tx) {
        try {
            this._lock.writeLock().lock();
            if (this._writeTransaction != tx) {
                throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + " oid:" + this._oid + "/" + this._id + " by " + tx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Invalidate " + this.toString() + " by " + tx));
            }
            this._invalidated = true;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void expire() {
        this._expired = true;
    }

    protected void expired() {
        this._expired = false;
        this._expiredObject = null;
    }

    protected boolean isExpired() {
        return this._expired;
    }

    protected boolean isDisposable() {
        return !this.isEntered() && this.isFree();
    }

    private boolean isFree() {
        return this._writeTransaction == null && this._readTransactions.isEmpty() && this._writeWaitingTransactions.isEmpty() && this._readWaitingTransactions.isEmpty() && this._confirmWaitingTransaction == null && !this.hasWaiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasWaiter() {
        try {
            this._lock.writeLock().lock();
            boolean bl = this._lock.hasWaiters(this._conditionForLock);
            return bl;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected boolean hasLock(TransactionContext tx) {
        if (this._writeTransaction == tx) {
            return true;
        }
        if (this._confirmWaitingTransaction == tx) {
            return true;
        }
        return this._readTransactions.contains(tx);
    }

    protected boolean hasWriteLock(TransactionContext tx) {
        if (this._writeTransaction == tx) {
            return true;
        }
        return this._confirmWaitingTransaction == tx && (this._confirmWaitingAction == LockAction.WRITE || this._confirmWaitingAction == LockAction.CREATE);
    }

    protected boolean isExclusivelyOwned(TransactionContext tx) {
        if (this._writeTransaction == tx) {
            return true;
        }
        return this._readTransactions.contains(tx) && this._readTransactions.size() == 1;
    }

    public String toString() {
        return this._oid.toString() + "/" + this._id + " " + (this._readTransactions.isEmpty() ? "-" : "R") + "/" + (this._writeTransaction == null ? "-" : "W");
    }
}

