/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.persist.TransactionContext;
import org.castor.persist.cache.CacheEntry;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.persist.LockAction;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeInfo {
    private static Log _log = LogFactory.getFactory().getInstance(TypeInfo.class);
    private final Map<OID, ObjectLock> _locks = new HashMap<OID, ObjectLock>();
    private final Cache<OID, CacheEntry> _cache;

    public TypeInfo(Cache<OID, CacheEntry> cache) {
        this._cache = cache;
    }

    public void closeCache() {
        this._cache.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCache(String name) {
        _log.info((Object)(name + ".dumpCache()..."));
        Map<OID, ObjectLock> map = this._locks;
        synchronized (map) {
            for (OID entry : this._locks.keySet()) {
                _log.info((Object)("In locks: " + entry));
            }
            for (OID entry : this._cache.keySet()) {
                _log.info((Object)("In cache: " + entry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireCache() {
        Map<OID, ObjectLock> map = this._locks;
        synchronized (map) {
            Iterator<ObjectLock> iter = this._locks.values().iterator();
            while (iter.hasNext()) {
                ObjectLock objectLock = iter.next();
                objectLock.expire();
                iter.remove();
            }
            this._cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock acquire(OID oid, TransactionContext tx, LockAction lockAction, int timeout) throws LockNotGrantedException {
        Map<OID, ObjectLock> map;
        ObjectLock objectLock;
        ObjectLock entry = null;
        Map<OID, ObjectLock> map2 = this._locks;
        synchronized (map2) {
            entry = this._locks.get(oid);
            if (entry == null) {
                CacheEntry cachedEntry = (CacheEntry)this._cache.remove(oid);
                entry = cachedEntry != null ? new ObjectLock(cachedEntry.getOID(), cachedEntry.getValues(), cachedEntry.getVersion()) : new ObjectLock(oid);
                this._locks.put(entry.getOID(), entry);
            }
            entry.enter();
        }
        boolean failed = true;
        try {
            entry.acquireLock(tx, lockAction, timeout);
            failed = false;
            objectLock = entry;
            Object var10_10 = null;
            map = this._locks;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Map<OID, ObjectLock> map3 = this._locks;
            synchronized (map3) {
                entry.leave();
                if (failed && entry.isDisposable()) {
                    this._locks.remove(entry.getOID());
                    if (entry.isExpired()) {
                        this._cache.expire(entry.getOID());
                        entry.expired();
                    } else {
                        this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getVersion()));
                    }
                }
            }
            throw throwable;
        }
        synchronized (map) {
            entry.leave();
            if (failed && entry.isDisposable()) {
                this._locks.remove(entry.getOID());
                if (entry.isExpired()) {
                    this._cache.expire(entry.getOID());
                    entry.expired();
                } else {
                    this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getVersion()));
                }
            }
        }
        return objectLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock upgrade(OID oid, TransactionContext tx, int timeout) throws LockNotGrantedException {
        Map<OID, ObjectLock> map;
        OID internaloid = oid;
        ObjectLock entry = null;
        Object object = this._locks;
        synchronized (object) {
            entry = this._locks.get(internaloid);
            if (entry == null) {
                throw new ObjectDeletedWaitingForLockException("Lock entry not found. Deleted?");
            }
            if (!entry.hasLock(tx)) {
                throw new IllegalStateException("Transaction does not hold the any lock on " + internaloid + "!");
            }
            internaloid = entry.getOID();
            entry.enter();
        }
        try {
            entry.upgrade(tx, timeout);
            object = entry;
            Object var9_8 = null;
            map = this._locks;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            Map<OID, ObjectLock> map2 = this._locks;
            synchronized (map2) {
                entry.leave();
            }
            throw throwable;
        }
        synchronized (map) {
            entry.leave();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock assure(OID oid, TransactionContext tx, boolean write) {
        Map<OID, ObjectLock> map = this._locks;
        synchronized (map) {
            ObjectLock entry = this._locks.get(oid);
            if (entry == null) {
                throw new IllegalStateException("Lock, " + oid + ", doesn't exist or no lock!");
            }
            if (write) {
                if (!entry.hasWriteLock(tx)) {
                    throw new IllegalStateException("Transaction " + tx + " does not hold the write lock: " + entry + "!");
                }
            } else if (!entry.hasLock(tx)) {
                throw new IllegalStateException("Transaction " + tx + " does not hold the read lock: " + entry + "!");
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock rename(OID orgoid, OID newoid, TransactionContext tx) throws LockNotGrantedException {
        Map<OID, ObjectLock> map = this._locks;
        synchronized (map) {
            ObjectLock entry = this._locks.get(orgoid);
            ObjectLock newentry = this._locks.get(newoid);
            if (orgoid == newoid) {
                throw new LockNotGrantedException("Locks are the same");
            }
            if (entry == null) {
                throw new LockNotGrantedException("Lock doesn't exist!");
            }
            if (!entry.isExclusivelyOwned(tx)) {
                throw new LockNotGrantedException("Lock to be renamed is not own exclusively by transaction!");
            }
            if (entry.isEntered()) {
                throw new LockNotGrantedException("Lock to be renamed is acquired by another transaction!");
            }
            if (newentry != null) {
                throw new LockNotGrantedException("Lock is already existed for the new oid.");
            }
            entry = this._locks.remove(orgoid);
            entry.setOID(newoid);
            this._locks.put(newoid, entry);
            newoid.setDbLock(orgoid.isDbLock());
            return newentry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock delete(OID oid, TransactionContext tx) {
        Map<OID, ObjectLock> map;
        ObjectLock entry;
        Object object = this._locks;
        synchronized (object) {
            entry = this._locks.get(oid);
            if (entry == null) {
                throw new IllegalStateException("No lock to destroy!");
            }
            entry.enter();
        }
        try {
            entry.delete(tx);
            object = entry;
            Object var7_6 = null;
            map = this._locks;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Map<OID, ObjectLock> map2 = this._locks;
            synchronized (map2) {
                entry.leave();
                if (entry.isDisposable()) {
                    this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getVersion()));
                    this._locks.remove(oid);
                }
            }
            throw throwable;
        }
        synchronized (map) {
            entry.leave();
            if (entry.isDisposable()) {
                this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getVersion()));
                this._locks.remove(oid);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock release(OID oid, TransactionContext tx) {
        Map<OID, ObjectLock> map;
        ObjectLock entry = null;
        Object object = this._locks;
        synchronized (object) {
            entry = this._locks.get(oid);
            if (entry == null) {
                throw new IllegalStateException("No lock to release! " + oid + " for transaction " + tx);
            }
            entry.enter();
        }
        try {
            entry.release(tx);
            object = entry;
            Object var7_6 = null;
            map = this._locks;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Map<OID, ObjectLock> map2 = this._locks;
            synchronized (map2) {
                entry.leave();
                if (entry.isDisposable()) {
                    this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getVersion()));
                    if (entry.isExpired()) {
                        this._cache.expire(oid);
                        entry.expired();
                    }
                    this._locks.remove(oid);
                }
            }
            throw throwable;
        }
        synchronized (map) {
            entry.leave();
            if (entry.isDisposable()) {
                this._cache.put(oid, new CacheEntry(entry.getOID(), entry.getObject(), entry.getVersion()));
                if (entry.isExpired()) {
                    this._cache.expire(oid);
                    entry.expired();
                }
                this._locks.remove(oid);
            }
        }
        return object;
    }

    public boolean isCached(OID oid) {
        return this._cache.containsKey(oid);
    }

    public boolean isLocked(OID oid) {
        return this._locks.containsKey(oid);
    }
}

