/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.distributed.AbstractDistributedCache;

public final class FKCache
extends AbstractDistributedCache {
    private static final Log LOG = LogFactory.getLog(FKCache.class);
    public static final String TYPE = "fkcache";
    public static final String IMPLEMENTATION = "javax.util.jcache.CacheAccessFactory";

    public void initialize(Properties params) throws CacheAcquireException {
        this.initialize(IMPLEMENTATION, params);
    }

    public void initialize(String implementation, Properties params) throws CacheAcquireException {
        super.initialize(params);
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            Object factory = this.invokeStaticMethod(cls, "getInstance", null, null);
            this.setCache((Map)this.invokeMethod(factory, "getMapAccess", null, null));
        }
        catch (Exception e) {
            String msg = "Error creating FKCache cache: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
    }

    public String getType() {
        return TYPE;
    }
}

