/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.convertor;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.castor.cpa.persistence.convertor.AbstractDateTypeConvertor;

public final class SqlTimestampToString
extends AbstractDateTypeConvertor {
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final long MILLION = 1000000L;
    private SimpleDateFormat _customDateFormat;

    public SqlTimestampToString() {
        super(Timestamp.class, String.class);
        this.parameterize(null);
    }

    public void parameterize(String parameter) {
        this._customDateFormat = SqlTimestampToString.getDefaultDateFormat();
        if (parameter == null || parameter.length() == 0) {
            this._customDateFormat.applyPattern(TIMESTAMP_PATTERN);
        } else {
            this._customDateFormat.applyPattern(parameter);
        }
    }

    private SimpleDateFormat getCustomDateFormat() {
        return (SimpleDateFormat)this._customDateFormat.clone();
    }

    public Object convert(Object object) {
        Timestamp timestamp = (Timestamp)object;
        long date = timestamp.getTime() + (long)timestamp.getNanos() / 1000000L;
        return this.getCustomDateFormat().format(new Date(date));
    }
}

