/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.convertor;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.castor.cpa.persistence.convertor.AbstractDateTypeConvertor;

public final class StringToSqlTimestamp
extends AbstractDateTypeConvertor {
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final long THOUSAND = 1000L;
    private static final long MILLION = 1000000L;
    private SimpleDateFormat _customDateFormat;

    public StringToSqlTimestamp() {
        super(String.class, Timestamp.class);
        this.parameterize(null);
    }

    public void parameterize(String parameter) {
        this._customDateFormat = StringToSqlTimestamp.getDefaultDateFormat();
        if (parameter == null || parameter.length() == 0) {
            this._customDateFormat.applyPattern(TIMESTAMP_PATTERN);
        } else {
            this._customDateFormat.applyPattern(parameter);
        }
    }

    private SimpleDateFormat getCustomDateFormat() {
        return (SimpleDateFormat)this._customDateFormat.clone();
    }

    public Object convert(Object object) {
        long time;
        try {
            time = this.getCustomDateFormat().parse((String)object).getTime();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        Timestamp timestamp = new Timestamp(time);
        timestamp.setNanos((int)(time % 1000L * 1000000L));
        return timestamp;
    }
}

