/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class MaxKeyGenerator
implements KeyGenerator {
    private static final Log LOG = LogFactory.getLog(MaxKeyGenerator.class);
    private final PersistenceFactory _factory;
    private MaxSqlTypeHandler _sqlTypeHandler;

    public MaxKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        this._factory = factory;
        this.supportsSqlType(sqlType);
        this.initSqlTypeHandler(sqlType);
    }

    private void initSqlTypeHandler(int sqlType) {
        this._sqlTypeHandler = sqlType == 4 ? new MaxIntegerSqlTypeHandler() : (sqlType == -5 ? new MaxLongSqlTypeHandler() : new MaxBigDecimalSqlTypeHandler());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Object object;
        PreparedStatement stmt = null;
        try {
            try {
                String sql = this.getQueryExpression(tableName, primKeyName);
                stmt = conn.prepareStatement(sql);
                ResultSet rs = stmt.executeQuery();
                object = this._sqlTypeHandler.getValue(rs);
                Object var10_10 = null;
                if (stmt == null) return object;
            }
            catch (SQLException ex) {
                throw new PersistenceException(Messages.format((String)"persist.keyGenSQL", (Object)this.getClass().getName(), (Object)ex.toString()), ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException ex2) {
                LOG.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)ex2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException ex2) {
            LOG.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)ex2);
            return object;
        }
        stmt.close();
        return object;
    }

    private String getQueryExpression(String table, String column) throws QueryException {
        QueryExpression query = this._factory.getQueryExpression();
        query.addColumn(table, column);
        query.addCondition(table, column, "=", "(SELECT MAX(t1." + this._factory.quoteName(column) + ") FROM " + this._factory.quoteName(table) + " t1)");
        return query.getStatement(true);
    }

    public void supportsSqlType(int sqlType) throws MappingException {
        if (sqlType != 4 && sqlType != -5 && sqlType != 2 && sqlType != 3) {
            throw new MappingException(Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType)));
        }
    }

    public byte getStyle() {
        return -1;
    }

    public boolean isInSameConnection() {
        return true;
    }

    public String patchSQL(String insert, String primKeyName) {
        return insert;
    }

    private static class MaxBigDecimalSqlTypeHandler
    implements MaxSqlTypeHandler {
        private static final BigDecimal ONE = new BigDecimal(1);

        private MaxBigDecimalSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return ONE;
            }
            BigDecimal max = rs.getBigDecimal(1);
            if (max == null) {
                return ONE;
            }
            return max.add(ONE);
        }
    }

    private static class MaxLongSqlTypeHandler
    implements MaxSqlTypeHandler {
        private static final Long ONE = new Long(1L);

        private MaxLongSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return ONE;
            }
            return new Long(rs.getLong(1) + 1L);
        }
    }

    private static class MaxIntegerSqlTypeHandler
    implements MaxSqlTypeHandler {
        private static final Integer ONE = new Integer(1);

        private MaxIntegerSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return ONE;
            }
            return new Integer(rs.getInt(1) + 1);
        }
    }

    private static interface MaxSqlTypeHandler {
        public Object getValue(ResultSet var1) throws SQLException;
    }
}

