/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.util.Enumeration;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.conf.Mapping;
import org.castor.jdo.engine.ConnectionFactory;
import org.castor.jdo.util.JDOConfAdapter;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerRegistry;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceEngineFactory;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.util.JDOClassDescriptorResolver;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    public static final String GENERIC_ENGINE = "generic";
    private static final Log LOG = LogFactory.getLog(AbstractConnectionFactory.class);
    private boolean _initialized = false;
    private JdoConf _jdoConf;
    private int _index;
    private String _name;
    private org.exolab.castor.mapping.Mapping _mapping;
    private TransactionManager _txManager;
    private LockEngine _engine = null;
    private JDOClassDescriptorResolver _classDescriptorResolver = null;

    protected AbstractConnectionFactory(String name, String engine, org.exolab.castor.mapping.Mapping mapping, TransactionManager txManager) throws MappingException {
        this._jdoConf = null;
        this._index = -1;
        this._name = name;
        this._mapping = mapping;
        this._txManager = txManager;
        this.initializeEngine(engine);
        this._initialized = true;
    }

    protected AbstractConnectionFactory(JdoConf jdoConf, int index, org.exolab.castor.mapping.Mapping mapping) {
        this._jdoConf = jdoConf;
        this._index = index;
        this._name = jdoConf.getDatabase(index).getName();
        this._mapping = mapping;
        this._txManager = null;
    }

    public final void initialize() throws MappingException {
        if (!this._initialized) {
            this.initializeMapping();
            JDOConfAdapter adapt = new JDOConfAdapter(this._jdoConf);
            String name = adapt.getName();
            String txm = adapt.getTransactionManager();
            Properties prop = adapt.getTransactionManagerParameters();
            AbstractProperties properties = CPAProperties.getInstance();
            TransactionManagerRegistry txr = new TransactionManagerRegistry(properties);
            try {
                txr.registerTransactionManager(name, txm, prop);
                this._txManager = txr.getTransactionManager(name);
            }
            catch (TransactionManagerAcquireException ex) {
                throw new MappingException((Exception)ex);
            }
            this.initializeEngine(this._jdoConf.getDatabase(this._index).getEngine());
            this.initializeFactory();
            this._initialized = true;
        }
    }

    private void initializeMapping() throws MappingException {
        try {
            Enumeration<? extends Mapping> mappings = this._jdoConf.getDatabase(this._index).enumerateMapping();
            while (mappings.hasMoreElements()) {
                Mapping mapConf = mappings.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading the mapping descriptor: " + mapConf.getHref()));
                }
                if (mapConf.getHref() == null) continue;
                this._mapping.loadMapping(mapConf.getHref());
            }
        }
        catch (MappingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappingException(ex);
        }
    }

    private void initializeEngine(String engine) throws MappingException {
        PersistenceFactory factory = engine == null ? PersistenceFactoryRegistry.getPersistenceFactory(GENERIC_ENGINE) : PersistenceFactoryRegistry.getPersistenceFactory(engine);
        if (factory == null) {
            String msg = Messages.format((String)"jdo.noSuchEngine", (Object)engine);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
        if (this._classDescriptorResolver == null) {
            this._classDescriptorResolver = (JDOClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver((BindingType)BindingType.JDO);
        }
        MappingLoader mappingLoader = mappingUnmarshaller.getMappingLoader(this._mapping, BindingType.JDO, (Object)factory);
        this._classDescriptorResolver.setMappingLoader(mappingLoader);
        this._engine = new PersistenceEngineFactory().createEngine(this, (ClassDescriptorResolver)this._classDescriptorResolver, factory);
    }

    public abstract void initializeFactory() throws MappingException;

    public final String getName() {
        return this._name;
    }

    public final Database getDatabase() {
        return this._jdoConf.getDatabase(this._index);
    }

    public final org.exolab.castor.mapping.Mapping getMapping() {
        return this._mapping;
    }

    public final TransactionManager getTransactionManager() {
        return this._txManager;
    }

    public final LockEngine getEngine() {
        return this._engine;
    }

    public void setClassDescriptorResolver(JDOClassDescriptorResolver classDescriptorResolver) {
        this._classDescriptorResolver = classDescriptorResolver;
    }
}

