/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.util.Hashtable;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DataSourceConnectionFactory;
import org.castor.jdo.engine.DriverConnectionFactory;
import org.castor.jdo.engine.JNDIConnectionFactory;
import org.castor.jdo.util.JDOConfFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.util.JDOClassDescriptorResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DatabaseRegistry {
    private static final Log LOG = LogFactory.getLog(DatabaseRegistry.class);
    private static final Hashtable FACTORIES = new Hashtable();

    public static synchronized void loadDatabase(String name, String engine, DataSource datasource, Mapping mapping, TransactionManager txManager) throws MappingException {
        DataSourceConnectionFactory factory = new DataSourceConnectionFactory(name, engine, datasource, mapping, txManager);
        if (FACTORIES.put(name, factory) != null) {
            LOG.warn((Object)Messages.format((String)"jdo.configLoadedTwice", (Object)name));
        }
    }

    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        DatabaseRegistry.loadDatabase(source, resolver, loader, null);
    }

    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader, JDOClassDescriptorResolver classDescriptorResolver) throws MappingException {
        JdoConf jdoConf = null;
        jdoConf = JDOConfFactory.createJdoConf(source, resolver, loader);
        LOG.debug((Object)"Loaded jdo conf successfully");
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, source.getSystemId(), classDescriptorResolver);
    }

    public static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader, String baseURI) throws MappingException {
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, baseURI, null);
    }

    public static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader, String baseURI, JDOClassDescriptorResolver classDescriptorResolver) throws MappingException {
        AbstractProperties properties = CPAProperties.getInstance();
        boolean init = properties.getBoolean("org.exolab.castor.jdo.DatabaseInitializeAtLoad", true);
        Database[] databases = jdoConf.getDatabase();
        for (int i = 0; i < databases.length; ++i) {
            String name;
            Mapping mapping = new Mapping(loader);
            if (resolver != null) {
                mapping.setEntityResolver(resolver);
            }
            if (baseURI != null) {
                mapping.setBaseURL(baseURI);
            }
            AbstractConnectionFactory factory = DatabaseRegistry.createFactory(jdoConf, i, mapping);
            factory.setClassDescriptorResolver(classDescriptorResolver);
            if (init) {
                factory.initialize();
            }
            if (FACTORIES.put(name = databases[i].getName(), factory) == null) continue;
            LOG.warn((Object)Messages.format((String)"jdo.configLoadedTwice", (Object)name));
        }
    }

    private static AbstractConnectionFactory createFactory(JdoConf jdoConf, int index, Mapping mapping) throws MappingException {
        AbstractConnectionFactory factory;
        DatabaseChoice choice = jdoConf.getDatabase(index).getDatabaseChoice();
        if (choice == null) {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format((String)"jdo.missingDataSource", (Object)name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        if (choice.getDriver() != null) {
            factory = new DriverConnectionFactory(jdoConf, index, mapping);
        } else if (choice.getDataSource() != null) {
            factory = new DataSourceConnectionFactory(jdoConf, index, mapping);
        } else if (choice.getJndi() != null) {
            factory = new JNDIConnectionFactory(jdoConf, index, mapping);
        } else {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format((String)"jdo.missingDataSource", (Object)name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        return factory;
    }

    public static boolean hasDatabaseRegistries() {
        return !FACTORIES.isEmpty();
    }

    public static boolean isDatabaseRegistred(String name) {
        return FACTORIES.containsKey(name);
    }

    public static AbstractConnectionFactory getConnectionFactory(String name) throws MappingException {
        AbstractConnectionFactory factory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching ConnectionFactory: " + name));
        }
        if ((factory = (AbstractConnectionFactory)FACTORIES.get(name)) == null) {
            String msg = Messages.format((String)"jdo.missingDataSource", (Object)name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        factory.initialize();
        return factory;
    }

    public static void clear() {
        FACTORIES.clear();
    }

    public static void unloadDatabase(String name) {
        FACTORIES.remove(name);
    }

    private DatabaseRegistry() {
    }
}

