/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.cpa.CPAProperties;
import org.exolab.castor.mapping.MappingException;

public final class SQLTypeInfos {
    private static final Log LOG = LogFactory.getLog(SQLTypeInfos.class);
    private static final TypeInfo[] TYPEINFO = new TypeInfo[]{new TypeInfo(-7, "bit", Boolean.class), new TypeInfo(-6, "tinyint", Byte.class), new TypeInfo(5, "smallint", Short.class), new TypeInfo(4, "integer", Integer.class), new TypeInfo(-5, "bigint", Long.class), new TypeInfo(6, "float", Double.class), new TypeInfo(8, "double", Double.class), new TypeInfo(7, "real", Float.class), new TypeInfo(2, "numeric", BigDecimal.class), new TypeInfo(3, "decimal", BigDecimal.class), new TypeInfo(1, "char", String.class), new TypeInfo(12, "varchar", String.class), new TypeInfo(-1, "longvarchar", String.class), new TypeInfo(91, "date", Date.class), new TypeInfo(92, "time", Time.class), new TypeInfo(93, "timestamp", Timestamp.class), new TypeInfo(-2, "binary", byte[].class), new TypeInfo(-3, "varbinary", byte[].class), new TypeInfo(-4, "longvarbinary", byte[].class), new TypeInfo(1111, "other", Object.class), new TypeInfo(2000, "javaobject", Object.class), new TypeInfo(2004, "blob", InputStream.class), new TypeInfo(2005, "clob", Clob.class)};
    private static final ThreadLocal THREAD_SAFE_CALENDAR = new ThreadLocal(){

        public Object initialValue() {
            return new GregorianCalendar();
        }
    };
    private static final TimeZone TIME_ZONE;

    private static Calendar getCalendar() {
        Calendar calendar = (Calendar)THREAD_SAFE_CALENDAR.get();
        calendar.setTimeZone(TIME_ZONE);
        return calendar;
    }

    public static Class sqlTypeNum2javaType(int sqlTypeNum) throws MappingException {
        for (int i = 0; i < TYPEINFO.length; ++i) {
            if (sqlTypeNum != TYPEINFO[i]._sqlTypeNum) continue;
            return TYPEINFO[i]._javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", (Object)new Integer(sqlTypeNum));
    }

    public static Class sqlTypeName2javaType(String sqlTypeName) throws MappingException {
        for (int i = 0; i < TYPEINFO.length; ++i) {
            if (!sqlTypeName.equals(TYPEINFO[i]._sqlTypeName)) continue;
            return TYPEINFO[i]._javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", (Object)sqlTypeName);
    }

    public static int javaType2sqlTypeNum(Class javaType) {
        for (int i = 0; i < TYPEINFO.length; ++i) {
            if (!javaType.isAssignableFrom(TYPEINFO[i]._javaType)) continue;
            return TYPEINFO[i]._sqlTypeNum;
        }
        return 1111;
    }

    public static Object getValue(ResultSet rs, int index, int sqlType) throws SQLException {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return rs.getString(index);
            }
            case 2: 
            case 3: {
                return rs.getBigDecimal(index);
            }
            case 4: {
                int intVal = rs.getInt(index);
                return rs.wasNull() ? null : new Integer(intVal);
            }
            case 92: {
                return rs.getTime(index, SQLTypeInfos.getCalendar());
            }
            case 91: {
                return rs.getDate(index);
            }
            case 93: {
                return rs.getTimestamp(index, SQLTypeInfos.getCalendar());
            }
            case 6: 
            case 8: {
                double doubleVal = rs.getDouble(index);
                return rs.wasNull() ? null : new Double(doubleVal);
            }
            case 7: {
                float floatVal = rs.getFloat(index);
                return rs.wasNull() ? null : new Float(floatVal);
            }
            case 5: {
                short shortVal = rs.getShort(index);
                return rs.wasNull() ? null : new Short(shortVal);
            }
            case -6: {
                byte byteVal = rs.getByte(index);
                return rs.wasNull() ? null : new Byte(byteVal);
            }
            case -4: 
            case -3: 
            case -2: {
                return rs.getBytes(index);
            }
            case 2004: {
                Blob blob = rs.getBlob(index);
                return blob == null ? null : blob.getBinaryStream();
            }
            case 2005: {
                return rs.getClob(index);
            }
            case -5: {
                long longVal = rs.getLong(index);
                return rs.wasNull() ? null : new Long(longVal);
            }
            case -7: {
                boolean boolVal = rs.getBoolean(index);
                return rs.wasNull() ? null : new Boolean(boolVal);
            }
        }
        Object value = rs.getObject(index);
        return rs.wasNull() ? null : value;
    }

    public static void setValue(PreparedStatement stmt, int index, Object value, int sqlType) {
        try {
            if (value == null) {
                stmt.setNull(index, sqlType);
            } else {
                switch (sqlType) {
                    case 6: 
                    case 8: {
                        stmt.setDouble(index, (Double)value);
                        break;
                    }
                    case 7: {
                        stmt.setFloat(index, ((Float)value).floatValue());
                        break;
                    }
                    case 92: {
                        stmt.setTime(index, (Time)value, SQLTypeInfos.getCalendar());
                        break;
                    }
                    case 91: {
                        stmt.setDate(index, (Date)value);
                        break;
                    }
                    case 93: {
                        stmt.setTimestamp(index, (Timestamp)value, SQLTypeInfos.getCalendar());
                        break;
                    }
                    case 2004: {
                        try {
                            InputStream stream = (InputStream)value;
                            stmt.setBinaryStream(index, stream, stream.available());
                            break;
                        }
                        catch (IOException ex) {
                            throw new SQLException(ex.toString());
                        }
                    }
                    case 2005: {
                        Clob clob = (Clob)value;
                        stmt.setCharacterStream(index, clob.getCharacterStream(), (int)Math.min(clob.length(), Integer.MAX_VALUE));
                        break;
                    }
                    default: {
                        stmt.setObject(index, value, sqlType);
                    }
                }
            }
        }
        catch (SQLException ex) {
            LOG.error((Object)"Unexpected SQL exception: ", (Throwable)ex);
        }
    }

    private SQLTypeInfos() {
    }

    static {
        AbstractProperties properties = CPAProperties.getInstance();
        String zone = properties.getString("org.exolab.castor.jdo.defaultTimeZone");
        TIME_ZONE = zone == null || zone.length() == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone(zone);
    }

    private static class TypeInfo {
        private final int _sqlTypeNum;
        private final String _sqlTypeName;
        private final Class _javaType;

        TypeInfo(int sqlTypeNum, String sqlTypeName, Class javaType) {
            this._sqlTypeNum = sqlTypeNum;
            this._sqlTypeName = sqlTypeName;
            this._javaType = javaType;
        }
    }
}

