/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.castor.core.util.IdentityMap;
import org.castor.core.util.IdentitySet;
import org.castor.core.util.Messages;
import org.castor.persist.proxy.LazyCGLIB;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

public final class ObjectTracker {
    private final Map _objectToMolder = new IdentityMap();
    private final Map _engineToOIDToObject = new HashMap();
    private final Map _objectToOID = new IdentityMap();
    private final Map _deletedMap = new IdentityMap();
    private final Map _creatingMap = new IdentityMap();
    private final Set _createdSet = new IdentitySet();
    private final Set _updatePersistNeededSet = new IdentitySet();
    private final Set _updateCacheNeededSet = new IdentitySet();
    private final Set _readOnlySet = new IdentitySet();
    private final Set _readWriteSet = new IdentitySet();
    private long _operation = Long.MIN_VALUE;

    public Object getObjectForOID(LockEngine engine, OID oid, boolean allowReadOnly) {
        Map oidToObject = (Map)this._engineToOIDToObject.get(engine);
        if (oidToObject != null) {
            Object found = oidToObject.get(oid);
            if (!allowReadOnly && this._readOnlySet.contains(found)) {
                return null;
            }
            return found;
        }
        return null;
    }

    public boolean isReadWrite(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._readWriteSet.contains(aObject);
    }

    public void unmarkAllDeleted() {
        ++this._operation;
        this._deletedMap.clear();
    }

    public void clear() {
        ++this._operation;
        this._createdSet.clear();
        this._creatingMap.clear();
        this._deletedMap.clear();
        this._engineToOIDToObject.clear();
        this._objectToMolder.clear();
        this._objectToOID.clear();
        this._readOnlySet.clear();
        this._readWriteSet.clear();
        this._updateCacheNeededSet.clear();
        this._updatePersistNeededSet.clear();
    }

    public boolean isUpdateCacheNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._updateCacheNeededSet.contains(aObject);
    }

    public boolean isUpdatePersistNeeded(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._updatePersistNeededSet.contains(aObject);
    }

    public void markUpdateCacheNeeded(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._updateCacheNeededSet.add(aObject);
    }

    public void unmarkUpdateCacheNeeded(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        this._updateCacheNeededSet.remove(aObject);
    }

    public Collection getObjectsWithUpdateCacheNeededState() {
        return new ArrayList(this._updateCacheNeededSet);
    }

    public void markUpdatePersistNeeded(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._updatePersistNeededSet.add(aObject);
        this._updateCacheNeededSet.add(aObject);
    }

    public void unmarkUpdatePersistNeeded(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        this._updatePersistNeededSet.remove(aObject);
    }

    public void markCreating(Object object) throws PersistenceException {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        if (this._createdSet.contains(aObject)) {
            throw new PersistenceException("Invalid state change; can't mark something  creating which is already marked created.");
        }
        this._creatingMap.put(aObject, new Long(this._operation));
    }

    public void markCreated(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._createdSet.add(aObject);
        this._creatingMap.remove(aObject);
    }

    public void markDeleted(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        if (!this.isTracking(aObject)) {
            return;
        }
        this._deletedMap.put(aObject, new Long(this._operation));
    }

    public void unmarkDeleted(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        this._deletedMap.remove(aObject);
    }

    public boolean isTracking(Object object) {
        Object aObject = this.supportCGLibObject(object);
        return this._objectToOID.containsKey(aObject);
    }

    public void trackOIDChange(Object obj, LockEngine engine, OID oldoid, OID newoid) {
        ++this._operation;
        Object object = this.supportCGLibObject(obj);
        this.removeOIDForObject(engine, oldoid);
        this.setOIDForObject(object, engine, newoid);
    }

    public void setOIDForObject(Object obj, LockEngine engine, OID oid) {
        ++this._operation;
        Object object = this.supportCGLibObject(obj);
        this.removeOIDForObject(engine, oid);
        HashMap<OID, Object> oidToObject = (HashMap<OID, Object>)this._engineToOIDToObject.get(engine);
        if (oidToObject == null) {
            oidToObject = new HashMap<OID, Object>();
            this._engineToOIDToObject.put(engine, oidToObject);
        }
        oidToObject.put(oid, obj);
        this._objectToOID.put(object, oid);
    }

    public void removeOIDForObject(LockEngine engine, OID oid) {
        ++this._operation;
        Object found = null;
        Map oidToObject = (Map)this._engineToOIDToObject.get(engine);
        if (oidToObject != null) {
            found = oidToObject.get(oid);
            oidToObject.remove(oid);
        }
        if (found != null) {
            this._objectToOID.remove(found);
        }
    }

    public boolean isCreating(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._creatingMap.containsKey(object);
    }

    public boolean isCreated(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._createdSet.contains(object);
    }

    public boolean isDeleted(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._deletedMap.containsKey(object);
    }

    public ClassMolder getMolderForObject(Object o) {
        Object object = this.supportCGLibObject(o);
        return (ClassMolder)this._objectToMolder.get(object);
    }

    private void setMolderForObject(Object obj, ClassMolder molder) {
        ++this._operation;
        Object object = this.supportCGLibObject(obj);
        this.removeMolderForObject(object);
        this._objectToMolder.put(object, molder);
    }

    private void removeMolderForObject(Object obj) {
        ++this._operation;
        Object object = this.supportCGLibObject(obj);
        this._objectToMolder.remove(object);
    }

    public Collection getReadWriteObjects() {
        ArrayList returnedList = new ArrayList(this._readWriteSet);
        return returnedList;
    }

    public Collection getReadOnlyObjects() {
        ArrayList returnedList = new ArrayList(this._readOnlySet);
        return returnedList;
    }

    public Collection getObjectsWithCreatingStateSortedByLowestMolderPriority() {
        ArrayList entryList = new ArrayList(this._creatingMap.entrySet());
        Collections.sort(entryList, new ObjectMolderPriorityComparator(this, false));
        ArrayList returnedList = new ArrayList(entryList.size());
        for (int i = 0; i < entryList.size(); ++i) {
            returnedList.add(entryList.get(i).getKey());
        }
        return returnedList;
    }

    public Collection getObjectsWithDeletedStateSortedByHighestMolderPriority() {
        ArrayList entryList = new ArrayList(this._deletedMap.entrySet());
        Collections.sort(entryList, new ObjectMolderPriorityComparator(this, true));
        ArrayList returnedList = new ArrayList(entryList.size());
        for (int i = 0; i < entryList.size(); ++i) {
            returnedList.add(entryList.get(i).getKey());
        }
        return returnedList;
    }

    public void trackObject(ClassMolder molder, OID oid, Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        this.setMolderForObject(aObject, molder);
        this.setOIDForObject(aObject, molder.getLockEngine(), oid);
        this._readWriteSet.add(aObject);
    }

    public void untrackObject(Object object) {
        ++this._operation;
        Object aObject = this.supportCGLibObject(object);
        LockEngine engine = this.getMolderForObject(aObject).getLockEngine();
        OID oid = this.getOIDForObject(aObject);
        this.removeMolderForObject(aObject);
        this.removeOIDForObject(engine, oid);
        this._deletedMap.remove(aObject);
        this._creatingMap.remove(aObject);
        this._createdSet.remove(aObject);
        this._updatePersistNeededSet.remove(aObject);
        this._updateCacheNeededSet.remove(aObject);
        this._readOnlySet.remove(aObject);
        this._readWriteSet.remove(aObject);
    }

    public OID getOIDForObject(Object o) {
        Object object = this.supportCGLibObject(o);
        return (OID)this._objectToOID.get(object);
    }

    public boolean isReadOnly(Object o) {
        Object object = this.supportCGLibObject(o);
        return this._readOnlySet.contains(object);
    }

    public void markReadOnly(Object o) {
        ++this._operation;
        Object object = this.supportCGLibObject(o);
        if (!this.isTracking(object)) {
            throw new IllegalStateException(Messages.format((String)"persist.internal", (Object)"Attempt to make read-only object that is not in transaction"));
        }
        this._readOnlySet.add(object);
        this._readWriteSet.remove(object);
    }

    public void unmarkReadOnly(Object o) {
        ++this._operation;
        Object object = this.supportCGLibObject(o);
        if (!this.isTracking(object)) {
            throw new IllegalStateException(Messages.format((String)"persist.internal", (Object)"Attempt to make read-write object that is not in transaction"));
        }
        this._readWriteSet.add(object);
        this._readOnlySet.remove(object);
    }

    public int readOnlySize() {
        return this._readOnlySet.size();
    }

    public int readWriteSize() {
        return this._readWriteSet.size();
    }

    private Object supportCGLibObject(Object object) {
        if (object instanceof LazyCGLIB) {
            LazyCGLIB cgObject = (LazyCGLIB)object;
            Identity identity = cgObject.interceptedIdentity();
            ClassMolder molder = cgObject.interceptedClassMolder();
            LockEngine engine = molder.getLockEngine();
            OID oid = new OID(molder, identity);
            return this.getObjectForOID(engine, oid, true);
        }
        return object;
    }

    public String allObjectStates() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this._objectToOID.keySet().iterator();
        while (it.hasNext()) {
            sb.append(this.objectStateToString(it.next()));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String objectStateToString(Object obj) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getOIDForObject(obj));
        sb.append('\t');
        sb.append("deleted: ");
        sb.append(this._deletedMap.containsKey(obj));
        sb.append('\t');
        sb.append("creating: ");
        sb.append(this._creatingMap.containsKey(obj));
        sb.append('\t');
        sb.append("created: ");
        sb.append(this._createdSet.contains(obj));
        return sb.toString();
    }

    private static final class ObjectMolderPriorityComparator
    implements Comparator {
        private ObjectTracker _tracker;
        private boolean _reverseOrder;

        public ObjectMolderPriorityComparator(ObjectTracker tracker, boolean reverseOrder) {
            this._tracker = tracker;
            this._reverseOrder = reverseOrder;
        }

        public int compare(Object object1, Object object2) {
            int pri2;
            Map.Entry entry1 = (Map.Entry)object1;
            Map.Entry entry2 = (Map.Entry)object2;
            long oper1 = (Long)entry1.getValue();
            long oper2 = (Long)entry2.getValue();
            ClassMolder molder1 = this._tracker.getMolderForObject(entry1.getKey());
            ClassMolder molder2 = this._tracker.getMolderForObject(entry2.getKey());
            if (molder1 == null || molder2 == null) {
                if (oper1 > oper2) {
                    return 1;
                }
                if (oper1 < oper2) {
                    return -1;
                }
                return 0;
            }
            int pri1 = molder1.getPriority();
            if (pri1 == (pri2 = molder2.getPriority())) {
                if (oper1 > oper2) {
                    return 1;
                }
                if (oper1 < oper2) {
                    return -1;
                }
                return 0;
            }
            if (this._reverseOrder) {
                return pri1 < pri2 ? 1 : -1;
            }
            return pri1 < pri2 ? -1 : 1;
        }
    }
}

