/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateFlags;
import org.castor.persist.proxy.RelationCollection;
import org.castor.persist.resolver.ManyRelationResolver;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.Lazy;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

public final class ManyToManyRelationResolver
extends ManyRelationResolver {
    public ManyToManyRelationResolver(ClassMolder classMolder, FieldMolder fieldMolder, int fieldIndex, boolean debug) {
        super(classMolder, fieldMolder, fieldIndex, debug);
    }

    public boolean markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            Iterator itor = ClassMolderHelper.getIterator(o);
            while (itor.hasNext()) {
                Object oo = itor.next();
                if (!tx.isAutoStore() || tx.isRecorded(oo)) continue;
                tx.markCreate(fieldClassMolder, oo, null);
                updateCache = true;
            }
        }
        return updateCache;
    }

    public void markDelete(TransactionContext tx, Object object, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        if (field != null) {
            ArrayList alist = (ArrayList)field;
            for (int j = 0; j < alist.size(); ++j) {
                Identity fid = (Identity)alist.get(j);
                Object fetched = null;
                if (fid == null || (fetched = tx.fetch(fieldClassMolder, fid, null)) == null) continue;
                fieldClassMolder.removeRelation(tx, fetched, this._classMolder, object);
            }
        }
        Iterator itor = ClassMolderHelper.getIterator(this._fieldMolder.getValue(object, tx.getClassLoader()));
        while (itor.hasNext()) {
            Object fobject = itor.next();
            if (fobject == null || !tx.isPersistent(fobject)) continue;
            fieldClassMolder.removeRelation(tx, fobject, this._classMolder, object);
        }
    }

    public UpdateFlags preStore(TransactionContext tx, OID oid, Object object, int timeout, Object field) throws PersistenceException {
        UpdateFlags flags;
        block14: {
            ArrayList added;
            Object value;
            ClassMolder fieldClassMolder;
            block13: {
                flags = new UpdateFlags();
                fieldClassMolder = this._fieldMolder.getFieldClassMolder();
                value = this._fieldMolder.getValue(object, tx.getClassLoader());
                ArrayList orgFields = (ArrayList)field;
                if (value instanceof Lazy) break block13;
                Collection removed = ClassMolderHelper.getRemovedIdsList(tx, orgFields, value, fieldClassMolder);
                Iterator removedItor = removed.iterator();
                if (removedItor.hasNext()) {
                    if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                        flags.setUpdatePersist(true);
                    }
                    flags.setUpdateCache(true);
                }
                while (removedItor.hasNext()) {
                    ProposedEntity proposedValue;
                    Object reldel;
                    Identity identity = (Identity)removedItor.next();
                    if (tx.isDeletedByOID(new OID(fieldClassMolder, identity)) || (reldel = tx.load(identity, proposedValue = new ProposedEntity(fieldClassMolder), null)) == null || !tx.isPersistent(reldel)) continue;
                    tx.writeLock(reldel, tx.getLockTimeout());
                    this._fieldMolder.getRelationLoader().deleteRelation(tx.getConnection(oid.getMolder().getLockEngine()), oid.getIdentity(), identity);
                    fieldClassMolder.removeRelation(tx, reldel, this._classMolder, object);
                }
                Collection added2 = ClassMolderHelper.getAddedValuesList(tx, orgFields, value, fieldClassMolder);
                Iterator addedItor = added2.iterator();
                if (addedItor.hasNext()) {
                    if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                        flags.setUpdatePersist(true);
                    }
                    flags.setUpdateCache(true);
                }
                while (addedItor.hasNext()) {
                    Object addedField = addedItor.next();
                    tx.markModified(addedField, false, true);
                    if (tx.isPersistent(addedField)) {
                        this._fieldMolder.getRelationLoader().createRelation(tx.getConnection(oid.getMolder().getLockEngine()), oid.getIdentity(), fieldClassMolder.getIdentity(tx, addedField));
                        continue;
                    }
                    if (!tx.isAutoStore() || tx.isDeleted(addedField)) continue;
                    tx.markCreate(fieldClassMolder, addedField, null);
                }
                break block14;
            }
            RelationCollection lazy = (RelationCollection)value;
            tx.addTxSynchronizable(lazy);
            ArrayList deleted = lazy.getDeleted();
            if (!deleted.isEmpty()) {
                if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                    flags.setUpdatePersist(true);
                }
                flags.setUpdateCache(true);
                Iterator itor = deleted.iterator();
                while (itor.hasNext()) {
                    flags.setUpdateCache(true);
                    Identity deletedId = (Identity)itor.next();
                    Object toBeDeleted = lazy.find(deletedId);
                    if (toBeDeleted == null || !tx.isPersistent(toBeDeleted)) continue;
                    tx.writeLock(toBeDeleted, 0);
                    this._fieldMolder.getRelationLoader().deleteRelation(tx.getConnection(oid.getMolder().getLockEngine()), oid.getIdentity(), deletedId);
                    fieldClassMolder.removeRelation(tx, toBeDeleted, this._classMolder, object);
                }
            }
            if ((added = lazy.getAdded()).isEmpty()) break block14;
            if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                flags.setUpdatePersist(true);
            }
            flags.setUpdateCache(true);
            for (Identity addedId : added) {
                Object toBeAdded = lazy.find(addedId);
                if (toBeAdded == null) continue;
                if (tx.isPersistent(toBeAdded)) {
                    this._fieldMolder.getRelationLoader().createRelation(tx.getConnection(oid.getMolder().getLockEngine()), oid.getIdentity(), addedId);
                    continue;
                }
                if (!tx.isAutoStore() || tx.isRecorded(toBeAdded)) continue;
                tx.markCreate(fieldClassMolder, toBeAdded, null);
            }
        }
        return flags;
    }

    public void update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, Object field) throws PersistenceException {
        ArrayList v = (ArrayList)field;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        if (tx.isAutoStore()) {
            ArrayList<Identity> newSetOfIds = new ArrayList<Identity>();
            Iterator itor = ClassMolderHelper.getIterator(this._fieldMolder.getValue(object, tx.getClassLoader()));
            while (itor.hasNext()) {
                Object element = itor.next();
                Identity actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                newSetOfIds.add(actualIdentity);
                if (tx.isRecorded(element)) continue;
                tx.markUpdate(fieldClassMolder, element, null);
            }
            if (v != null) {
                for (int j = 0; j < v.size(); ++j) {
                    if (newSetOfIds.contains(v.get(j))) continue;
                    ProposedEntity proposedValue = new ProposedEntity(fieldClassMolder);
                    tx.load((Identity)v.get(j), proposedValue, suggestedAccessMode);
                }
            }
        }
    }

    public Object postCreate(TransactionContext tx, OID oid, Object object, Object field, Identity createdId) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        Object result = field;
        if (o != null) {
            ArrayList fids = ClassMolderHelper.extractIdentityList(tx, fieldClassMolder, o);
            result = fids;
            Iterator itor = ClassMolderHelper.getIterator(o);
            while (itor.hasNext()) {
                Object oo = itor.next();
                if (!tx.isPersistent(oo)) continue;
                this._fieldMolder.getRelationLoader().createRelation(tx.getConnection(oid.getMolder().getLockEngine()), createdId, fieldClassMolder.getIdentity(tx, oo));
            }
        }
        return result;
    }

    public boolean updateWhenNoTimestampSet(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            Iterator itor = ClassMolderHelper.getIterator(o);
            while (itor.hasNext()) {
                boolean creating;
                Object oo = itor.next();
                if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldClassMolder, oo, null))) continue;
                updateCache = true;
            }
        }
        return updateCache;
    }
}

