/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dtx;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.castor.jdo.conf.DataSource;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.Driver;
import org.castor.jdo.conf.Mapping;
import org.castor.jdo.conf.Param;
import org.exolab.castor.dtx.DTXException;
import org.exolab.castor.dtx.DTXQuery;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTXEngine {
    private DocumentHandler _handler = null;
    private Database _database = null;
    private Schema _schema = null;
    private HashMap _classMappings = null;
    private Connection _conn = null;
    private PersistenceFactory _factory = null;

    public DTXEngine() {
    }

    public DTXEngine(String databaseURL, String schemaURL) throws DTXException {
        this.setDatabase(databaseURL);
        this.setSchema(schemaURL);
    }

    public void setSchema(String schemaURL) throws DTXException {
        try {
            SchemaReader reader = new SchemaReader(new InputSource(new URL(schemaURL).openStream()));
            this._schema = reader.read();
        }
        catch (IOException iox) {
            throw new DTXException(iox);
        }
        catch (Exception e) {
            throw new DTXException(e);
        }
    }

    public void setDatabase(String databaseURL) throws DTXException {
        Unmarshaller unm = new Unmarshaller(Database.class);
        unm.setEntityResolver((EntityResolver)new DTDResolver());
        try {
            this._database = (Database)unm.unmarshal(new InputSource(new URL(databaseURL).openStream()));
        }
        catch (Exception except) {
            throw new DTXException(except);
        }
        this._factory = this._database.getEngine() == null ? PersistenceFactoryRegistry.getPersistenceFactory("generic") : PersistenceFactoryRegistry.getPersistenceFactory(this._database.getEngine());
        if (this._factory == null) {
            throw new DTXException("no engine");
        }
        this._classMappings = new HashMap();
        Unmarshaller munm = new Unmarshaller(MappingRoot.class);
        Mapping[] mappings = this._database.getMapping();
        for (int i = 0; i < mappings.length; ++i) {
            try {
                URL mappingURL = new URL(new URL(databaseURL), mappings[i].getHref());
                MappingRoot mr = (MappingRoot)munm.unmarshal(new InputSource(mappingURL.openStream()));
                ClassMapping[] classMaps = mr.getClassMapping();
                for (int j = 0; j < classMaps.length; ++j) {
                    this._classMappings.put(classMaps[j].getName(), classMaps[j]);
                }
                continue;
            }
            catch (Exception e) {
                throw new DTXException(e);
            }
        }
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this._handler = handler;
    }

    public DTXQuery prepareQuery(String oql) throws DTXException {
        DTXQuery qry = new DTXQuery();
        qry.setEngine(this);
        qry.setHandler(this._handler);
        qry.prepare(oql);
        return qry;
    }

    Database getDatabase() {
        return this._database;
    }

    Schema getSchema() {
        return this._schema;
    }

    PersistenceFactory getFactory() {
        return this._factory;
    }

    Connection getConnection() throws DTXException {
        if (this._conn == null) {
            DataSource datasource = this._database.getDatabaseChoice().getDataSource();
            Driver driver = this._database.getDatabaseChoice().getDriver();
            if (datasource != null) {
                throw new DTXException("dtx.DataSourceUnimplemented");
            }
            if (driver != null) {
                try {
                    String className = driver.getClassName();
                    Class.forName(className);
                    String jdbcUrl = driver.getUrl();
                    Param[] params = driver.getParam();
                    Properties props = new Properties();
                    for (int i = 0; i < params.length; ++i) {
                        Param p = params[i];
                        props.setProperty(p.getName(), p.getValue());
                    }
                    this._conn = DriverManager.getConnection(jdbcUrl, props);
                }
                catch (Exception e) {
                    throw new DTXException(e);
                }
            }
        }
        return this._conn;
    }

    ClassMapping getClassMapping(String className) {
        return (ClassMapping)this._classMappings.get(className);
    }
}

