/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.KeyGeneratorFactoryRegistry;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.KeyGeneratorFactory;
import org.exolab.castor.persist.spi.PersistenceFactory;

final class KeyGeneratorRegistry {
    private static Log _log = LogFactory.getFactory().getInstance(KeyGeneratorRegistry.class);
    private Hashtable _keyGenerators = new Hashtable();

    KeyGeneratorRegistry() {
    }

    public KeyGenerator getKeyGenerator(PersistenceFactory factory, KeyGeneratorDescriptor descriptor, int sqlType) throws MappingException {
        String keyGeneratorName = descriptor.getName() + " " + sqlType;
        KeyGenerator keyGenerator = (KeyGenerator)this._keyGenerators.get(keyGeneratorName);
        if (keyGenerator == null) {
            KeyGeneratorFactory keyGeneratorFactory = KeyGeneratorFactoryRegistry.getKeyGeneratorFactory(descriptor.getKeyGeneratorFactoryName());
            if (keyGeneratorFactory != null && (keyGenerator = keyGeneratorFactory.getKeyGenerator(factory, descriptor.getParams(), sqlType)) != null && _log.isDebugEnabled()) {
                _log.debug((Object)("Key generator " + descriptor.getKeyGeneratorFactoryName() + " has been instantiated, parameters: " + descriptor.getParams()));
            }
            if (keyGenerator == null) {
                _log.warn((Object)Messages.format((String)"mapping.noKeyGen", (Object)descriptor.getKeyGeneratorFactoryName()));
                return null;
            }
            this._keyGenerators.put(keyGeneratorName, keyGenerator);
        }
        return keyGenerator;
    }
}

