/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.jdo.engine.SQLTypeInfos;
import org.exolab.castor.jdo.engine.SQLQuery;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.persist.spi.Identity;

public final class SQLHelper {
    private static final Log LOG = LogFactory.getLog(SQLQuery.class);

    public static Object[] calculateNumberOfFields(Collection extendingClassDescriptors, int numberOfIdentityColumns, int numberOfFields, int numberOfExtendLevels, ResultSet rs) throws SQLException {
        int initialColumnIndex;
        ClassDescriptor potentialLeafDescriptor = null;
        int suggestedNumberOfFields = numberOfFields;
        LinkedList potentialActualClassDescriptor = new LinkedList();
        int numberOfIdentitiesToAnalyze = 0;
        SQLHelper.addExtendingClassDescriptors(potentialActualClassDescriptor, extendingClassDescriptors);
        ClassDescriptor potentialClassDescriptor = null;
        ClassDescriptor potentialClassDescriptorPrevious = null;
        int columnIndex = initialColumnIndex = numberOfFields + numberOfIdentityColumns * numberOfExtendLevels + 1;
        int numberOfExtendingClassDescriptors = 0;
        Iterator iter = potentialActualClassDescriptor.iterator();
        while (iter.hasNext()) {
            potentialClassDescriptor = (ClassDescriptor)iter.next();
            ++numberOfExtendingClassDescriptors;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Potential extending class descriptor: " + potentialClassDescriptor.getJavaClass().getName()));
            }
            ClassDescriptorImpl cdi = (ClassDescriptorImpl)potentialClassDescriptor;
            FieldDescriptor[] identityDescriptors = cdi.getIdentities();
            boolean isNull = true;
            for (int i = 0; i < identityDescriptors.length; ++i) {
                Object temp;
                FieldDescriptorJDONature jdoFieldNature = new FieldDescriptorJDONature((PropertyHolder)identityDescriptors[i]);
                if (jdoFieldNature.getSQLName().length == 1) {
                    temp = SQLTypeInfos.getValue(rs, columnIndex++, 2000);
                } else {
                    Object[] temps = new Object[jdoFieldNature.getSQLName().length];
                    for (int j = 0; j < jdoFieldNature.getSQLName().length; ++j) {
                        temps[j] = SQLTypeInfos.getValue(rs, columnIndex++, 2000);
                    }
                    temp = new Identity(temps);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Obtained value " + temp + " for additional (extending) identity " + potentialClassDescriptor.getJavaClass().getName() + "/" + identityDescriptors[i].getFieldName() + " at position " + columnIndex));
                }
                boolean bl = isNull = temp == null;
                if (isNull) continue;
                ++numberOfIdentitiesToAnalyze;
                potentialClassDescriptorPrevious = potentialClassDescriptor;
            }
            if (!iter.hasNext() && !isNull && numberOfIdentitiesToAnalyze > 0) {
                potentialLeafDescriptor = potentialClassDescriptor;
                suggestedNumberOfFields += potentialClassDescriptor.getFields().length;
                continue;
            }
            if (!iter.hasNext() && isNull && numberOfIdentitiesToAnalyze > 0) {
                potentialLeafDescriptor = potentialClassDescriptorPrevious;
                continue;
            }
            FieldDescriptor[] potentialFields = potentialClassDescriptor.getFields();
            for (int i = 0; i < potentialFields.length; ++i) {
                String[] columnNames = new FieldDescriptorJDONature((PropertyHolder)potentialFields[i]).getSQLName();
                if (columnNames == null) continue;
                columnIndex += columnNames.length;
            }
            if (isNull) continue;
            suggestedNumberOfFields += potentialClassDescriptor.getFields().length;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("In total " + numberOfIdentitiesToAnalyze + " (extending) identities analyzed."));
            if (potentialLeafDescriptor != null) {
                LOG.debug((Object)("Most likely of type " + potentialLeafDescriptor.getJavaClass().getName()));
                LOG.debug((Object)("After analysis, " + suggestedNumberOfFields + " fields need to be loaded."));
            }
        }
        return new Object[]{potentialLeafDescriptor, new Integer(suggestedNumberOfFields)};
    }

    public static int numberOfExtendingClassDescriptors(ClassDescriptor classDescriptor) {
        int numberOfExtendLevels = 1;
        ClassDescriptor currentClassDescriptor = classDescriptor;
        while (currentClassDescriptor.getExtends() != null) {
            currentClassDescriptor = currentClassDescriptor.getExtends();
            ++numberOfExtendLevels;
        }
        return numberOfExtendLevels;
    }

    public static void addExtendingClassDescriptors(Collection classDescriptorsToAdd, Collection extendingClassDescriptors) {
        ClassDescriptor classDescriptor2 = null;
        for (ClassDescriptor classDescriptor2 : extendingClassDescriptors) {
            classDescriptorsToAdd.add(classDescriptor2);
            ClassDescriptorJDONature nature = new ClassDescriptorJDONature((PropertyHolder)classDescriptor2);
            SQLHelper.addExtendingClassDescriptors(classDescriptorsToAdd, nature.getExtended());
        }
    }

    public static String[] getIdentitySQLNames(ClassDescriptor desc) {
        FieldDescriptor[] identities = ((ClassDescriptorImpl)desc).getIdentities();
        String[] sqlNames = new String[identities.length];
        for (int i = 0; i < identities.length; ++i) {
            sqlNames[i] = new FieldDescriptorJDONature((PropertyHolder)identities[i]).getSQLName()[0];
        }
        return sqlNames;
    }

    private SQLHelper() {
    }
}

