/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.jdo.engine.CounterRef;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLHelper;
import org.exolab.castor.jdo.engine.SqlBindParser;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;

public final class SQLQuery
implements PersistenceQuery {
    private static final Log LOG = LogFactory.getLog(SQLQuery.class);
    private PreparedStatement _stmt;
    private ResultSet _rs;
    private SQLEngine _engine;
    private final SQLEngine _requestedEngine;
    private final PersistenceFactory _requestedFactory;
    private final Class[] _types;
    private final Object[] _values;
    private final String _sql;
    private Object[] _lastIdentity;
    private int[] _identSqlType;
    private boolean _resultSetDone;
    private Object[] _fields;
    private boolean _isCallSql = false;

    SQLQuery(SQLEngine engine, PersistenceFactory factory, String sql, Class[] types, boolean isCallSql) {
        this._engine = engine;
        this._requestedEngine = engine;
        this._requestedFactory = factory;
        this._types = types;
        this._values = new Object[this._types.length];
        this._sql = sql;
        ClassDescriptorImpl cdi = (ClassDescriptorImpl)this._engine.getDescriptor();
        this._identSqlType = new int[cdi.getIdentities().length];
        for (int i = 0; i < this._identSqlType.length; ++i) {
            FieldDescriptor fldDesc = cdi.getIdentities()[i];
            this._identSqlType[i] = new FieldDescriptorJDONature((PropertyHolder)fldDesc).getSQLType()[0];
        }
        this._isCallSql = isCallSql;
    }

    public void setParameter(int index, Object value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        this._values[index] = value;
    }

    public Class getResultType() {
        return this._engine.getDescriptor().getJavaClass();
    }

    public boolean absolute(int row) throws PersistenceException {
        boolean retval = false;
        try {
            if (this._rs != null) {
                retval = this._rs.absolute(row);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
        return retval;
    }

    public int size() throws PersistenceException {
        int whereIAm = 1;
        int retval = 0;
        try {
            if (this._rs != null) {
                whereIAm = this._rs.getRow();
                retval = this._rs.last() ? this._rs.getRow() : 0;
                if (whereIAm > 0) {
                    this._rs.absolute(whereIAm);
                } else {
                    this._rs.beforeFirst();
                }
            }
        }
        catch (SQLException se) {
            throw new PersistenceException(se.getMessage());
        }
        return retval;
    }

    public void execute(Object conn, AccessMode accessMode, boolean scrollable) throws PersistenceException {
        String sql = SqlBindParser.getJdbcSql(this._sql);
        this._lastIdentity = null;
        try {
            this._stmt = scrollable ? ((Connection)conn).prepareStatement(sql, 1004, 1007) : ((Connection)conn).prepareStatement(sql);
            SqlBindParser.bindJdbcValues(this._stmt, this._sql, this._values);
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.executingSql", (Object)sql));
            }
            this._rs = this._stmt.executeQuery();
            this._resultSetDone = false;
        }
        catch (SQLException except) {
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (SQLException e2) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e2);
                }
            }
            this._resultSetDone = true;
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except) + " while executing " + this._sql, except);
        }
    }

    private Identity loadIdentity() throws SQLException {
        if (this._resultSetDone) {
            return null;
        }
        Object[] returnId = new Object[this._engine.getColumnInfoForIdentities().length];
        boolean empty = true;
        for (int i = 0; i < this._engine.getColumnInfoForIdentities().length; ++i) {
            Object tmp = SQLTypeInfos.getValue(this._rs, 1 + i, this._identSqlType[i]);
            returnId[i] = this._engine.getColumnInfoForIdentities()[i].toJava(tmp);
            if (tmp == null) continue;
            empty = false;
        }
        if (empty) {
            return null;
        }
        return new Identity(returnId);
    }

    public Identity nextIdentity(Identity identity) throws PersistenceException {
        Identity nextIdentity = null;
        try {
            if (this._lastIdentity == null && (this._resultSetDone || !this._rs.next())) {
                this._resultSetDone = true;
                return null;
            }
            this._lastIdentity = this.identityToSQL(identity);
            nextIdentity = this.loadIdentity();
            if (this.identitiesEqual(this._lastIdentity, this.identityToSQL(nextIdentity))) {
                this.fetchRaw();
            }
            nextIdentity = this.loadIdentity();
            this.fetchRaw();
        }
        catch (SQLException except) {
            this._lastIdentity = null;
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
        return nextIdentity;
    }

    public void close() {
        if (this._rs != null) {
            try {
                this._rs.close();
            }
            catch (SQLException except) {
                LOG.warn((Object)"Problem closing JDBC ResultSet", (Throwable)except);
            }
            this._rs = null;
        }
        if (this._stmt != null) {
            try {
                this._stmt.close();
            }
            catch (SQLException except) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except);
            }
            this._stmt = null;
        }
    }

    private Object[] identityToSQL(Identity identity) {
        Object[] sqlIdentity = new Object[this._engine.getColumnInfoForIdentities().length];
        if (identity != null) {
            for (int i = 0; i < this._engine.getColumnInfoForIdentities().length; ++i) {
                sqlIdentity[i] = identity.get(i);
            }
        }
        return sqlIdentity;
    }

    private Object loadSingleField(int i, CounterRef counterReference) throws SQLException {
        Object field;
        String currentTableName = counterReference.getTableName();
        int count = counterReference.getCounter();
        String fieldTableName = this._engine.getInfo()[i].getTableName();
        String fieldColumnName = this._engine.getInfo()[i].getColumnInfo()[0].getName();
        String fieldName = fieldTableName + "." + fieldColumnName;
        ResultSetMetaData metaData = this._rs.getMetaData();
        while (true) {
            String metaTableName = metaData.getTableName(count);
            String metaColumnName = metaData.getColumnName(count);
            if (fieldColumnName.equalsIgnoreCase(metaColumnName) ? this._isCallSql || fieldTableName.equalsIgnoreCase(metaTableName) || "".equals(metaTableName) : fieldName.equalsIgnoreCase(metaColumnName)) break;
            ++count;
        }
        SQLFieldInfo info = this._engine.getInfo()[i];
        if (!info.isJoined() && info.getJoinFields() == null) {
            field = info.getColumnInfo()[0].toJava(SQLTypeInfos.getValue(this._rs, count, info.getColumnInfo()[0].getSqlType()));
            ++count;
        } else {
            boolean notNull = false;
            Object[] temp = new Object[info.getColumnInfo().length];
            for (int j = 0; j < info.getColumnInfo().length; ++j) {
                temp[j] = info.getColumnInfo()[j].toJava(SQLTypeInfos.getValue(this._rs, count, info.getColumnInfo()[j].getSqlType()));
                ++count;
                if (temp[j] == null) continue;
                notNull = true;
            }
            field = notNull ? new Identity(temp) : null;
        }
        counterReference.setCounter(count);
        counterReference.setTableName(currentTableName);
        return field;
    }

    private Object loadMultiField(int i, CounterRef counterReference, Object field) throws SQLException {
        Identity identity;
        int count = counterReference.getCounter();
        String fieldTableName = this._engine.getInfo()[i].getTableName();
        String firstColumnOfField = this._engine.getInfo()[i].getColumnInfo()[0].getName();
        ResultSetMetaData metaData = this._rs.getMetaData();
        String columnNamePerMetaData = metaData.getColumnName(count);
        String tableNamePerMetaData = metaData.getTableName(count);
        while (!firstColumnOfField.equalsIgnoreCase(columnNamePerMetaData) || !fieldTableName.equalsIgnoreCase(tableNamePerMetaData) && !tableNamePerMetaData.startsWith(fieldTableName) && !"".equals(tableNamePerMetaData)) {
            columnNamePerMetaData = metaData.getColumnName(++count);
            tableNamePerMetaData = metaData.getTableName(count);
        }
        ArrayList<Identity> res = field == null ? new ArrayList<Identity>() : (ArrayList)field;
        SQLFieldInfo info = this._engine.getInfo()[i];
        boolean notNull = false;
        Object[] temp = new Object[info.getColumnInfo().length];
        for (int j = 0; j < info.getColumnInfo().length; ++j) {
            temp[j] = info.getColumnInfo()[j].toJava(SQLTypeInfos.getValue(this._rs, count, info.getColumnInfo()[j].getSqlType()));
            if (temp[j] != null) {
                notNull = true;
            }
            ++count;
        }
        if (notNull && !res.contains(identity = new Identity(temp))) {
            res.add(identity);
        }
        counterReference.setCounter(count);
        return res;
    }

    private int loadRow(Object[] fields, int numberOfFields, boolean isFirst) throws SQLException {
        int count = this._engine.getColumnInfoForIdentities().length + 1;
        String tableName = null;
        if (numberOfFields > 0) {
            tableName = this._engine.getInfo()[0].getTableName();
            CounterRef counterReference = new CounterRef();
            counterReference.setCounter(count);
            counterReference.setTableName(tableName);
            for (int i = 0; i < numberOfFields; ++i) {
                if (this._engine.getInfo()[i].isMulti()) {
                    counterReference.setCounter(count);
                    fields[i] = this.loadMultiField(i, counterReference, fields[i]);
                    count = counterReference.getCounter();
                    continue;
                }
                if (!isFirst) continue;
                counterReference.setCounter(count);
                fields[i] = this.loadSingleField(i, counterReference);
                count = counterReference.getCounter();
            }
        }
        return count;
    }

    private Object[] loadSQLIdentity() throws SQLException {
        Object[] identity = new Object[this._engine.getColumnInfoForIdentities().length];
        for (int i = 0; i < this._engine.getColumnInfoForIdentities().length; ++i) {
            identity[i] = SQLTypeInfos.getValue(this._rs, 1 + i, this._identSqlType[i]);
        }
        return identity;
    }

    private boolean identitiesEqual(Object[] wantedIdentity, Object[] currentIdentity) {
        for (int i = 0; i < wantedIdentity.length; ++i) {
            if (!(wantedIdentity[i] == null || currentIdentity[i] == null ? wantedIdentity[i] != currentIdentity[i] : !wantedIdentity[i].toString().equals(currentIdentity[i].toString()))) continue;
            return false;
        }
        return true;
    }

    public void fetch(ProposedEntity proposedObject) throws PersistenceException {
        for (int i = 0; i < this._fields.length; ++i) {
            proposedObject.setField(this._fields[i], i);
        }
    }

    private Object fetchRaw() throws PersistenceException {
        int originalFieldNumber = this._requestedEngine.getInfo().length;
        Collection<ClassDescriptor> extendingClassDescriptors = new ClassDescriptorJDONature((PropertyHolder)this._requestedEngine.getDescriptor()).getExtended();
        if (extendingClassDescriptors.size() > 0) {
            int numberOfExtendLevels = SQLHelper.numberOfExtendingClassDescriptors(this._requestedEngine.getDescriptor());
            ClassDescriptor leafDescriptor = null;
            Object[] returnValues = null;
            try {
                returnValues = SQLHelper.calculateNumberOfFields(extendingClassDescriptors, this._requestedEngine.getColumnInfoForIdentities().length, this._requestedEngine.getInfo().length, numberOfExtendLevels, this._rs);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem calculating number of concrete fields.", (Throwable)e);
                throw new PersistenceException("Problem calculating number of concrete fields.", e);
            }
            leafDescriptor = (ClassDescriptor)returnValues[0];
            this._engine = this._requestedEngine;
            if (leafDescriptor != null && !leafDescriptor.getJavaClass().getName().equals(this._requestedEngine.getDescriptor().getJavaClass().getName())) {
                originalFieldNumber = (Integer)returnValues[1];
                Persistence newEngine = null;
                try {
                    newEngine = this._requestedFactory.getPersistence(leafDescriptor);
                }
                catch (MappingException e) {
                    LOG.error((Object)("Problem obtaining persistence engine for " + leafDescriptor.getJavaClass().getName()), (Throwable)e);
                    throw new PersistenceException("Problem obtaining persistence engine for " + leafDescriptor.getJavaClass().getName(), e);
                }
                this._engine = (SQLEngine)newEngine;
            }
        }
        this._fields = new Object[originalFieldNumber];
        if (this._resultSetDone) {
            return null;
        }
        Object stamp = null;
        try {
            Object[] wantedIdentity = this.loadSQLIdentity();
            this.loadRow(this._fields, originalFieldNumber, true);
            while (this._rs.next()) {
                Object[] currentIdentity = this.loadSQLIdentity();
                if (this.identitiesEqual(wantedIdentity, currentIdentity)) {
                    this.loadRow(this._fields, originalFieldNumber, false);
                    continue;
                }
                this._lastIdentity = currentIdentity;
                return stamp;
            }
            this._resultSetDone = true;
            this._lastIdentity = null;
        }
        catch (SQLException except) {
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
        return null;
    }
}

