/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.core.exceptions.CastorIllegalStateException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLStatementLookup;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;

public class SQLStatementCreate {
    private static final Log LOG = LogFactory.getLog(SQLStatementCreate.class);
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private KeyGenerator _keyGen;
    private final boolean _useJDBC30;
    private SQLStatementLookup _lookupStatement;
    private String _statement;

    public SQLStatementCreate(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName();
        this._keyGen = this.getKeyGenerator(engine, factory);
        AbstractProperties properties = CPAProperties.getInstance();
        this._useJDBC30 = properties.getBoolean("org.castor.jdo.use.jdbc30", false);
        this._lookupStatement = new SQLStatementLookup(engine, factory);
        this.buildStatement();
    }

    private KeyGenerator getKeyGenerator(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        KeyGeneratorDescriptor keyGenDesc;
        KeyGenerator keyGen = null;
        if (engine.getDescriptor().getExtends() == null && (keyGenDesc = new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getKeyGeneratorDescriptor()) != null) {
            FieldDescriptor fldDesc = engine.getDescriptor().getIdentity();
            int[] tempType = new FieldDescriptorJDONature((PropertyHolder)fldDesc).getSQLType();
            keyGen = keyGenDesc.getKeyGeneratorRegistry().getKeyGenerator(factory, keyGenDesc, tempType == null ? 0 : tempType[0]);
            keyGen.supportsSqlType(tempType[0]);
        }
        return keyGen;
    }

    private void buildStatement() {
        if (this._keyGen == null) {
            this.buildStatementWithIdentities();
        } else if (this._keyGen.getStyle() == -1) {
            this.buildStatementWithIdentities();
        } else if (this._keyGen.getStyle() == 0) {
            this.buildStatementWithoutIdentities();
            try {
                SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
                this._statement = this._keyGen.patchSQL(this._statement, ids[0].getName());
                this._statement = "{call " + this._statement + "}";
            }
            catch (MappingException except) {
                LOG.fatal((Object)except);
                this._keyGen = null;
                this.buildStatementWithIdentities();
            }
        } else if (this._keyGen.getStyle() == 1) {
            this.buildStatementWithoutIdentities();
            try {
                SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
                this._statement = this._keyGen.patchSQL(this._statement, ids[0].getName());
            }
            catch (MappingException except) {
                LOG.fatal((Object)except);
                this._keyGen = null;
                this.buildStatementWithIdentities();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)this._statement));
        }
    }

    private void buildStatementWithIdentities() {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO ");
        insert.append(this._factory.quoteName(this._mapTo));
        insert.append(" (");
        StringBuffer values = new StringBuffer();
        values.append(" VALUES (");
        int count = 0;
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        for (int i = 0; i < ids.length; ++i) {
            if (count > 0) {
                insert.append(',');
                values.append(',');
            }
            insert.append(this._factory.quoteName(ids[i].getName()));
            values.append('?');
            ++count;
        }
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                if (count > 0) {
                    insert.append(',');
                    values.append(',');
                }
                insert.append(this._factory.quoteName(columns[j].getName()));
                values.append('?');
                ++count;
            }
        }
        insert.append(')');
        values.append(')');
        this._statement = insert.append(values).toString();
    }

    private void buildStatementWithoutIdentities() {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO ");
        insert.append(this._factory.quoteName(this._mapTo));
        insert.append(" (");
        StringBuffer values = new StringBuffer();
        values.append(" VALUES (");
        int count = 0;
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                if (count > 0) {
                    insert.append(',');
                    values.append(',');
                }
                insert.append(this._factory.quoteName(columns[j].getName()));
                values.append('?');
                ++count;
            }
        }
        if (count == 0) {
            insert.setLength(insert.length() - 2);
        } else {
            insert.append(')');
        }
        values.append(')');
        this._statement = insert.append(values).toString();
    }

    public Object executeStatement(Database database, Connection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        if (this._keyGen == null) {
            return this.executeStatementNoKeygen(database, conn, identity, entity);
        }
        if (this._keyGen.getStyle() == -1) {
            return this.executeStatementBeforeInsert(database, conn, identity, entity);
        }
        if (this._keyGen.getStyle() == 0) {
            return this.executeStatementDuringInsert(database, conn, identity, entity);
        }
        if (this._keyGen.getStyle() == 1) {
            return this.executeStatementAfterInsert(database, conn, identity, entity);
        }
        throw new PersistenceException("unknown key generator");
    }

    public Object executeStatementNoKeygen(Database database, Connection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        Identity internalIdentity = identity;
        SQLEngine extended = this._engine.getExtends();
        if (extended == null && internalIdentity == null) {
            throw new PersistenceException(Messages.format((String)"persist.noIdentity", (Object)this._type));
        }
        PreparedStatement stmt = null;
        try {
            ClassDescriptor extDesc;
            if (extended != null && !new ClassDescriptorJDONature((PropertyHolder)(extDesc = extended.getDescriptor())).getTableName().equals(this._mapTo)) {
                internalIdentity = extended.create(database, conn, entity, internalIdentity);
            }
            stmt = conn.prepareStatement(this._statement);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            if (internalIdentity.size() != ids.length) {
                throw new PersistenceException("Size of identity field mismatched!");
            }
            int count = 1;
            for (int i = 0; i < ids.length; ++i) {
                stmt.setObject(count++, ids[i].toSQL(internalIdentity.get(i)));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            count = this.bindFields(entity, stmt, count);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            stmt.executeUpdate();
            stmt.close();
            return internalIdentity;
        }
        catch (SQLException except) {
            LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)this._statement), (Throwable)except);
            Boolean isDupKey = this._factory.isDuplicateKeyException(except);
            if (Boolean.TRUE.equals(isDupKey)) {
                throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)this._type, (Object)internalIdentity), except);
            }
            if (Boolean.FALSE.equals(isDupKey)) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            if (internalIdentity == null) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            this._lookupStatement.executeStatement(conn, internalIdentity);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
    }

    public Object executeStatementBeforeInsert(Database database, Connection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        Identity internalIdentity = identity;
        SQLEngine extended = this._engine.getExtends();
        PreparedStatement stmt = null;
        try {
            ClassDescriptor extDesc;
            if (extended != null && !new ClassDescriptorJDONature((PropertyHolder)(extDesc = extended.getDescriptor())).getTableName().equals(this._mapTo)) {
                internalIdentity = extended.create(database, conn, entity, internalIdentity);
            }
            internalIdentity = this.generateKey(database, conn, null);
            stmt = conn.prepareStatement(this._statement);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            if (internalIdentity.size() != ids.length) {
                throw new PersistenceException("Size of identity field mismatched!");
            }
            int count = 1;
            for (int i = 0; i < ids.length; ++i) {
                stmt.setObject(count++, ids[i].toSQL(internalIdentity.get(i)));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            count = this.bindFields(entity, stmt, count);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            stmt.executeUpdate();
            stmt.close();
            return internalIdentity;
        }
        catch (SQLException except) {
            LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)this._statement), (Throwable)except);
            Boolean isDupKey = this._factory.isDuplicateKeyException(except);
            if (Boolean.TRUE.equals(isDupKey)) {
                throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)this._type, (Object)internalIdentity), except);
            }
            if (Boolean.FALSE.equals(isDupKey)) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            if (internalIdentity == null) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            this._lookupStatement.executeStatement(conn, internalIdentity);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
    }

    public Object executeStatementDuringInsert(Database database, Connection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        Identity internalIdentity = identity;
        SQLEngine extended = this._engine.getExtends();
        CallableStatement stmt = null;
        try {
            ClassDescriptor extDesc;
            if (extended != null && !new ClassDescriptorJDONature((PropertyHolder)(extDesc = extended.getDescriptor())).getTableName().equals(this._mapTo)) {
                internalIdentity = extended.create(database, conn, entity, internalIdentity);
            }
            stmt = conn.prepareCall(this._statement);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            int count = 1;
            count = this.bindFields(entity, stmt, count);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            CallableStatement cstmt = stmt;
            int sqlType = ids[0].getSqlType();
            cstmt.registerOutParameter(count, sqlType);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)cstmt.toString()));
            }
            cstmt.execute();
            while (cstmt.getMoreResults() || cstmt.getUpdateCount() != -1) {
            }
            Object temp = sqlType == 4 ? new Integer(cstmt.getInt(count)) : cstmt.getObject(count);
            internalIdentity = new Identity(ids[0].toJava(temp));
            stmt.close();
            return internalIdentity;
        }
        catch (SQLException except) {
            LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)this._statement), (Throwable)except);
            Boolean isDupKey = this._factory.isDuplicateKeyException(except);
            if (Boolean.TRUE.equals(isDupKey)) {
                throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)this._type, (Object)internalIdentity), except);
            }
            if (Boolean.FALSE.equals(isDupKey)) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            if (internalIdentity == null) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            this._lookupStatement.executeStatement(conn, internalIdentity);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
    }

    public Object executeStatementAfterInsert(Database database, Connection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        Identity internalIdentity = identity;
        SQLEngine extended = this._engine.getExtends();
        PreparedStatement stmt = null;
        try {
            ClassDescriptor extDesc;
            if (extended != null && !new ClassDescriptorJDONature((PropertyHolder)(extDesc = extended.getDescriptor())).getTableName().equals(this._mapTo)) {
                internalIdentity = extended.create(database, conn, entity, internalIdentity);
            }
            if (internalIdentity == null && this._useJDBC30) {
                Field field = Statement.class.getField("RETURN_GENERATED_KEYS");
                Integer rgk = (Integer)field.get(this._statement);
                Class[] types = new Class[]{String.class, Integer.TYPE};
                Object[] args = new Object[]{this._statement, rgk};
                Method method = Connection.class.getMethod("prepareStatement", types);
                stmt = (PreparedStatement)method.invoke((Object)conn, args);
            } else {
                stmt = conn.prepareStatement(this._statement);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            int count = 1;
            count = this.bindFields(entity, stmt, count);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._type, (Object)stmt.toString()));
            }
            stmt.executeUpdate();
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            if (internalIdentity == null) {
                if (this._useJDBC30) {
                    Class<PreparedStatement> cls = PreparedStatement.class;
                    Method method = cls.getMethod("getGeneratedKeys", null);
                    ResultSet keySet = (ResultSet)method.invoke((Object)stmt, (Object[])null);
                    int i = 1;
                    ArrayList<Object> keys = new ArrayList<Object>();
                    while (keySet.next()) {
                        int sqlType = ids[i - 1].getSqlType();
                        Object temp = sqlType == 4 ? new Integer(keySet.getInt(i)) : (sqlType == 2 ? keySet.getBigDecimal(i) : keySet.getObject(i));
                        keys.add(ids[i - 1].toJava(temp));
                        ++i;
                    }
                    internalIdentity = new Identity(keys.toArray());
                    stmt.close();
                } else {
                    stmt.close();
                    internalIdentity = this.generateKey(database, conn, stmt);
                }
            }
            return internalIdentity;
        }
        catch (SQLException except) {
            LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)this._statement), (Throwable)except);
            Boolean isDupKey = this._factory.isDuplicateKeyException(except);
            if (Boolean.TRUE.equals(isDupKey)) {
                throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)this._type, (Object)internalIdentity), except);
            }
            if (Boolean.FALSE.equals(isDupKey)) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            if (internalIdentity == null) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
            this._lookupStatement.executeStatement(conn, internalIdentity);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
        catch (NoSuchMethodException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
        catch (NoSuchFieldException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Identity generateKey(Database database, Connection conn, PreparedStatement stmt) throws PersistenceException {
        SQLColumnInfo id = this._engine.getColumnInfoForIdentities()[0];
        Connection connection = conn;
        if (!this._keyGen.isInSameConnection()) {
            connection = this.getSeparateConnection(database);
        }
        Properties prop = null;
        if (stmt != null) {
            prop = new Properties();
            prop.put("insertStatement", stmt);
        }
        try {
            Object identity;
            Object object = connection;
            synchronized (object) {
                identity = this._keyGen.generateKey(connection, this._mapTo, id.getName(), prop);
            }
            if (identity == null) {
                throw new PersistenceException(Messages.format((String)"persist.noIdentity", (Object)this._type));
            }
            object = new Identity(id.toJava(identity));
            Object var11_10 = null;
            if (!this._keyGen.isInSameConnection()) {
                this.closeSeparateConnection(connection);
            }
            return object;
        }
        catch (Throwable throwable) {
            block9: {
                Object var11_11 = null;
                if (this._keyGen.isInSameConnection()) break block9;
                this.closeSeparateConnection(connection);
            }
            throw throwable;
        }
    }

    private int bindFields(ProposedEntity entity, PreparedStatement stmt, int count) throws SQLException, PersistenceException {
        int internalCount = count;
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            if (!fields[i].isStore()) continue;
            Object value = entity.getField(i);
            if (value == null) {
                for (int j = 0; j < columns.length; ++j) {
                    stmt.setNull(internalCount++, columns[j].getSqlType());
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity identity = (Identity)value;
                if (identity.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    SQLTypeInfos.setValue(stmt, internalCount++, columns[j].toSQL(identity.get(j)), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            SQLTypeInfos.setValue(stmt, internalCount++, columns[0].toSQL(value), columns[0].getSqlType());
        }
        return internalCount;
    }

    private Connection getSeparateConnection(Database database) throws PersistenceException {
        AbstractConnectionFactory factory = null;
        try {
            factory = DatabaseRegistry.getConnectionFactory(database.getDatabaseName());
        }
        catch (MappingException e) {
            throw new PersistenceException(Messages.message((String)"persist.cannotCreateSeparateConn"), e);
        }
        try {
            Connection conn = factory.createConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            throw new PersistenceException(Messages.message((String)"persist.cannotCreateSeparateConn"), e);
        }
    }

    private void closeSeparateConnection(Connection conn) {
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

